/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.transport;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import com.ledger.lib.transport.GattUtils;
import com.ledger.lib.utils.Dump;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;

public class GattCallback
extends BluetoothGattCallback {
    private BlockingQueue<GattEvent> queue;

    public GattCallback(BlockingQueue<GattEvent> queue) {
        this.queue = queue;
    }

    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        byte[] data = Arrays.copyOf(characteristic.getValue(), characteristic.getValue().length);
        this.queue.add(new GattEvent(GattEventType.GATT_CHARACTERISTIC_CHANGED, characteristic.getUuid(), 0, data));
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        byte[] data = null;
        if (status == 0) {
            data = Arrays.copyOf(characteristic.getValue(), characteristic.getValue().length);
        }
        this.queue.add(new GattEvent(GattEventType.GATT_CHARACTERISTIC_READ, characteristic.getUuid(), status, data));
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        this.queue.add(new GattEvent(GattEventType.GATT_CHARACTERISTIC_WRITE, characteristic.getUuid(), status));
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        this.queue.add(new GattEvent(GattEventType.GATT_CONNECTION_STATE_CHANGE, null, status, null, newState, 0));
    }

    public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        byte[] data = null;
        if (status == 0) {
            data = Arrays.copyOf(descriptor.getValue(), descriptor.getValue().length);
        }
        this.queue.add(new GattEvent(GattEventType.GATT_DESCRIPTOR_READ, descriptor.getUuid(), status, data));
    }

    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        this.queue.add(new GattEvent(GattEventType.GATT_DESCRIPTOR_WRITE, descriptor.getUuid(), status));
    }

    public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
        this.queue.add(new GattEvent(GattEventType.GATT_MTU_CHANGED, null, status, null, 0, mtu));
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        this.queue.add(new GattEvent(GattEventType.GATT_SERVICES_DISCOVERED, null, status));
    }

    class GattEvent {
        private GattEventType eventType;
        private UUID uuid;
        private byte[] data;
        private int status;
        private int newState;
        private int mtu;

        public GattEvent(GattEventType eventType, UUID uuid, int status, byte[] data, int newState, int mtu) {
            this.eventType = eventType;
            this.uuid = uuid;
            this.status = status;
            this.data = data;
            this.newState = newState;
            this.mtu = mtu;
        }

        public GattEvent(GattEventType eventType, UUID uuid, int status, byte[] data) {
            this.eventType = eventType;
            this.uuid = uuid;
            this.status = status;
            this.data = data;
        }

        public GattEvent(GattEventType eventType, UUID uuid, int status) {
            this.eventType = eventType;
            this.uuid = uuid;
            this.status = status;
        }

        public GattEventType getEventType() {
            return this.eventType;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int getStatus() {
            return this.status;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getNewState() {
            return this.newState;
        }

        public int getMtu() {
            return this.mtu;
        }

        public String toString() {
            switch (this.eventType) {
                case GATT_CHARACTERISTIC_CHANGED: {
                    return "GATT_CHARACTERISTIC_CHANGED " + this.uuid.toString();
                }
                case GATT_CHARACTERISTIC_READ: {
                    return "GATT_CHARACTERISTIC_READ " + this.uuid.toString() + " " + GattUtils.statusToString(this.status) + " " + Dump.dump(this.data);
                }
                case GATT_CHARACTERISTIC_WRITE: {
                    return "GATT_CHARACTERISTIC_WRITE " + this.uuid.toString() + " " + GattUtils.statusToString(this.status);
                }
                case GATT_CONNECTION_STATE_CHANGE: {
                    return "GATT_CONNECTION_STATE_CHANGE " + GattUtils.statusToString(this.status) + " " + GattUtils.stateToString(this.newState);
                }
                case GATT_DESCRIPTOR_READ: {
                    return "GATT_DESCRIPTOR_READ " + this.uuid.toString() + " " + GattUtils.statusToString(this.status) + " " + Dump.dump(this.data);
                }
                case GATT_DESCRIPTOR_WRITE: {
                    return "GATT_DESCRIPTOR_WRITE " + this.uuid.toString() + " " + GattUtils.statusToString(this.status);
                }
                case GATT_MTU_CHANGED: {
                    return "GATT_MTU_CHANGED " + this.mtu + " " + GattUtils.statusToString(this.status);
                }
                case GATT_SERVICES_DISCOVERED: {
                    return "GATT_SERVICES_DISCOVERED " + GattUtils.statusToString(this.status);
                }
            }
            return "Unsupported event";
        }
    }

    static enum GattEventType {
        GATT_CHARACTERISTIC_CHANGED,
        GATT_CHARACTERISTIC_READ,
        GATT_CHARACTERISTIC_WRITE,
        GATT_CONNECTION_STATE_CHANGE,
        GATT_DESCRIPTOR_READ,
        GATT_DESCRIPTOR_WRITE,
        GATT_MTU_CHANGED,
        GATT_SERVICES_DISCOVERED;

    }
}

