/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.dashboard;

import com.ledger.lib.LedgerException;
import com.ledger.lib.apps.LedgerApplication;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.utils.ApduExchange;
import com.ledger.lib.utils.Dump;
import com.ledger.lib.utils.SerializeHelper;
import java.util.Arrays;

public class Dashboard
extends LedgerApplication {
    private static final int CLA_BOLOS = 224;
    private static final int INS_GET_VERSION = 1;
    private static final int INS_RUN_APP = 216;

    public Dashboard(LedgerDevice device) {
        super(device);
    }

    public DeviceDetails getDeviceDetails() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 1, 0, 0);
        response.checkSW();
        return new DeviceDetails(response.getResponse());
    }

    public boolean runApplication(String applicationName) throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 216, 0, 0, SerializeHelper.stringToByteArray(applicationName));
        return response.getSW() == 36864;
    }

    public class DeviceDetails {
        public static final int FLAG_OS_RECOVERY = 1;
        public static final int FLAG_OS_SIGNED_MCU = 2;
        public static final int FLAG_OS_ONBOARDED = 4;
        public static final int FLAG_TRUST_ISSUER = 8;
        public static final int FLAG_TRUST_CUSTOMCA = 16;
        public static final int FLAG_HSM_INITIALIZED = 32;
        public static final int FLAG_PIN_VALIDATED = 128;
        private long targetId;
        private String version;
        private int osFlags;
        private String mcuVersion;
        private byte[] mcuHash;

        DeviceDetails(byte[] response) {
            int offset = 0;
            this.targetId = SerializeHelper.readUint32BE(response, offset);
            offset += 4;
            int nameLength = response[offset++] & 0xFF;
            this.version = SerializeHelper.readString(response, offset, nameLength);
            offset += nameLength;
            int flagSize = response[offset++] & 0xFF;
            this.osFlags = response[offset] & 0xFF;
            if ((offset += flagSize) < response.length) {
                nameLength = response[offset++] & 0xFF;
                this.mcuVersion = SerializeHelper.readString(response, offset, nameLength);
                if ((offset += nameLength) < response.length) {
                    this.mcuHash = Arrays.copyOfRange(response, offset, offset + 32);
                }
            }
        }

        public long getTargetId() {
            return this.targetId;
        }

        public String getVersion() {
            return this.version;
        }

        public int getOSFlags() {
            return this.osFlags;
        }

        public String getMCUVersion() {
            return this.mcuVersion;
        }

        public byte[] getMCUHash() {
            return this.mcuHash;
        }

        public String osFlagsToString() {
            String result = "";
            if ((this.osFlags & 1) != 0) {
                result = result + "Recovery,";
            }
            if ((this.osFlags & 2) != 0) {
                result = result + "Signed MCU,";
            }
            if ((this.osFlags & 4) != 0) {
                result = result + "Onboarded,";
            }
            if ((this.osFlags & 8) != 0) {
                result = result + "Trust issuer,";
            }
            if ((this.osFlags & 0x10) != 0) {
                result = result + "Trust Custom CA,";
            }
            if ((this.osFlags & 0x20) != 0) {
                result = result + "Personalized,";
            }
            if ((this.osFlags & 0x80) != 0) {
                result = result + "PIN ready,";
            }
            if (result.length() == 0) {
                return result;
            }
            return result.substring(0, result.length() - 1);
        }

        public String toString() {
            String result = "0x" + Long.toHexString(this.targetId) + " " + this.version + " " + this.osFlagsToString();
            if (this.mcuVersion != null) {
                result = result + " MCU " + this.mcuVersion;
                if (this.mcuHash != null) {
                    result = result + " " + Dump.dump(this.mcuHash);
                }
            }
            return result;
        }
    }
}

