/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.Context;
import com.google.android.gms.iid.InstanceID;
import com.leanplum.Leanplum;
import com.leanplum.LeanplumCloudMessagingProvider;
import com.leanplum.internal.LeanplumManifestHelper;
import com.leanplum.internal.Log;
import com.leanplum.internal.Util;
import com.leanplum.utils.SharedPreferencesUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

class LeanplumGcmProvider
extends LeanplumCloudMessagingProvider {
    private static final String ERROR_TIMEOUT = "TIMEOUT";
    private static final String ERROR_INVALID_SENDER = "INVALID_SENDER";
    private static final String ERROR_AUTHENTICATION_FAILED = "AUTHENTICATION_FAILED";
    private static final String ERROR_PHONE_REGISTRATION_ERROR = "PHONE_REGISTRATION_ERROR";
    private static final String ERROR_TOO_MANY_REGISTRATIONS = "TOO_MANY_REGISTRATIONS";
    private static String senderIds;

    LeanplumGcmProvider() {
    }

    static void setSenderId(String senderId) {
        senderIds = senderId;
    }

    public void storePreferences(Context context) {
        super.storePreferences(context);
        Log.v((Object[])new Object[]{"Saving GCM sender ID"});
        SharedPreferencesUtil.setString((Context)context, (String)"__leanplum_push__", (String)"sender_ids", (String)senderIds);
    }

    public String getRegistrationId() {
        String string = null;
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)Leanplum.getContext());
            if (senderIds == null || instanceID == null) {
                Log.w((Object[])new Object[]{"There was a problem setting up GCM, please make sure you follow instructions on how to set it up."});
                return null;
            }
            string = instanceID.getToken(senderIds, "GCM", null);
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage())) {
                Log.w((Object[])new Object[]{"GCM service is not available. Will try to register again next time the app starts."});
            } else if (ERROR_TIMEOUT.equals(iOException.getMessage())) {
                Log.w((Object[])new Object[]{"Retrieval of GCM registration token timed out. Will try to register again next time the app starts."});
            } else if (ERROR_INVALID_SENDER.equals(iOException.getMessage())) {
                Log.e((Object[])new Object[]{"The GCM sender account is not recognized. Please be sure to call LeanplumPushService.setGsmSenderId() with a valid GCM sender id."});
            } else if (ERROR_AUTHENTICATION_FAILED.equals(iOException.getMessage())) {
                Log.w((Object[])new Object[]{"Bad Google Account password."});
            } else if (ERROR_PHONE_REGISTRATION_ERROR.equals(iOException.getMessage())) {
                Log.w((Object[])new Object[]{"This phone doesn't currently support GCM."});
            } else if (ERROR_TOO_MANY_REGISTRATIONS.equals(iOException.getMessage())) {
                Log.w((Object[])new Object[]{"This phone has more than the allowed number of apps that are registered with GCM."});
            } else {
                Log.e((Object[])new Object[]{"Failed to complete registration token refresh."});
                Util.handleException((Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            Log.w((Object[])new Object[]{"There was a problem setting up GCM, please make sure you follow instructions on how to set it up. Please verify that you are using correct version of Google Play Services and Android Support Library v4."});
            Util.handleException((Throwable)throwable);
        }
        return string;
    }

    public boolean isInitialized() {
        return senderIds != null || LeanplumGcmProvider.getCurrentRegistrationId() != null;
    }

    public boolean isManifestSetup() {
        Context context = Leanplum.getContext();
        if (context == null) {
            return false;
        }
        try {
            boolean bl;
            boolean bl2 = LeanplumManifestHelper.checkPermission((String)"com.google.android.c2dm.permission.RECEIVE", (boolean)false, (boolean)true) && (LeanplumManifestHelper.checkPermission((String)(context.getPackageName() + ".gcm.permission.C2D_MESSAGE"), (boolean)true, (boolean)false) || LeanplumManifestHelper.checkPermission((String)(context.getPackageName() + ".permission.C2D_MESSAGE"), (boolean)true, (boolean)true));
            boolean bl3 = LeanplumManifestHelper.checkComponent((LeanplumManifestHelper.ApplicationComponent)LeanplumManifestHelper.ApplicationComponent.RECEIVER, (String)"com.google.android.gms.gcm.GcmReceiver", (boolean)true, (String)"com.google.android.c2dm.permission.SEND", Arrays.asList("com.google.android.c2dm.intent.RECEIVE", "com.google.android.c2dm.intent.REGISTRATION"), (String)context.getPackageName());
            boolean bl4 = LeanplumManifestHelper.checkComponent((LeanplumManifestHelper.ApplicationComponent)LeanplumManifestHelper.ApplicationComponent.RECEIVER, (String)"com.leanplum.LeanplumPushReceiver", (boolean)false, null, Collections.singletonList("com.leanplum.LeanplumPushListenerService"), (String)context.getPackageName());
            boolean bl5 = bl3 && bl4;
            boolean bl6 = LeanplumManifestHelper.checkComponent((LeanplumManifestHelper.ApplicationComponent)LeanplumManifestHelper.ApplicationComponent.SERVICE, (String)"com.leanplum.LeanplumPushListenerService", (boolean)false, null, Collections.singletonList("com.google.android.c2dm.intent.RECEIVE"), (String)context.getPackageName());
            boolean bl7 = LeanplumManifestHelper.checkComponent((LeanplumManifestHelper.ApplicationComponent)LeanplumManifestHelper.ApplicationComponent.SERVICE, (String)"com.leanplum.LeanplumPushInstanceIDService", (boolean)false, null, Collections.singletonList("com.google.android.gms.iid.InstanceID"), (String)context.getPackageName());
            boolean bl8 = LeanplumManifestHelper.checkComponent((LeanplumManifestHelper.ApplicationComponent)LeanplumManifestHelper.ApplicationComponent.SERVICE, (String)"com.leanplum.LeanplumPushRegistrationService", (boolean)false, null, null, (String)context.getPackageName());
            boolean bl9 = bl = bl6 && bl7 && bl8;
            if (bl2 && bl5 && bl) {
                Log.i((Object[])new Object[]{"Google Cloud Messaging is setup correctly."});
                return true;
            }
        }
        catch (Throwable throwable) {
            Util.handleException((Throwable)throwable);
        }
        Log.e((Object[])new Object[]{"Failed to setup Google Cloud Messaging, check your manifest configuration."});
        return false;
    }

    public void unregister() {
        try {
            InstanceID.getInstance((Context)Leanplum.getContext()).deleteInstanceID();
            Log.i((Object[])new Object[]{"Application was unregistered from GCM."});
        }
        catch (Exception exception) {
            Log.e((Object[])new Object[]{"Failed to unregister from GCM."});
        }
    }
}

