/*
 * Decompiled with CFR 0.152.
 */
package com.lazy.library.logging;

import android.content.Context;
import android.os.Environment;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.lazy.library.logging.Builder;
import com.lazy.library.logging.Config;
import com.lazy.library.logging.LogLevel;
import com.lazy.library.logging.LogStackRecord;
import com.lazy.library.logging.LogTransaction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Logcat {
    private static final String TAG = "Logcat";
    public static final char SHOW_VERBOSE_LOG = '\u0001';
    public static final char SHOW_DEBUG_LOG = '\u0002';
    public static final char SHOW_INFO_LOG = '\u0004';
    public static final char SHOW_WARN_LOG = '\b';
    public static final char SHOW_ERROR_LOG = '\u0010';
    public static final char SHOW_JSON_LOG = ' ';
    public static final char NOT_SHOW_LOG = '\u0000';
    private static final String V = "V/";
    private static final String D = "D/";
    private static final String I = "I/";
    private static final String W = "W/";
    private static final String E = "E/";
    private static final String JSON = "JSON/";
    private static final String TAG_SEPARATOR = "->";
    private static final String DEFAULT_LOG_DIR = "logs";
    public static final char SHOW_ALL_LOG = '?';
    private static char mCLogCatShowLogType = (char)63;
    private static char mCFileSaveLogType = (char)63;
    private static String sLogFolderPath = "";
    private static Context mContext;
    private static final String LINE_SEPARATOR;
    private static final int JSON_INDENT = 3;
    private static final String LOGFILE_SUFFIX = ".log";
    private static SimpleDateFormat simpleDateFormat;
    private static SimpleDateFormat fileSimpleDateFormat;
    private static ExecutorService mSingleExecutors;
    private static final int INDEX = 5;
    private static final int MAX_LENGTH = 4000;

    private Logcat() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(@NonNull Context context) {
        mContext = context.getApplicationContext();
        Logcat.initialize(context, Logcat.defaultConfig());
    }

    public static void initialize(@NonNull Context context, @NonNull Config config) {
        mContext = context.getApplicationContext();
        if (config.logSavePath == null || "".equals(config.logSavePath.trim())) {
            Logcat.defaultConfig();
        } else {
            Logcat.checkSaveLogPath(config.logSavePath);
        }
        if (config.logCatLogLevel != null) {
            mCLogCatShowLogType = config.logCatLogLevel.charValue();
        }
        if (config.fileLogLevel != null && (mCFileSaveLogType = config.fileLogLevel.charValue()) == '\u0000') {
            mSingleExecutors = null;
        }
    }

    private static Config defaultConfig() {
        Builder builder = Logcat.newBuilder();
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            Log.w((String)TAG, (String)"Not mount SD card!");
        } else if ("mounted_ro".equals(state)) {
            Log.w((String)TAG, (String)"Not allow write SD card!");
        } else {
            File externalCacheDir = mContext.getExternalCacheDir();
            if (externalCacheDir == null) {
                Log.e((String)TAG, (String)"externalCacheDir is null!");
                builder.fileLogLevel(0);
            } else {
                builder.logSavePath = externalCacheDir.getAbsolutePath() + File.separator + DEFAULT_LOG_DIR;
                String strSaveLogPath = builder.logSavePath;
                Logcat.checkSaveLogPath(strSaveLogPath);
            }
        }
        return new Config(builder);
    }

    private static void checkSaveLogPath(@NonNull String strSaveLogPath) {
        if ("".equals(sLogFolderPath.trim())) {
            File fileSaveLogFolderPath = new File(strSaveLogPath);
            if (!fileSaveLogFolderPath.exists()) {
                boolean mkdirs = fileSaveLogFolderPath.mkdirs();
                if (mkdirs) {
                    Log.i((String)TAG, (String)"Create log folder success!");
                } else {
                    Log.i((String)TAG, (String)"Create log folder failed!");
                }
            }
            sLogFolderPath = strSaveLogPath;
        }
    }

    public static LogTransaction level(LogLevel logLevel) {
        return new LogStackRecord(logLevel);
    }

    public static LogTransaction v() {
        return new LogStackRecord(LogLevel.Verbose);
    }

    public static LogTransaction d() {
        return new LogStackRecord(LogLevel.Debug);
    }

    public static LogTransaction i() {
        return new LogStackRecord(LogLevel.Info);
    }

    public static LogTransaction w() {
        return new LogStackRecord(LogLevel.Warn);
    }

    public static LogTransaction e() {
        return new LogStackRecord(LogLevel.Error);
    }

    public static LogTransaction json() {
        return new LogStackRecord(LogLevel.Json);
    }

    public static void v(Object msg) {
        Logcat.consoleLog(1, msg, new String[0]);
    }

    public static void d(Object msg) {
        Logcat.consoleLog(2, msg, new String[0]);
    }

    public static void i(Object msg) {
        Logcat.consoleLog(4, msg, new String[0]);
    }

    public static void w(Object msg) {
        Logcat.consoleLog(8, msg, new String[0]);
    }

    public static void e(Object msg) {
        Logcat.consoleLog(16, msg, new String[0]);
    }

    public static void json(String msg) {
        Logcat.consoleLog(32, msg, new String[0]);
    }

    public static void v(String tag, Object msg) {
        Logcat.consoleLog(1, msg, tag);
    }

    public static void d(String tag, Object msg) {
        Logcat.consoleLog(2, msg, tag);
    }

    public static void i(String tag, Object msg) {
        Logcat.consoleLog(4, msg, tag);
    }

    public static void w(String tag, Object msg) {
        Logcat.consoleLog(8, msg, tag);
    }

    public static void e(String tag, Object msg) {
        Logcat.consoleLog(16, msg, tag);
    }

    public static void json(String tag, String msg) {
        Logcat.consoleLog(32, msg, tag);
    }

    static void consoleLog(int logLevel, Object msg, String ... tag) {
        if (0 != (logLevel & mCLogCatShowLogType)) {
            Logcat.printLog(Logcat.getStackTraceElement(5), logLevel, msg, tag);
        }
    }

    private static void printLog(StackTraceElement stackTraceElement, int type, Object objectMsg, String ... tagArgs) {
        if (mCLogCatShowLogType == '\u0000') {
            return;
        }
        String fileName = stackTraceElement.getFileName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append(TAG);
        if (tagArgs == null) {
            tagBuilder.append(TAG_SEPARATOR);
            tagBuilder.append(fileName);
        } else {
            for (String tagArg : tagArgs) {
                tagBuilder.append(TAG_SEPARATOR);
                tagBuilder.append(tagArg);
            }
        }
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(fileName).append(":").append(lineNumber).append(")#").append(methodName).append(" ] ");
        String msg = objectMsg == null ? "null" : objectMsg.toString();
        if (msg != null && type != 32) {
            stringBuilder.append(msg);
        }
        String tag = tagBuilder.toString();
        String logStr = stringBuilder.toString();
        if (type == 32) {
            if (TextUtils.isEmpty((CharSequence)msg)) {
                Log.e((String)tag, (String)"Empty or Null json content");
                return;
            }
            String message = null;
            try {
                if (msg.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(msg);
                    message = jsonObject.toString(3);
                } else if (msg.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(msg);
                    message = jsonArray.toString(3);
                }
            }
            catch (JSONException e) {
                Logcat.e("JSONException/" + tag, e.getCause().getMessage() + LINE_SEPARATOR + msg);
                return;
            }
            Logcat.printLine(JSON + tag, true);
            message = logStr + LINE_SEPARATOR + message;
            String[] lines = message.split(LINE_SEPARATOR);
            StringBuilder jsonContent = new StringBuilder();
            for (String line : lines) {
                jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
            }
            Log.i((String)(JSON + tag), (String)jsonContent.toString());
            Logcat.printLine(JSON + tag, false);
        } else {
            int index = 0;
            int length = logStr.length();
            int countOfSub = length / 4000;
            if (countOfSub > 0) {
                for (int i = 0; i < countOfSub; ++i) {
                    String sub = logStr.substring(index, index + 4000);
                    Logcat.printLog(type, tag, sub);
                    index += 4000;
                }
                Logcat.printLog(type, tag, logStr.substring(index, length));
                return;
            }
            Logcat.printLog(type, tag, logStr);
        }
    }

    private static void printLog(int type, String tag, String logStr) {
        switch (type) {
            case 1: {
                Log.v((String)tag, (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)tag, (String)logStr);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)logStr);
                break;
            }
            case 8: {
                Log.w((String)tag, (String)logStr);
                break;
            }
            case 16: {
                Log.e((String)tag, (String)logStr);
                break;
            }
        }
    }

    static void writeLog(final int logLevel, final Object msg, final @Nullable String logFileName, final String ... tag) {
        if (0 != (logLevel & mCFileSaveLogType)) {
            final StackTraceElement stackTraceElement = Logcat.getStackTraceElement(5);
            mSingleExecutors.execute(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    Logcat.fileLog(stackTraceElement, logLevel, msg, logFileName, tag);
                }
            });
        }
    }

    private static void fileLog(StackTraceElement stackTraceElement, int type, Object objectMsg, @Nullable String logFileName, String ... tagArgs) {
        if (mCFileSaveLogType == '\u0000') {
            return;
        }
        String fileName = stackTraceElement.getFileName();
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append(TAG);
        if (tagArgs == null) {
            tagBuilder.append(TAG_SEPARATOR);
            tagBuilder.append(className);
        } else {
            for (String tagArg : tagArgs) {
                tagBuilder.append(TAG_SEPARATOR);
                tagBuilder.append(tagArg);
            }
        }
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        String strDateTimeLogHead = simpleDateFormat.format(new Date());
        stringBuilder.append(tagBuilder.toString()).append(" ").append(strDateTimeLogHead).append(LINE_SEPARATOR).append("fileName:").append(fileName).append(LINE_SEPARATOR).append("className:").append(className).append(LINE_SEPARATOR).append("methodName:").append(methodName).append(LINE_SEPARATOR).append("lineNumber:").append(lineNumber).append(LINE_SEPARATOR);
        String msg = objectMsg == null ? "null" : objectMsg.toString();
        if (msg != null && type != 32) {
            stringBuilder.append(msg);
        }
        stringBuilder.append(LINE_SEPARATOR + LINE_SEPARATOR);
        switch (type) {
            case 1: {
                Logcat.saveLogToFile(V + stringBuilder.toString(), logFileName);
                break;
            }
            case 2: {
                Logcat.saveLogToFile(D + stringBuilder.toString(), logFileName);
                break;
            }
            case 4: {
                Logcat.saveLogToFile(I + stringBuilder.toString(), logFileName);
                break;
            }
            case 8: {
                Logcat.saveLogToFile(W + stringBuilder.toString(), logFileName);
                break;
            }
            case 16: {
                Logcat.saveLogToFile(E + stringBuilder.toString(), logFileName);
                break;
            }
            case 32: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.d((String)tagBuilder.toString(), (String)"Empty or Null json content");
                    return;
                }
                String message = null;
                try {
                    if (msg.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(msg);
                        message = jsonObject.toString(3);
                    } else if (msg.startsWith("[")) {
                        JSONArray jsonArray = new JSONArray(msg);
                        message = jsonArray.toString(3);
                    }
                }
                catch (JSONException e) {
                    Logcat.e("JSONException/" + tagBuilder.toString(), e.getCause().getMessage() + LINE_SEPARATOR + msg);
                    return;
                }
                stringBuilder.append(JSON);
                stringBuilder.append(LINE_SEPARATOR);
                stringBuilder.append("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                message = stringBuilder.toString() + LINE_SEPARATOR + message;
                String[] lines = message.split(LINE_SEPARATOR);
                StringBuilder jsonContent = new StringBuilder();
                for (String line : lines) {
                    jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
                }
                jsonContent.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                Logcat.saveLogToFile(stringBuilder.toString(), logFileName);
                break;
            }
        }
    }

    private static void saveLogToFile(String msg, @Nullable String logFileName) {
        BufferedWriter objBufferedWriter;
        OutputStreamWriter objFilerWriter;
        block22: {
            if (TextUtils.isEmpty((CharSequence)logFileName)) {
                String strDateTimeFileName = fileSimpleDateFormat.format(new Date());
                logFileName = strDateTimeFileName + LOGFILE_SUFFIX;
            }
            objFilerWriter = null;
            objBufferedWriter = null;
            String state = Environment.getExternalStorageState();
            if (!"mounted".equals(state)) {
                Log.d((String)TAG, (String)"Not mount SD card!");
            } else if ("mounted_ro".equals(state)) {
                Log.d((String)TAG, (String)"Not allow write SD card!");
            } else {
                File rootPath = new File(sLogFolderPath);
                if (rootPath.exists()) {
                    File fileLogFilePath = new File(sLogFolderPath, logFileName);
                    if (!fileLogFilePath.exists()) {
                        try {
                            fileLogFilePath.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break block22;
                        }
                    }
                    if (!fileLogFilePath.exists()) {
                        Log.d((String)TAG, (String)"Create log file failed!");
                    } else {
                        try {
                            objFilerWriter = new FileWriter(fileLogFilePath, true);
                        }
                        catch (IOException e1) {
                            Log.d((String)TAG, (String)"New FileWriter Instance failed");
                            e1.printStackTrace();
                            break block22;
                        }
                        objBufferedWriter = new BufferedWriter(objFilerWriter);
                        try {
                            objBufferedWriter.write(msg);
                            objBufferedWriter.flush();
                        }
                        catch (IOException e) {
                            Log.d((String)TAG, (String)"objBufferedWriter.write or objBufferedWriter.flush failed");
                            e.printStackTrace();
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"LogTransaction savePaht invalid!");
                }
            }
        }
        if (null != objBufferedWriter) {
            try {
                objBufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != objFilerWriter) {
            try {
                objFilerWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Log.i((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        } else {
            Log.i((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }

    private static StackTraceElement getStackTraceElement(int index) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[index];
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        fileSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        mSingleExecutors = Executors.newSingleThreadExecutor();
    }
}

