/*
 * Decompiled with CFR 0.152.
 */
package com.lazy.library.logging;

import android.support.annotation.NonNull;
import android.util.Pair;
import com.lazy.library.logging.LogLevel;
import com.lazy.library.logging.LogTransaction;
import com.lazy.library.logging.Logcat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class LogStackRecord
extends LogTransaction {
    static final int OP_NULL = 0;
    static final int OP_TAG = 1;
    static final int OP_TAGS = 2;
    static final int OP_MSG = 3;
    static final int OP_MSGS = 4;
    static final int OP_FILE = 5;
    static final int OP_LN = 6;
    static final int OP_FORMAT = 7;
    private final LogLevel logLevel;
    Op mHead;
    Op mTail;
    int mNumOp;

    LogStackRecord(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public LogTransaction msg(@NonNull Object msg) {
        this.doOp(3, msg);
        return this;
    }

    @Override
    public LogTransaction msgs(Object ... msg) {
        this.doOp(4, msg);
        return this;
    }

    @Override
    public LogTransaction tag(@NonNull String tag) {
        this.doOp(1, tag);
        return this;
    }

    @Override
    public LogTransaction tags(String ... tags) {
        this.doOp(2, tags);
        return this;
    }

    @Override
    public LogTransaction file() {
        this.doOp(5, "");
        return this;
    }

    @Override
    public LogTransaction file(@NonNull String fileName) {
        this.doOp(5, fileName);
        return this;
    }

    @Override
    public LogTransaction ln() {
        this.doOp(6, "\n");
        return this;
    }

    @Override
    public LogTransaction format(@NonNull String format, Object ... args) {
        this.doOp(7, new Pair((Object)format, Arrays.asList(args)));
        return this;
    }

    @Override
    public LogTransaction out() {
        ArrayList<Object> msgsList = new ArrayList<Object>();
        ArrayList<String> tagsList = new ArrayList<String>();
        String filesName = null;
        while (this.mHead != null) {
            switch (this.mHead.cmd) {
                case 3: {
                    msgsList.add(this.mHead.obj);
                    break;
                }
                case 4: {
                    msgsList.addAll(Arrays.asList((Object[])this.mHead.obj));
                    break;
                }
                case 1: {
                    tagsList.add((String)this.mHead.obj);
                    break;
                }
                case 2: {
                    tagsList.addAll(Arrays.asList((String[])this.mHead.obj));
                    break;
                }
                case 5: {
                    filesName = (String)this.mHead.obj;
                    break;
                }
                case 6: {
                    msgsList.add((String)this.mHead.obj);
                    break;
                }
                case 7: {
                    Pair pair = (Pair)this.mHead.obj;
                    String format = String.format((String)pair.first, ((List)pair.second).toArray());
                    msgsList.add(format);
                }
            }
            this.mHead = this.mHead.next;
            if (this.mHead == null) continue;
            this.mHead.prev = null;
        }
        this.mTail = null;
        this.mNumOp = 0;
        boolean hasMsg = !msgsList.isEmpty();
        boolean hasTag = !tagsList.isEmpty();
        boolean hasFile = filesName != null;
        StringBuffer buffer = new StringBuffer();
        for (Object e : msgsList) {
            buffer.append(e.toString());
            buffer.append(" ");
        }
        String[] tags = new String[tagsList.size()];
        tagsList.toArray(tags);
        String string = buffer.toString();
        if (hasFile) {
            Logcat.writeLog(this.logLevel.value, 5, (Object)string, filesName, tags);
        }
        Logcat.consoleLog(this.logLevel.value, 5, (Object)string, tags);
        return this;
    }

    private void doOp(int opCmd, Object object) {
        if (object == null) {
            object = "null";
        }
        Op op = new Op();
        op.cmd = opCmd;
        op.obj = object;
        this.addOp(op);
    }

    void addOp(Op op) {
        if (this.mHead == null) {
            this.mHead = this.mTail = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        ++this.mNumOp;
    }

    static final class Op {
        Op next;
        Op prev;
        int cmd;
        Object obj;

        Op() {
        }
    }
}

