/*
 * Decompiled with CFR 0.152.
 */
package com.lazy.library.logging;

import android.content.Context;
import android.os.Environment;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.lazy.library.logging.Builder;
import com.lazy.library.logging.Config;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Logcat {
    public static final String TAG = "Logcat";
    public static final char SHOW_VERBOSE_LOG = '\u0001';
    public static final char SHOW_DEBUG_LOG = '\u0002';
    public static final char SHOW_INFO_LOG = '\u0004';
    public static final char SHOW_WARN_LOG = '\b';
    public static final char SHOW_ERROR_LOG = '\u0010';
    private static final int SHOW_JSON_LOG = 32;
    public static final char OPERATION_BIT = '\u0000';
    public static final char NOT_SHOW_LOG = '\u0000';
    public static final String V = "V/";
    public static final String D = "D/";
    public static final String I = "I/";
    public static final String W = "W/";
    public static final String E = "E/";
    public static final String JSON = "JSON/";
    public static final String TAG_SEPARATOR = "->";
    public static final String DEFAULT_LOG_DIR = "logs";
    private static char m_cLogCatShowLogType = (char)63;
    private static char m_cFileSaveLogType = (char)31;
    public static String sLogFolderPath = "";
    private static Context mContext;
    private static final String LINE_SEPARATOR;
    private static final String FILE_SEPARATOR;
    private static final int JSON_INDENT = 3;
    private static final String LOGFILE_SUFFIX = ".log";
    private static SimpleDateFormat simpleDateFormat;
    private static SimpleDateFormat fileSimpleDateFormat;
    private static ExecutorService mSingleExecutors;
    public static final int INDEX = 5;

    private Logcat() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(@NonNull Context context) {
        mContext = context.getApplicationContext();
        Logcat.initialize(context, Logcat.defaultConfig());
    }

    public static void initialize(@NonNull Context context, @NonNull Config config) {
        mContext = context.getApplicationContext();
        if (config.logSavePath == null || config.logSavePath.trim().equals("")) {
            Logcat.defaultConfig();
        } else {
            Logcat.checkSaveLogPath(config.logSavePath);
        }
        if (config.logCatLogLevel != null) {
            m_cLogCatShowLogType = config.logCatLogLevel.charValue();
        }
        if (config.fileLogLevel != null && (m_cFileSaveLogType = config.fileLogLevel.charValue()) == '\u0000') {
            mSingleExecutors = null;
        }
    }

    public static Config defaultConfig() {
        Builder builder = Logcat.newBuilder();
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            Log.w((String)TAG, (String)"Not mount SD card!");
        } else if ("mounted_ro".equals(state)) {
            Log.w((String)TAG, (String)"Not allow write SD card!");
        } else {
            File externalCacheDir = mContext.getExternalCacheDir();
            if (externalCacheDir == null) {
                Log.e((String)TAG, (String)"externalCacheDir is null!");
                builder.fileLogLevel(0);
            } else {
                builder.logSavePath = externalCacheDir.getAbsolutePath() + FILE_SEPARATOR + DEFAULT_LOG_DIR;
                String strSaveLogPath = builder.logSavePath;
                Logcat.checkSaveLogPath(strSaveLogPath);
            }
        }
        Config config = new Config(builder);
        return config;
    }

    private static void checkSaveLogPath(@NonNull String strSaveLogPath) {
        if (sLogFolderPath.trim().equals("")) {
            File fileSaveLogFolderPath = new File(strSaveLogPath);
            if (!fileSaveLogFolderPath.exists()) {
                boolean mkdirs = fileSaveLogFolderPath.mkdirs();
                if (mkdirs) {
                    Log.i((String)TAG, (String)"Create log folder success!");
                } else {
                    Log.i((String)TAG, (String)"Create log folder failed!");
                }
            }
            sLogFolderPath = strSaveLogPath;
        }
    }

    public static void v(Object msg, String ... tag) {
        Logcat.consoleLog(1, msg, tag);
    }

    public static void d(Object msg, String ... tag) {
        Logcat.consoleLog(2, msg, tag);
    }

    public static void i(Object msg, String ... tag) {
        Logcat.consoleLog(4, msg, tag);
    }

    public static void w(Object msg, String ... tag) {
        Logcat.consoleLog(8, msg, tag);
    }

    public static void e(Object msg, String ... tag) {
        Logcat.consoleLog(16, msg, tag);
    }

    public static void json(String msg, String ... tag) {
        Logcat.consoleLog(32, msg, tag);
    }

    public static void vv(Object msg, String ... tag) {
        Logcat.writeLog(1, msg, null, tag);
    }

    public static void dd(Object msg, String ... tag) {
        Logcat.writeLog(2, msg, null, tag);
    }

    public static void ii(Object msg, String ... tag) {
        Logcat.writeLog(4, msg, null, tag);
    }

    public static void ww(Object msg, String ... tag) {
        Logcat.writeLog(8, msg, null, tag);
    }

    public static void ee(Object msg, String ... tag) {
        Logcat.writeLog(16, msg, null, tag);
    }

    public static void fjson(String msg, String ... tag) {
        Logcat.writeLog(32, msg, null, tag);
    }

    public static void vvv(Object msg, String ... tag) {
        Logcat.consoleLog(1, msg, tag);
        Logcat.writeLog(1, msg, null, tag);
    }

    public static void ddd(Object msg, String ... tag) {
        Logcat.consoleLog(2, msg, tag);
        Logcat.writeLog(2, msg, null, tag);
    }

    public static void iii(Object msg, String ... tag) {
        Logcat.consoleLog(4, msg, tag);
        Logcat.writeLog(4, msg, null, tag);
    }

    public static void www(Object msg, String ... tag) {
        Logcat.consoleLog(8, msg, tag);
        Logcat.writeLog(8, msg, null, tag);
    }

    public static void eee(Object msg, String ... tag) {
        Logcat.consoleLog(16, msg, tag);
        Logcat.writeLog(16, msg, null, tag);
    }

    public static void cfjson(Object msg, String ... tag) {
        Logcat.consoleLog(32, msg, tag);
        Logcat.writeLog(32, msg, null, tag);
    }

    public static void fv(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(1, msg, logFileName, tag);
    }

    public static void fd(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(2, msg, logFileName, tag);
    }

    public static void fi(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(4, msg, logFileName, tag);
    }

    public static void fw(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(8, msg, logFileName, tag);
    }

    public static void fe(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(16, msg, logFileName, tag);
    }

    public static void ffjson(String msg, @Nullable String logFileName, String ... tag) {
        Logcat.writeLog(32, msg, logFileName, tag);
    }

    public static void fvv(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(1, msg, tag);
        Logcat.writeLog(1, msg, logFileName, tag);
    }

    public static void fdd(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(2, msg, tag);
        Logcat.writeLog(2, msg, logFileName, tag);
    }

    public static void fii(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(4, msg, tag);
        Logcat.writeLog(4, msg, logFileName, tag);
    }

    public static void fww(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(8, msg, tag);
        Logcat.writeLog(8, msg, logFileName, tag);
    }

    public static void fee(Object msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(16, msg, tag);
        Logcat.writeLog(16, msg, logFileName, tag);
    }

    public static void fcfjson(String msg, @Nullable String logFileName, String ... tag) {
        Logcat.consoleLog(32, msg, tag);
        Logcat.writeLog(32, msg, logFileName, tag);
    }

    private static void saveLog2File(String msg) {
        String strDateTimeFileName = fileSimpleDateFormat.format(new Date());
        Logcat.saveLog2File(msg, strDateTimeFileName + LOGFILE_SUFFIX);
    }

    private static void saveLog2File(String msg, String logFileName) {
        BufferedWriter objBufferedWriter;
        OutputStreamWriter objFilerWriter;
        block21: {
            objFilerWriter = null;
            objBufferedWriter = null;
            String state = Environment.getExternalStorageState();
            if (!"mounted".equals(state)) {
                Log.d((String)TAG, (String)"Not mount SD card!");
            } else if ("mounted_ro".equals(state)) {
                Log.d((String)TAG, (String)"Not allow write SD card!");
            } else {
                File rootPath = new File(sLogFolderPath);
                if (rootPath.exists()) {
                    File fileLogFilePath = new File(sLogFolderPath, logFileName);
                    if (!fileLogFilePath.exists()) {
                        try {
                            fileLogFilePath.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break block21;
                        }
                    }
                    if (!fileLogFilePath.exists()) {
                        Log.d((String)TAG, (String)"Create log file failed!");
                    } else {
                        try {
                            objFilerWriter = new FileWriter(fileLogFilePath, true);
                        }
                        catch (IOException e1) {
                            Log.d((String)TAG, (String)"New FileWriter Instance failed");
                            e1.printStackTrace();
                            break block21;
                        }
                        objBufferedWriter = new BufferedWriter(objFilerWriter);
                        try {
                            objBufferedWriter.write(msg);
                            objBufferedWriter.flush();
                        }
                        catch (IOException e) {
                            Log.d((String)TAG, (String)"objBufferedWriter.write or objBufferedWriter.flush failed");
                            e.printStackTrace();
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"Log savePaht invalid!");
                }
            }
        }
        if (null != objBufferedWriter) {
            try {
                objBufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != objFilerWriter) {
            try {
                objFilerWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void printLog(int type, Object objectMsg, String ... tagArgs) {
        int index = 4;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTrace[index];
        Logcat.printLog(stackTraceElement, type, objectMsg, tagArgs);
    }

    private static void printLog(StackTraceElement stackTraceElement, int type, Object objectMsg, String ... tagArgs) {
        if (m_cLogCatShowLogType == '\u0000') {
            return;
        }
        String fileName = stackTraceElement.getFileName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append(TAG);
        if (tagArgs == null) {
            tagBuilder.append(TAG_SEPARATOR);
            tagBuilder.append(fileName);
        } else {
            for (String tagArg : tagArgs) {
                tagBuilder.append(TAG_SEPARATOR);
                tagBuilder.append(tagArg);
            }
        }
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(fileName).append(":").append(lineNumber).append(")#").append(methodName).append(" ] ");
        String msg = objectMsg == null ? "Log with null Object" : objectMsg.toString();
        if (msg != null && type != 32) {
            stringBuilder.append(msg);
        }
        String logStr = stringBuilder.toString();
        switch (type) {
            case 1: {
                Log.v((String)tagBuilder.toString(), (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)tagBuilder.toString(), (String)logStr);
                break;
            }
            case 4: {
                Log.i((String)tagBuilder.toString(), (String)logStr);
                break;
            }
            case 8: {
                Log.w((String)tagBuilder.toString(), (String)logStr);
                break;
            }
            case 16: {
                Log.e((String)tagBuilder.toString(), (String)logStr);
                break;
            }
            case 32: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.d((String)tagBuilder.toString(), (String)"Empty or Null json content");
                    return;
                }
                String message = null;
                try {
                    if (msg.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(msg);
                        message = jsonObject.toString(3);
                    } else if (msg.startsWith("[")) {
                        JSONArray jsonArray = new JSONArray(msg);
                        message = jsonArray.toString(3);
                    }
                }
                catch (JSONException e) {
                    Logcat.e("JSONException/" + tagBuilder.toString(), e.getCause().getMessage() + LINE_SEPARATOR + msg);
                    return;
                }
                Logcat.printLine(JSON + tagBuilder.toString(), true);
                message = logStr + LINE_SEPARATOR + message;
                String[] lines = message.split(LINE_SEPARATOR);
                StringBuilder jsonContent = new StringBuilder();
                for (String line : lines) {
                    jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
                }
                Log.d((String)(JSON + tagBuilder.toString()), (String)jsonContent.toString());
                Logcat.printLine(JSON + tagBuilder.toString(), false);
            }
        }
    }

    private static void writeLog(final int logLevel, final Object msg, final @Nullable String logFileName, final String ... tag) {
        if (0 != (logLevel & m_cFileSaveLogType)) {
            final StackTraceElement stackTraceElement = Logcat.getStackTraceElement(5);
            mSingleExecutors.execute(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    Logcat.fileLog(stackTraceElement, logLevel, msg, logFileName, tag);
                }
            });
        }
    }

    private static void consoleLog(int logLevel, Object msg, String[] tag) {
        Logcat.consoleLog(logLevel, Logcat.getStackTraceElement(5), msg, tag);
    }

    private static void consoleLog(int logLevel, StackTraceElement stackTraceElement, Object msg, String[] tag) {
        if (0 != (logLevel & m_cLogCatShowLogType)) {
            Logcat.printLog(stackTraceElement, logLevel, msg, tag);
        }
    }

    private static void fileLog(StackTraceElement stackTraceElement, int type, Object objectMsg, String ... tagArgs) {
        Logcat.fileLog(stackTraceElement, type, objectMsg, null, tagArgs);
    }

    private static StackTraceElement getStackTraceElement(int index) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[index];
    }

    private static void fileLog(StackTraceElement stackTraceElement, int type, Object objectMsg, @Nullable String logFileName, String ... tagArgs) {
        if (m_cFileSaveLogType == '\u0000') {
            return;
        }
        String fileName = stackTraceElement.getFileName();
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append(TAG);
        if (tagArgs == null) {
            tagBuilder.append(TAG_SEPARATOR);
            tagBuilder.append(className);
        } else {
            for (String tagArg : tagArgs) {
                tagBuilder.append(TAG_SEPARATOR);
                tagBuilder.append(tagArg);
            }
        }
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        String strDateTimeLogHead = simpleDateFormat.format(new Date());
        stringBuilder.append(tagBuilder.toString()).append(" ").append(strDateTimeLogHead).append(LINE_SEPARATOR).append("fileName:").append(fileName).append(LINE_SEPARATOR).append("className:").append(className).append(LINE_SEPARATOR).append("methodName:").append(methodName).append(LINE_SEPARATOR).append("lineNumber:").append(lineNumber).append(LINE_SEPARATOR);
        String msg = objectMsg == null ? "Log with null Object" : objectMsg.toString();
        if (msg != null && type != 32) {
            stringBuilder.append(msg);
        }
        stringBuilder.append(LINE_SEPARATOR + LINE_SEPARATOR);
        switch (type) {
            case 1: {
                if (logFileName == null) {
                    Logcat.saveLog2File(V + stringBuilder.toString());
                    break;
                }
                Logcat.saveLog2File(V + stringBuilder.toString(), logFileName);
                break;
            }
            case 2: {
                if (logFileName == null) {
                    Logcat.saveLog2File(D + stringBuilder.toString());
                    break;
                }
                Logcat.saveLog2File(D + stringBuilder.toString(), logFileName);
                break;
            }
            case 4: {
                if (logFileName == null) {
                    Logcat.saveLog2File(I + stringBuilder.toString());
                    break;
                }
                Logcat.saveLog2File(I + stringBuilder.toString(), logFileName);
                break;
            }
            case 8: {
                if (logFileName == null) {
                    Logcat.saveLog2File(W + stringBuilder.toString());
                    break;
                }
                Logcat.saveLog2File(W + stringBuilder.toString(), logFileName);
                break;
            }
            case 16: {
                if (logFileName == null) {
                    Logcat.saveLog2File(E + stringBuilder.toString());
                    break;
                }
                Logcat.saveLog2File(E + stringBuilder.toString(), logFileName);
                break;
            }
            case 32: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.d((String)tagBuilder.toString(), (String)"Empty or Null json content");
                    return;
                }
                String message = null;
                try {
                    if (msg.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(msg);
                        message = jsonObject.toString(3);
                    } else if (msg.startsWith("[")) {
                        JSONArray jsonArray = new JSONArray(msg);
                        message = jsonArray.toString(3);
                    }
                }
                catch (JSONException e) {
                    Logcat.e("JSONException/" + tagBuilder.toString(), e.getCause().getMessage() + LINE_SEPARATOR + msg);
                    return;
                }
                stringBuilder.append(JSON);
                stringBuilder.append(LINE_SEPARATOR);
                stringBuilder.append("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                message = stringBuilder.toString() + LINE_SEPARATOR + message;
                String[] lines = message.split(LINE_SEPARATOR);
                StringBuilder jsonContent = new StringBuilder();
                for (String line : lines) {
                    jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
                }
                jsonContent.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                if (logFileName == null) {
                    Logcat.saveLog2File(jsonContent.toString());
                    break;
                }
                Logcat.saveLog2File(stringBuilder.toString(), logFileName);
            }
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Log.d((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        } else {
            Log.d((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        FILE_SEPARATOR = File.separator;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        fileSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        mSingleExecutors = Executors.newSingleThreadExecutor();
    }
}

