/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.json.TestConfiguration;
import com.lazerycode.jmeter.json.TestConfigurations;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import net.minidev.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfigurationWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMeterArgumentsArray.class);
    private static final String DEFAULT_CONFIGURATION_NAME = "default_plugin_configuration";
    private final ObjectMapper mapper = new ObjectMapper();
    private final TestConfiguration testConfiguration;

    public TestConfigurationWrapper() {
        this.testConfiguration = new TestConfiguration();
    }

    public TestConfigurationWrapper(File jsonFile, String executionIdName) throws MojoExecutionException {
        Configuration jsonPathConfiguration = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonProvider()).build();
        try (FileReader jsonFileReader = new FileReader(jsonFile);){
            Filter configFilter = Filter.filter((Predicate)Criteria.where((String)"executionID").is((Object)Optional.ofNullable(executionIdName).orElse(DEFAULT_CONFIGURATION_NAME)));
            this.testConfiguration = (TestConfiguration)JsonPath.using((Configuration)jsonPathConfiguration).parse(((JSONArray)JsonPath.parse((String)IOUtils.toString((Reader)jsonFileReader)).read("$..[?]", JSONArray.class, new Predicate[]{configFilter})).toJSONString()).read("$[0]", TestConfiguration.class, new Predicate[0]);
        }
        catch (Exception ex) {
            LOGGER.debug(String.format("Using: %s with execution id: %s", jsonFile, executionIdName));
            throw new MojoExecutionException(String.format("\n\n%s\n\nPossible Cause 1: Have you added the configure goal to your POM?\n\n    <execution>\n        <id>configuration</id>\n        <goals>\n            <goal>configure</goal>\n        </goals>\n    </execution>\n\nPossible Cause 2: Have you run `mvn jmeter:configure` for your current Execution ID?\n\nCurrent Execution ID: %s\n", ex.getMessage(), executionIdName), ex);
        }
    }

    String getFullConfig() throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)this.testConfiguration);
    }

    public void writeResultFilesConfigTo(String configLocation) throws MojoExecutionException {
        TestConfigurations configurations = new TestConfigurations();
        Path configurationFilePath = Paths.get(configLocation, new String[0]);
        try {
            if (Files.exists(configurationFilePath, new LinkOption[0])) {
                configurations = (TestConfigurations)this.mapper.readValue(configurationFilePath.toFile(), TestConfigurations.class);
            }
            configurations.getConfigurations().removeIf(config -> config.getExecutionID().equals(this.testConfiguration.getExecutionID()));
            configurations.getConfigurations().add(this.testConfiguration);
            this.mapper.writeValue(configurationFilePath.toFile(), (Object)configurations);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    public TestConfiguration getCurrentTestConfiguration() {
        return this.testConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestConfigurationWrapper that = (TestConfigurationWrapper)o;
        return Objects.equals(this.testConfiguration, that.testConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.testConfiguration);
    }
}

