/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TestConfiguration {
    private String executionID;
    private String jmeterDirectoryPath;
    private String runtimeJarName;
    private Boolean resultsOutputIsCSVFormat;
    private Boolean generateReports;
    private String[] resultFilesLocations = new String[0];
    private Map<ConfigurationFiles, PropertiesMapping> propertiesMap;

    public String getExecutionID() {
        return this.executionID;
    }

    public void setExecutionID(String executionID) {
        this.executionID = executionID;
    }

    public String getJmeterDirectoryPath() {
        return this.jmeterDirectoryPath;
    }

    public File getJmeterWorkingDirectoryPath() {
        if (null == this.jmeterDirectoryPath) {
            return null;
        }
        return Paths.get(this.jmeterDirectoryPath, "bin").toFile();
    }

    public void setJmeterDirectoryPath(String jmeterDirectoryPath) {
        this.jmeterDirectoryPath = jmeterDirectoryPath;
    }

    public String getRuntimeJarName() {
        return this.runtimeJarName;
    }

    public void setRuntimeJarName(String runtimeJarName) {
        this.runtimeJarName = runtimeJarName;
    }

    public Boolean getResultsOutputIsCSVFormat() {
        return this.resultsOutputIsCSVFormat;
    }

    public void setResultsOutputIsCSVFormat(Boolean resultsOutputIsCSVFormat) {
        this.resultsOutputIsCSVFormat = resultsOutputIsCSVFormat;
    }

    public List<String> getResultFilesLocations() {
        return Arrays.asList(this.resultFilesLocations);
    }

    public void setResultFilesLocations(List<String> resultFilesLocations) {
        this.resultFilesLocations = resultFilesLocations.toArray(new String[0]);
    }

    public Boolean getGenerateReports() {
        return this.generateReports;
    }

    public void setGenerateReports(Boolean generateReports) {
        this.generateReports = generateReports;
    }

    public Map<ConfigurationFiles, PropertiesMapping> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void setPropertiesMap(Map<ConfigurationFiles, PropertiesMapping> propertiesMap) {
        this.propertiesMap = propertiesMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestConfiguration that = (TestConfiguration)o;
        return Objects.equals(this.executionID, that.executionID) && Objects.equals(this.jmeterDirectoryPath, that.jmeterDirectoryPath) && Objects.equals(this.resultsOutputIsCSVFormat, that.resultsOutputIsCSVFormat) && Arrays.equals(this.resultFilesLocations, that.resultFilesLocations) && Objects.equals(this.generateReports, that.generateReports);
    }

    public int hashCode() {
        int result = Objects.hash(this.executionID, this.jmeterDirectoryPath, this.resultsOutputIsCSVFormat, this.generateReports);
        result = 31 * result + Arrays.hashCode(this.resultFilesLocations);
        return result;
    }
}

