/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMeterProcessBuilder.class);
    private int initialHeapSizeInMegaBytes;
    private int maximumHeapSizeInMegaBytes;
    private final String runtimeJarName;
    private String workingDirectory;
    private String javaRuntime;
    private List<String> userSuppliedArguments;
    private List<String> mainClassArguments = new ArrayList<String>();

    public JMeterProcessBuilder(JMeterProcessJVMSettings settings, String runtimeJarName) {
        this.runtimeJarName = runtimeJarName;
        this.initialHeapSizeInMegaBytes = settings.getXms();
        this.maximumHeapSizeInMegaBytes = settings.getXmx();
        this.userSuppliedArguments = settings.getArguments();
        this.javaRuntime = settings.getJavaRuntime();
    }

    public JMeterProcessBuilder setWorkingDirectory(File workingDirectory) throws MojoExecutionException {
        try {
            this.workingDirectory = workingDirectory.getCanonicalPath();
            if (!workingDirectory.exists()) {
                throw new MojoExecutionException("Working directory does not exist!");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to set working directory for JMeter process!", (Exception)e);
        }
        return this;
    }

    public JMeterProcessBuilder addArguments(List<String> arguments) {
        this.mainClassArguments.addAll(arguments);
        return this;
    }

    public ProcessBuilder build() throws MojoExecutionException {
        if (null == this.workingDirectory) {
            throw new MojoExecutionException("Working directory is not set!");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(this.constructArgumentsList());
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(this.workingDirectory));
        return processBuilder;
    }

    String[] constructArgumentsList() {
        ArrayList<String> argumentsList = new ArrayList<String>();
        argumentsList.add(this.javaRuntime);
        argumentsList.add(MessageFormat.format("-Xms{0}M", String.valueOf(this.initialHeapSizeInMegaBytes)));
        argumentsList.add(MessageFormat.format("-Xmx{0}M", String.valueOf(this.maximumHeapSizeInMegaBytes)));
        argumentsList.addAll(this.userSuppliedArguments);
        argumentsList.add("-jar");
        argumentsList.add(this.runtimeJarName);
        argumentsList.addAll(this.mainClassArguments);
        LOGGER.info("Arguments for forked JMeter JVM: {}", argumentsList);
        LOGGER.info(" ");
        return argumentsList.toArray(new String[0]);
    }
}

