/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.appium.mojo;

import com.lazerycode.appium.mojo.AbstractAppiumMojo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Os;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.ProcessUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;
import org.zeroturnaround.process.WindowsProcess;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopAppiumMojo
extends AbstractAppiumMojo {
    @Parameter(defaultValue="15")
    int shutdownTimeout;
    @Parameter(defaultValue="5")
    int forceShutdownTimeout;

    @Override
    public void controlAppiumServer() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T O P P I N G   A P P I U M   S E R V E R");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        try {
            int appiumProcessPID = Integer.parseInt(FileUtils.readFileToString((File)new File(this.projectBuildDirectory, "appium.pid"), (Charset)StandardCharsets.UTF_8));
            PidProcess appiumProcess = Processes.newPidProcess((int)appiumProcessPID);
            if (Os.isFamily((String)"windows")) {
                WindowsProcess appiumWindowsProcess = (WindowsProcess)appiumProcess;
                appiumWindowsProcess.setIncludeChildren(true);
                appiumProcess = appiumWindowsProcess;
            }
            if (!appiumProcess.isAlive()) {
                throw new MojoExecutionException("Could not find a process running on " + appiumProcessPID);
            }
            ProcessUtil.destroyGracefullyOrForcefullyAndWait((SystemProcess)appiumProcess, (long)this.shutdownTimeout, (TimeUnit)TimeUnit.SECONDS, (long)this.forceShutdownTimeout, (TimeUnit)TimeUnit.SECONDS);
            if (appiumProcess.isAlive()) {
                throw new MojoExecutionException("Unable to stop Appium server...");
            }
        }
        catch (IOException | InterruptedException | TimeoutException ex) {
            throw new MojoExecutionException("Unable to stop Appium server...", ex);
        }
    }
}

