/*
 * Copyright 2016 Layne Mobile, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.laynemobile.android.gson;

import android.support.annotation.NonNull;

import com.google.gson.Gson;

public class GsonObject implements ToJsonObject {
    private static final Gson DEFAULT_GSON = new Gson();
    private static volatile Gson sGson = DEFAULT_GSON;

    private final Gson gson;

    public GsonObject() {
        this(sGson);
    }

    public GsonObject(Gson gson) {
        this.gson = gson;
    }

    public static void setGson(Gson gson) {
        sGson = (gson == null) ? DEFAULT_GSON : gson;
    }

    public static Gson gson() {
        return sGson;
    }

    @NonNull @Override public final String toJson() {
        return gson.toJson(this);
    }
}
