/*
 * Decompiled with CFR 0.152.
 */
package com.laynemobile.android.gson;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.Gson;
import com.laynemobile.android.gson.GsonObject;

public class GsonParcelable
extends GsonObject
implements Parcelable {
    public static final Parcelable.Creator<GsonParcelable> CREATOR = new BaseCreator<GsonParcelable>(){

        @Override
        protected Gson gson() {
            return GsonObject.gson();
        }

        public GsonParcelable[] newArray(int size) {
            return new GsonParcelable[size];
        }
    };

    protected void initFromParcel(Parcel source) {
    }

    public int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getClass().getName());
        dest.writeString(this.toJson());
        this.addToParcel(dest, flags);
    }

    protected void addToParcel(Parcel dest, int flags) {
    }

    public static abstract class BaseCreator<T extends GsonParcelable>
    implements Parcelable.Creator<T> {
        protected abstract Gson gson();

        public T createFromParcel(Parcel source) {
            String className = source.readString();
            String json = source.readString();
            try {
                Class<?> type = Class.forName(className);
                GsonParcelable t = (GsonParcelable)this.gson().fromJson(json, type);
                t.initFromParcel(source);
                return (T)t;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

