/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.HttpConnectStrategy;
import com.launchdarkly.eventsource.ResponseHeaders;
import com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.logging.LDLogger;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import okhttp3.HttpUrl;

public abstract class ConnectStrategy {
    public abstract Client createClient(LDLogger var1);

    public static HttpConnectStrategy http(URI uri) {
        return new HttpConnectStrategy(uri);
    }

    public static HttpConnectStrategy http(URL url) {
        try {
            return new HttpConnectStrategy(url == null ? null : url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HttpConnectStrategy http(HttpUrl url) {
        return new HttpConnectStrategy(url == null ? null : url.uri());
    }

    public static abstract class Client
    implements Closeable {
        public abstract Result connect(String var1) throws StreamException;

        public abstract boolean awaitClosed(long var1) throws InterruptedException;

        public abstract URI getOrigin();

        public static class Result {
            private final InputStream inputStream;
            private final URI origin;
            private final Closeable closer;
            private final ResponseHeaders headers;

            public Result(InputStream inputStream, URI origin, Closeable closer) {
                this(inputStream, origin, closer, null);
            }

            public Result(InputStream inputStream, URI origin, Closeable closer, ResponseHeaders headers) {
                this.inputStream = inputStream;
                this.origin = origin;
                this.closer = closer;
                this.headers = headers;
            }

            public InputStream getInputStream() {
                return this.inputStream;
            }

            public URI getOrigin() {
                return this.origin;
            }

            public Closeable getCloser() {
                return this.closer;
            }

            public ResponseHeaders getHeaders() {
                return this.headers;
            }
        }
    }
}

