/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.eventsource.StreamException;
import java.util.concurrent.TimeUnit;

public abstract class ErrorStrategy {
    public abstract Result apply(StreamException var1);

    public static ErrorStrategy alwaysThrow() {
        return new ErrorStrategy(){

            @Override
            public Result apply(StreamException exception) {
                return new Result(Action.THROW, null);
            }
        };
    }

    public static ErrorStrategy alwaysContinue() {
        return new ErrorStrategy(){

            @Override
            public Result apply(StreamException exception) {
                return new Result(Action.CONTINUE, null);
            }
        };
    }

    public static ErrorStrategy continueWithMaxAttempts(int maxAttempts) {
        return new MaxAttemptsStrategy(maxAttempts, 0);
    }

    public static ErrorStrategy continueWithTimeLimit(long maxTime, TimeUnit timeUnit) {
        long timeoutMillis = Helpers.millisFromTimeUnit(maxTime, timeUnit);
        return new TimeLimitStrategy(timeoutMillis, 0L);
    }

    private static class TimeLimitStrategy
    extends ErrorStrategy {
        private final long timeoutMillis;
        private final long startTime;

        TimeLimitStrategy(long timeoutMillis, long startTime) {
            this.timeoutMillis = timeoutMillis;
            this.startTime = startTime;
        }

        @Override
        public Result apply(StreamException exception) {
            if (this.startTime == 0L) {
                return new Result(Action.CONTINUE, new TimeLimitStrategy(this.timeoutMillis, System.currentTimeMillis()));
            }
            if (System.currentTimeMillis() - this.startTime < this.timeoutMillis) {
                return new Result(Action.CONTINUE, new TimeLimitStrategy(this.timeoutMillis, this.startTime));
            }
            return new Result(Action.THROW, null);
        }
    }

    private static class MaxAttemptsStrategy
    extends ErrorStrategy {
        private final int maxAttempts;
        private final int counter;

        MaxAttemptsStrategy(int maxAttempts, int counter) {
            this.maxAttempts = maxAttempts;
            this.counter = counter;
        }

        @Override
        public Result apply(StreamException exception) {
            if (this.counter < this.maxAttempts) {
                return new Result(Action.CONTINUE, new MaxAttemptsStrategy(this.maxAttempts, this.counter + 1));
            }
            return new Result(Action.THROW, null);
        }
    }

    public static class Result {
        private final Action action;
        private final ErrorStrategy next;

        public Result(Action action, ErrorStrategy next) {
            this.action = action;
            this.next = next;
        }

        public Action getAction() {
            return this.action;
        }

        public ErrorStrategy getNext() {
            return this.next;
        }
    }

    public static enum Action {
        THROW,
        CONTINUE;

    }
}

