/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.eventsource.Logger;
import com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.SLF4JLogger;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EventSource
implements Closeable {
    final Logger logger;
    public static final Duration DEFAULT_RECONNECT_TIME = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_MAX_RECONNECT_TIME = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(5L);
    public static final Duration DEFAULT_BACKOFF_RESET_THRESHOLD = Duration.ofSeconds(60L);
    public static final int DEFAULT_READ_BUFFER_SIZE = 1000;
    private static final Headers defaultHeaders = new Headers.Builder().add("Accept", "text/event-stream").add("Cache-Control", "no-cache").build();
    private final String name;
    private volatile HttpUrl url;
    private final Headers headers;
    private final String method;
    private final RequestBody body;
    private final RequestTransformer requestTransformer;
    private final ExecutorService eventExecutor;
    private final ExecutorService streamExecutor;
    final int readBufferSize;
    volatile Duration reconnectTime;
    final Duration maxReconnectTime;
    final Duration backoffResetThreshold;
    private volatile String lastEventId;
    final AsyncEventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    final boolean streamEventData;
    final Set<String> expectFields;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final Random jitter = new Random();

    EventSource(Builder builder) {
        String string = this.name = builder.name == null ? "" : builder.name;
        if (builder.logger == null) {
            String loggerName = (builder.loggerBaseName == null ? EventSource.class.getCanonicalName() : builder.loggerBaseName) + (this.name.isEmpty() ? "" : "." + this.name);
            this.logger = new SLF4JLogger(loggerName);
        } else {
            this.logger = builder.logger;
        }
        this.url = builder.url;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.method = builder.method;
        this.body = builder.body;
        this.requestTransformer = builder.requestTransformer;
        this.lastEventId = builder.lastEventId;
        this.reconnectTime = builder.reconnectTime;
        this.maxReconnectTime = builder.maxReconnectTime;
        this.backoffResetThreshold = builder.backoffResetThreshold;
        this.streamEventData = builder.streamEventData;
        this.expectFields = builder.expectFields;
        ThreadFactory eventsThreadFactory = this.createThreadFactory("okhttp-eventsource-events", builder.threadPriority);
        this.eventExecutor = Executors.newSingleThreadExecutor(eventsThreadFactory);
        ThreadFactory streamThreadFactory = this.createThreadFactory("okhttp-eventsource-stream", builder.threadPriority);
        this.streamExecutor = Executors.newSingleThreadExecutor(streamThreadFactory);
        Semaphore eventThreadSemaphore = builder.maxEventTasksInFlight > 0 ? new Semaphore(builder.maxEventTasksInFlight) : null;
        this.handler = new AsyncEventHandler(this.eventExecutor, builder.handler, this.logger, eventThreadSemaphore);
        this.connectionErrorHandler = builder.connectionErrorHandler == null ? ConnectionErrorHandler.DEFAULT : builder.connectionErrorHandler;
        this.readBufferSize = builder.readBufferSize;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.clientBuilder.build();
    }

    private ThreadFactory createThreadFactory(String type, Integer threadPriority) {
        ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        AtomicLong count = new AtomicLong(0L);
        return runnable -> {
            Thread thread = backingThreadFactory.newThread(runnable);
            thread.setName(String.format(Locale.ROOT, "%s-[%s]-%d", type, this.name, count.getAndIncrement()));
            thread.setDaemon(true);
            if (threadPriority != null) {
                thread.setPriority(threadPriority);
            }
            return thread;
        };
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            this.logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.RAW, (Object)ReadyState.CONNECTING);
        this.logger.info("Starting EventSource client using URI: " + this.url);
        this.streamExecutor.execute(this::run);
    }

    public void restart() {
        ReadyState previousState = this.readyState.getAndUpdate(t -> t == ReadyState.OPEN ? ReadyState.CLOSED : t);
        if (previousState == ReadyState.OPEN) {
            this.closeCurrentStream(previousState);
        } else if (previousState == ReadyState.RAW) {
            this.start();
        }
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        this.logger.debug("readyState change: {} -> {}", (Object)currentState, (Object)ReadyState.SHUTDOWN);
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.closeCurrentStream(currentState);
        this.eventExecutor.shutdown();
        this.streamExecutor.shutdown();
        if (this.client.connectionPool() != null) {
            this.client.connectionPool().evictAll();
        }
        if (this.client.dispatcher() != null) {
            this.client.dispatcher().cancelAll();
            if (this.client.dispatcher().executorService() != null) {
                this.client.dispatcher().executorService().shutdownNow();
            }
        }
    }

    public boolean awaitClosed(Duration timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        if (!this.eventExecutor.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            return false;
        }
        long shutdownTimeoutMills = Math.max(0L, deadline - System.currentTimeMillis());
        if (!this.streamExecutor.awaitTermination(shutdownTimeoutMills, TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (this.client.dispatcher().executorService() != null) {
            shutdownTimeoutMills = Math.max(0L, deadline - System.currentTimeMillis());
            if (!this.client.dispatcher().executorService().awaitTermination(shutdownTimeoutMills, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        return true;
    }

    private void closeCurrentStream(ReadyState previousState) {
        if (previousState == ReadyState.OPEN) {
            this.handler.onClosed();
        }
        if (this.call != null) {
            this.call.cancel();
            this.logger.debug("call cancelled", null);
        }
    }

    Request buildRequest() {
        Request.Builder builder = new Request.Builder().headers(this.headers).url(this.url).method(this.method, this.body);
        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
            builder.addHeader("Last-Event-ID", this.lastEventId);
        }
        Request request = builder.build();
        return this.requestTransformer == null ? request : this.requestTransformer.transformRequest(request);
    }

    private void run() {
        AtomicLong connectedTime = new AtomicLong();
        int reconnectAttempts = 0;
        try {
            while (!Thread.currentThread().isInterrupted() && this.readyState.get() != ReadyState.SHUTDOWN) {
                reconnectAttempts = reconnectAttempts == 0 ? ++reconnectAttempts : this.maybeReconnectDelay(reconnectAttempts, connectedTime.get());
                this.newConnectionAttempt(connectedTime);
            }
        }
        catch (RejectedExecutionException ignored) {
            this.call = null;
            this.logger.debug("Rejected execution exception ignored: {}", ignored);
        }
    }

    private int maybeReconnectDelay(int reconnectAttempts, long connectedTime) {
        if (this.reconnectTime.isZero() || this.reconnectTime.isNegative()) {
            return reconnectAttempts;
        }
        int counter = reconnectAttempts;
        if (connectedTime > 0L && System.currentTimeMillis() - connectedTime >= this.backoffResetThreshold.toMillis()) {
            counter = 1;
        }
        try {
            Duration sleepTime = this.backoffWithJitter(counter);
            this.logger.info("Waiting " + sleepTime.toMillis() + " milliseconds before reconnecting...");
            Thread.sleep(sleepTime.toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ++counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newConnectionAttempt(AtomicLong connectedTime) {
        ConnectionErrorHandler.Action errorHandlerAction = ConnectionErrorHandler.Action.PROCEED;
        ReadyState stateBeforeConnecting = this.readyState.getAndSet(ReadyState.CONNECTING);
        this.logger.debug("readyState change: {} -> {}", (Object)stateBeforeConnecting, (Object)ReadyState.CONNECTING);
        connectedTime.set(0L);
        this.call = this.client.newCall(this.buildRequest());
        try (Response response = this.call.execute();){
            if (response.isSuccessful()) {
                connectedTime.set(System.currentTimeMillis());
                this.handleSuccessfulResponse(response);
                ReadyState state = this.readyState.get();
                if (state != ReadyState.SHUTDOWN && state != ReadyState.CLOSED) {
                    this.logger.warn("Connection unexpectedly closed");
                    errorHandlerAction = this.connectionErrorHandler.onConnectionError(new EOFException());
                }
            } else {
                this.logger.debug("Unsuccessful response: {}", response);
                errorHandlerAction = this.dispatchError(new UnsuccessfulResponseException(response.code()));
            }
        }
        catch (IOException e) {
            ReadyState state = this.readyState.get();
            if (state != ReadyState.SHUTDOWN && state != ReadyState.CLOSED) {
                this.logger.debug("Connection problem: {}", e);
                errorHandlerAction = this.dispatchError(e);
            }
        }
        finally {
            if (errorHandlerAction == ConnectionErrorHandler.Action.SHUTDOWN) {
                this.logger.info("Connection has been explicitly shut down by error handler");
                this.close();
            } else {
                boolean wasOpen = this.readyState.compareAndSet(ReadyState.OPEN, ReadyState.CLOSED);
                boolean wasConnecting = this.readyState.compareAndSet(ReadyState.CONNECTING, ReadyState.CLOSED);
                if (wasOpen) {
                    this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.OPEN, (Object)ReadyState.CLOSED);
                    this.handler.onClosed();
                } else if (wasConnecting) {
                    this.logger.debug("readyState change: {} -> {}", (Object)ReadyState.CONNECTING, (Object)ReadyState.CLOSED);
                }
            }
        }
    }

    private void handleSuccessfulResponse(Response response) throws IOException {
        ConnectionHandler connectionHandler = new ConnectionHandler(){

            @Override
            public void setReconnectionTime(Duration reconnectionTime) {
                EventSource.this.setReconnectionTime(reconnectionTime);
            }

            @Override
            public void setLastEventId(String lastEventId) {
                EventSource.this.setLastEventId(lastEventId);
            }
        };
        ReadyState previousState = this.readyState.getAndSet(ReadyState.OPEN);
        if (previousState != ReadyState.CONNECTING) {
            this.logger.warn("Unexpected readyState change: " + (Object)((Object)previousState) + " -> " + (Object)((Object)ReadyState.OPEN));
        } else {
            this.logger.debug("readyState change: {} -> {}", (Object)previousState, (Object)ReadyState.OPEN);
        }
        this.logger.info("Connected to EventSource stream.");
        this.handler.onOpen();
        EventParser parser = new EventParser(response.body().byteStream(), this.url.uri(), this.handler, connectionHandler, this.readBufferSize, this.streamEventData, this.expectFields, this.logger);
        while (!Thread.currentThread().isInterrupted() && !parser.isEof()) {
            parser.processStream();
        }
    }

    private ConnectionErrorHandler.Action dispatchError(Throwable t) {
        ConnectionErrorHandler.Action action = this.connectionErrorHandler.onConnectionError(t);
        if (action != ConnectionErrorHandler.Action.SHUTDOWN) {
            this.handler.onError(t);
        }
        return action;
    }

    Duration backoffWithJitter(int reconnectAttempts) {
        long maxTimeLong = Math.min(this.maxReconnectTime.toMillis(), this.reconnectTime.toMillis() * (long)Helpers.pow2(reconnectAttempts));
        int maxTimeInt = maxTimeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxTimeLong;
        return Duration.ofMillis(maxTimeInt / 2 + this.jitter.nextInt(maxTimeInt) / 2);
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        for (String name : defaultHeaders.names()) {
            if (custom.names().contains(name)) continue;
            for (String value : defaultHeaders.values(name)) {
                builder.add(name, value);
            }
        }
        for (String name : custom.names()) {
            for (String value : custom.values(name)) {
                builder.add(name, value);
            }
        }
        return builder.build();
    }

    private void setReconnectionTime(Duration reconnectionTime) {
        this.reconnectTime = reconnectionTime;
    }

    private void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public HttpUrl getHttpUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.url.uri();
    }

    public static final class Builder {
        private String name;
        private Duration reconnectTime = DEFAULT_RECONNECT_TIME;
        private Duration maxReconnectTime = DEFAULT_MAX_RECONNECT_TIME;
        private Duration backoffResetThreshold = DEFAULT_BACKOFF_RESET_THRESHOLD;
        private String lastEventId;
        private final HttpUrl url;
        private final EventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler = ConnectionErrorHandler.DEFAULT;
        private Integer threadPriority = null;
        private Headers headers = Headers.of((String[])new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private String method = "GET";
        private RequestTransformer requestTransformer = null;
        private RequestBody body = null;
        private OkHttpClient.Builder clientBuilder;
        private int readBufferSize = 1000;
        private Logger logger = null;
        private String loggerBaseName = null;
        private int maxEventTasksInFlight = 0;
        private boolean streamEventData;
        private Set<String> expectFields = null;

        public Builder(EventHandler handler, URI uri) {
            this(handler, uri == null ? null : HttpUrl.get((URI)uri));
        }

        public Builder(EventHandler handler, HttpUrl url) {
            if (handler == null) {
                throw new IllegalArgumentException("handler must not be null");
            }
            if (url == null) {
                throw new IllegalArgumentException("URI/URL must not be null");
            }
            this.url = url;
            this.handler = handler;
            this.clientBuilder = Builder.createInitialClientBuilder();
        }

        private static OkHttpClient.Builder createInitialClientBuilder() {
            OkHttpClient.Builder b = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(DEFAULT_CONNECT_TIMEOUT).readTimeout(DEFAULT_READ_TIMEOUT).writeTimeout(DEFAULT_WRITE_TIMEOUT).retryOnConnectionFailure(true);
            try {
                b.sslSocketFactory((SSLSocketFactory)new ModernTLSSocketFactory(), Builder.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return b;
        }

        public Builder method(String method) {
            this.method = method != null && method.length() > 0 ? method.toUpperCase() : "GET";
            return this;
        }

        public Builder body(RequestBody body) {
            this.body = body;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            this.requestTransformer = requestTransformer;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public Builder reconnectTime(Duration reconnectTime) {
            this.reconnectTime = reconnectTime == null ? DEFAULT_RECONNECT_TIME : reconnectTime;
            return this;
        }

        public Builder maxReconnectTime(Duration maxReconnectTime) {
            this.maxReconnectTime = maxReconnectTime == null ? DEFAULT_MAX_RECONNECT_TIME : maxReconnectTime;
            return this;
        }

        public Builder backoffResetThreshold(Duration backoffResetThreshold) {
            this.backoffResetThreshold = backoffResetThreshold == null ? DEFAULT_BACKOFF_RESET_THRESHOLD : backoffResetThreshold;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.clientBuilder.connectTimeout(connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            this.clientBuilder.writeTimeout(writeTimeout == null ? DEFAULT_WRITE_TIMEOUT : writeTimeout);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.clientBuilder.readTimeout(readTimeout == null ? DEFAULT_READ_TIMEOUT : readTimeout);
            return this;
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            this.connectionErrorHandler = handler;
            return this;
        }

        public Builder threadPriority(Integer threadPriority) {
            this.threadPriority = threadPriority;
            return this;
        }

        public Builder clientBuilderActions(ClientConfigurer configurer) {
            configurer.configure(this.clientBuilder);
            return this;
        }

        public Builder readBufferSize(int readBufferSize) {
            if (readBufferSize <= 0) {
                throw new IllegalArgumentException("readBufferSize must be greater than zero");
            }
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder loggerBaseName(String loggerBaseName) {
            this.loggerBaseName = loggerBaseName;
            return this;
        }

        public Builder maxEventTasksInFlight(int maxEventTasksInFlight) {
            this.maxEventTasksInFlight = maxEventTasksInFlight;
            return this;
        }

        public Builder streamEventData(boolean streamEventData) {
            this.streamEventData = streamEventData;
            return this;
        }

        public Builder expectFields(String ... fieldNames) {
            if (fieldNames == null || fieldNames.length == 0) {
                this.expectFields = null;
            } else {
                this.expectFields = new HashSet<String>();
                for (String f : fieldNames) {
                    if (f == null) continue;
                    this.expectFields.add(f);
                }
            }
            return this;
        }

        public EventSource build() {
            if (this.proxy != null) {
                this.clientBuilder.proxy(this.proxy);
            }
            if (this.proxyAuthenticator != null) {
                this.clientBuilder.proxyAuthenticator(this.proxyAuthenticator);
            }
            return new EventSource(this);
        }

        protected OkHttpClient.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }

        public static interface ClientConfigurer {
            public void configure(OkHttpClient.Builder var1);
        }
    }

    public static interface RequestTransformer {
        public Request transformRequest(Request var1);
    }
}

