/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class BufferedUtf8LineReader {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final InputStream stream;
    private final byte[] readBuffer;
    private int readBufferCount = 0;
    private ByteArrayOutputStream pendingUnterminatedLine = null;
    private int scanPos = 0;
    private int lineStart = 0;
    private boolean lastCharWasCr = false;

    public BufferedUtf8LineReader(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.readBuffer = new byte[bufferSize];
    }

    public String readLine() throws IOException {
        do {
            String line;
            if ((line = this.getLineFromBuffer()) == null) continue;
            return line;
        } while (this.readMoreIntoBuffer());
        return null;
    }

    private String getLineFromBuffer() {
        String line;
        int lineEnd;
        byte b;
        if (this.lastCharWasCr && this.scanPos < this.readBufferCount) {
            if (this.scanPos == 0 && this.readBuffer[0] == 10) {
                ++this.scanPos;
                ++this.lineStart;
            }
            this.lastCharWasCr = false;
        }
        while (this.scanPos < this.readBufferCount && (b = this.readBuffer[this.scanPos]) != 10 && b != 13) {
            ++this.scanPos;
        }
        if (this.scanPos == this.readBufferCount) {
            if (this.scanPos > this.lineStart && this.lineStart > 0) {
                System.arraycopy(this.readBuffer, this.lineStart, this.readBuffer, 0, this.readBufferCount - this.lineStart);
                this.readBufferCount -= this.lineStart;
                this.scanPos = this.readBufferCount;
                this.lineStart = 0;
            }
            return null;
        }
        if (this.readBuffer[lineEnd = this.scanPos++] == 13) {
            if (this.scanPos == this.readBufferCount) {
                this.lastCharWasCr = true;
            } else if (this.readBuffer[this.scanPos] == 10) {
                ++this.scanPos;
            }
        }
        if (this.pendingUnterminatedLine != null) {
            this.pendingUnterminatedLine.write(this.readBuffer, this.lineStart, lineEnd - this.lineStart);
            try {
                line = this.pendingUnterminatedLine.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                line = null;
            }
            this.pendingUnterminatedLine = null;
        } else {
            String string = line = lineEnd == this.lineStart ? "" : new String(this.readBuffer, this.lineStart, lineEnd - this.lineStart, UTF8);
        }
        if (this.scanPos == this.readBufferCount) {
            this.lineStart = 0;
            this.scanPos = 0;
            this.readBufferCount = 0;
        } else {
            this.lineStart = this.scanPos;
        }
        return line;
    }

    private boolean readMoreIntoBuffer() throws IOException {
        int readCount;
        if (this.readBufferCount == this.readBuffer.length) {
            if (this.pendingUnterminatedLine == null) {
                this.pendingUnterminatedLine = new ByteArrayOutputStream(this.readBufferCount * 2);
            }
            this.pendingUnterminatedLine.write(this.readBuffer, this.lineStart, this.scanPos - this.lineStart);
            this.readBufferCount = 0;
            this.scanPos = 0;
            this.lineStart = 0;
        }
        if ((readCount = this.stream.read(this.readBuffer, this.readBufferCount, this.readBuffer.length - this.readBufferCount)) < 0) {
            return false;
        }
        this.readBufferCount += readCount;
        return true;
    }
}

