/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements ConnectionHandler,
Closeable {
    private final Logger logger;
    public static final long DEFAULT_RECONNECT_TIME_MS = 1000L;
    public static final long DEFAULT_MAX_RECONNECT_TIME_MS = 30000L;
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    public static final int DEFAULT_WRITE_TIMEOUT_MS = 5000;
    public static final int DEFAULT_READ_TIMEOUT_MS = 300000;
    public static final int DEFAULT_BACKOFF_RESET_THRESHOLD_MS = 60000;
    private static final Headers defaultHeaders = new Headers.Builder().add("Accept", "text/event-stream").add("Cache-Control", "no-cache").build();
    private final String name;
    private volatile HttpUrl url;
    private final Headers headers;
    private final String method;
    private final RequestBody body;
    private final RequestTransformer requestTransformer;
    private final ExecutorService eventExecutor;
    private final ExecutorService streamExecutor;
    private long reconnectTimeMs;
    private long maxReconnectTimeMs;
    private final long backoffResetThresholdMs;
    private volatile String lastEventId;
    private final EventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final SecureRandom jitter = new SecureRandom();
    private Response response;
    private BufferedSource bufferedSource;

    EventSource(Builder builder) {
        this.name = builder.name;
        String loggerName = EventSource.class.getCanonicalName() + (this.name == null || this.name.equals("") ? "" : "." + this.name);
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.url = builder.url;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.method = builder.method;
        this.body = builder.body;
        this.requestTransformer = builder.requestTransformer;
        this.reconnectTimeMs = builder.reconnectTimeMs;
        this.maxReconnectTimeMs = builder.maxReconnectTimeMs;
        this.backoffResetThresholdMs = builder.backoffResetThresholdMs;
        ThreadFactory eventsThreadFactory = this.createThreadFactory("okhttp-eventsource-events");
        this.eventExecutor = Executors.newSingleThreadExecutor(eventsThreadFactory);
        ThreadFactory streamThreadFactory = this.createThreadFactory("okhttp-eventsource-stream");
        this.streamExecutor = Executors.newSingleThreadExecutor(streamThreadFactory);
        this.handler = new AsyncEventHandler(this.eventExecutor, builder.handler);
        this.connectionErrorHandler = builder.connectionErrorHandler;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.clientBuilder.build();
    }

    private ThreadFactory createThreadFactory(final String type) {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        final AtomicLong count = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setName(String.format(Locale.ROOT, "%s-[%s]-%d", type, EventSource.this.name, count.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            this.logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        this.logger.debug("readyState change: " + (Object)((Object)ReadyState.RAW) + " -> " + (Object)((Object)ReadyState.CONNECTING));
        this.logger.info("Starting EventSource client using URI: " + this.url);
        this.streamExecutor.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.connect();
            }
        });
    }

    public void restart() {
        if (this.readyState.compareAndSet(ReadyState.OPEN, ReadyState.CLOSED)) {
            this.closeCurrentStream(ReadyState.OPEN);
        } else {
            ReadyState currentState = this.getState();
            if (currentState == ReadyState.RAW || currentState == ReadyState.CONNECTING) {
                this.start();
            }
        }
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.SHUTDOWN));
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.closeCurrentStream(currentState);
        this.eventExecutor.shutdownNow();
        this.streamExecutor.shutdownNow();
        if (this.client != null) {
            if (this.client.connectionPool() != null) {
                this.client.connectionPool().evictAll();
            }
            if (this.client.dispatcher() != null) {
                this.client.dispatcher().cancelAll();
                if (this.client.dispatcher().executorService() != null) {
                    this.client.dispatcher().executorService().shutdownNow();
                }
            }
        }
    }

    private void closeCurrentStream(ReadyState previousState) {
        if (previousState == ReadyState.OPEN) {
            try {
                this.handler.onClosed();
            }
            catch (Exception e) {
                this.handler.onError(e);
            }
        }
        if (this.call != null) {
            this.call.cancel();
            this.logger.debug("call cancelled");
        }
    }

    Request buildRequest() {
        Request.Builder builder = new Request.Builder().headers(this.headers).url(this.url).method(this.method, this.body);
        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
            builder.addHeader("Last-Event-ID", this.lastEventId);
        }
        Request request = builder.build();
        return this.requestTransformer == null ? request : this.requestTransformer.transformRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void connect() {
        this.response = null;
        this.bufferedSource = null;
        int reconnectAttempts = 0;
        ConnectionErrorHandler.Action errorHandlerAction = null;
        try {
            block27: while (!Thread.currentThread().isInterrupted()) {
                if (this.readyState.get() == ReadyState.SHUTDOWN) return;
                long connectedTime = -1L;
                ReadyState currentState = this.readyState.getAndSet(ReadyState.CONNECTING);
                this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CONNECTING));
                try {
                    this.call = this.client.newCall(this.buildRequest());
                    this.response = this.call.execute();
                    if (this.response.isSuccessful()) {
                        connectedTime = System.currentTimeMillis();
                        currentState = this.readyState.getAndSet(ReadyState.OPEN);
                        if (currentState != ReadyState.CONNECTING) {
                            this.logger.warn("Unexpected readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        } else {
                            this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        }
                        this.logger.info("Connected to Event Source stream.");
                        try {
                            this.handler.onOpen();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                        if (this.bufferedSource != null) {
                            this.bufferedSource.close();
                        }
                        this.bufferedSource = Okio.buffer((Source)this.response.body().source());
                        EventParser parser = new EventParser(this.url.uri(), this.handler, this);
                        while (true) {
                            String line;
                            if (Thread.currentThread().isInterrupted() || (line = this.bufferedSource.readUtf8LineStrict()) == null) continue block27;
                            parser.line(line);
                        }
                    }
                    this.logger.debug("Unsuccessful Response: " + this.response);
                    errorHandlerAction = this.dispatchError(new UnsuccessfulResponseException(this.response.code()));
                }
                catch (EOFException eofe) {
                    this.logger.warn("Connection unexpectedly closed.");
                }
                catch (IOException ioe) {
                    ReadyState state = this.readyState.get();
                    if (state == ReadyState.SHUTDOWN) {
                        errorHandlerAction = ConnectionErrorHandler.Action.SHUTDOWN;
                        continue;
                    }
                    if (state == ReadyState.CLOSED) {
                        errorHandlerAction = ConnectionErrorHandler.Action.PROCEED;
                        continue;
                    }
                    this.logger.debug("Connection problem.", (Throwable)ioe);
                    errorHandlerAction = this.dispatchError(ioe);
                }
                finally {
                    ReadyState nextState = ReadyState.CLOSED;
                    if (errorHandlerAction == ConnectionErrorHandler.Action.SHUTDOWN) {
                        this.logger.info("Connection has been explicitly shut down by error handler");
                        nextState = ReadyState.SHUTDOWN;
                    }
                    currentState = this.readyState.getAndSet(nextState);
                    this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)nextState));
                    if (this.response != null && this.response.body() != null) {
                        this.response.close();
                        this.logger.debug("response closed");
                    }
                    if (this.bufferedSource != null) {
                        try {
                            this.bufferedSource.close();
                            this.logger.debug("buffered source closed");
                        }
                        catch (IOException e) {
                            this.logger.warn("Exception when closing bufferedSource", (Throwable)e);
                        }
                    }
                    if (currentState == ReadyState.OPEN) {
                        try {
                            this.handler.onClosed();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                    }
                    if (nextState == ReadyState.SHUTDOWN) continue;
                    if (connectedTime >= 0L && System.currentTimeMillis() - connectedTime >= this.backoffResetThresholdMs) {
                        reconnectAttempts = 0;
                    }
                    this.maybeWaitWithBackoff(++reconnectAttempts);
                }
            }
            return;
        }
        catch (RejectedExecutionException ignored) {
            this.call = null;
            this.response = null;
            this.bufferedSource = null;
            this.logger.debug("Rejected execution exception ignored: ", (Throwable)ignored);
        }
    }

    private ConnectionErrorHandler.Action dispatchError(Throwable t) {
        ConnectionErrorHandler.Action action = this.connectionErrorHandler.onConnectionError(t);
        if (action != ConnectionErrorHandler.Action.SHUTDOWN) {
            this.handler.onError(t);
        }
        return action;
    }

    private void maybeWaitWithBackoff(int reconnectAttempts) {
        if (this.reconnectTimeMs > 0L && reconnectAttempts > 0) {
            try {
                long sleepTimeMs = this.backoffWithJitter(reconnectAttempts);
                this.logger.info("Waiting " + sleepTimeMs + " milliseconds before reconnecting...");
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    long backoffWithJitter(int reconnectAttempts) {
        long maxTimeLong = Math.min(this.maxReconnectTimeMs, this.reconnectTimeMs * (long)this.pow2(reconnectAttempts));
        int maxTimeInt = maxTimeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxTimeLong;
        return maxTimeInt / 2 + this.jitter.nextInt(maxTimeInt) / 2;
    }

    private int pow2(int k) {
        return k < 31 ? 1 << k : Integer.MAX_VALUE;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        for (String name : defaultHeaders.names()) {
            if (custom.names().contains(name)) continue;
            for (String value : defaultHeaders.values(name)) {
                builder.add(name, value);
            }
        }
        for (String name : custom.names()) {
            for (String value : custom.values(name)) {
                builder.add(name, value);
            }
        }
        return builder.build();
    }

    @Override
    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    public void setMaxReconnectTimeMs(long maxReconnectTimeMs) {
        this.maxReconnectTimeMs = maxReconnectTimeMs;
    }

    public long getMaxReconnectTimeMs() {
        return this.maxReconnectTimeMs;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public HttpUrl getHttpUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.url.uri();
    }

    public void setHttpUrl(HttpUrl url) {
        if (url == null) {
            throw EventSource.badUrlException();
        }
        this.url = url;
    }

    public void setUri(URI uri) {
        this.setHttpUrl(uri == null ? null : HttpUrl.get((URI)uri));
    }

    private static IllegalArgumentException badUrlException() {
        return new IllegalArgumentException("URI/URL must not be null and must be HTTP or HTTPS");
    }

    public static final class Builder {
        private String name = "";
        private long reconnectTimeMs = 1000L;
        private long maxReconnectTimeMs = 30000L;
        private long backoffResetThresholdMs = 60000L;
        private final HttpUrl url;
        private final EventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler = ConnectionErrorHandler.DEFAULT;
        private Headers headers = Headers.of((String[])new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private String method = "GET";
        private RequestTransformer requestTransformer = null;
        private RequestBody body = null;
        private OkHttpClient.Builder clientBuilder;

        public Builder(EventHandler handler, URI uri) {
            this(handler, uri == null ? null : HttpUrl.get((URI)uri));
        }

        public Builder(EventHandler handler, HttpUrl url) {
            if (handler == null) {
                throw new IllegalArgumentException("handler must not be null");
            }
            if (url == null) {
                throw EventSource.badUrlException();
            }
            this.url = url;
            this.handler = handler;
            this.clientBuilder = Builder.createInitialClientBuilder();
        }

        private static OkHttpClient.Builder createInitialClientBuilder() {
            OkHttpClient.Builder b = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(300000L, TimeUnit.MILLISECONDS).writeTimeout(5000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
            try {
                b.sslSocketFactory((SSLSocketFactory)new ModernTLSSocketFactory(), Builder.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return b;
        }

        public Builder method(String method) {
            if (method != null && method.length() > 0) {
                this.method = method.toUpperCase();
            }
            return this;
        }

        public Builder body(RequestBody body) {
            this.body = body;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            this.requestTransformer = requestTransformer;
            return this;
        }

        public Builder name(String name) {
            if (name != null) {
                this.name = name;
            }
            return this;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder maxReconnectTimeMs(long maxReconnectTimeMs) {
            this.maxReconnectTimeMs = maxReconnectTimeMs;
            return this;
        }

        public Builder backoffResetThresholdMs(long backoffResetThresholdMs) {
            this.backoffResetThresholdMs = backoffResetThresholdMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectTimeoutMs(int connectTimeoutMs) {
            this.clientBuilder.connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder writeTimeoutMs(int writeTimeoutMs) {
            this.clientBuilder.writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder readTimeoutMs(int readTimeoutMs) {
            this.clientBuilder.readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            if (handler != null) {
                this.connectionErrorHandler = handler;
            }
            return this;
        }

        public Builder clientBuilderActions(ClientConfigurer configurer) {
            configurer.configure(this.clientBuilder);
            return this;
        }

        public EventSource build() {
            if (this.proxy != null) {
                this.clientBuilder.proxy(this.proxy);
            }
            if (this.proxyAuthenticator != null) {
                this.clientBuilder.proxyAuthenticator(this.proxyAuthenticator);
            }
            return new EventSource(this);
        }

        protected OkHttpClient.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }

        public static interface ClientConfigurer {
            public void configure(OkHttpClient.Builder var1);
        }
    }

    public static interface RequestTransformer {
        public Request transformRequest(Request var1);
    }
}

