/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.MessageEvent;
import java.util.concurrent.Executor;

class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
    }

    @Override
    public void onOpen() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onOpen();
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    @Override
    public void onClosed() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onClosed();
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    @Override
    public void onComment(final String comment) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onComment(comment);
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    @Override
    public void onMessage(final String event, final MessageEvent messageEvent) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onMessage(event, messageEvent);
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    @Override
    public void onError(final Throwable error) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onError(error);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

