/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDSLF4J {
    private LDSLF4J() {
    }

    public static LDLogAdapter adapter() {
        return AdapterImpl.INSTANCE;
    }

    private static final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final Logger logger;

        ChannelImpl(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            switch (level) {
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case WARN: {
                    return this.logger.isWarnEnabled();
                }
            }
            return this.logger.isErrorEnabled();
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            if (this.isEnabled(level)) {
                String s = message == null ? "" : message.toString();
                switch (level) {
                    case DEBUG: {
                        this.logger.debug(s);
                        break;
                    }
                    case INFO: {
                        this.logger.info(s);
                        break;
                    }
                    case WARN: {
                        this.logger.warn(s);
                        break;
                    }
                    case ERROR: {
                        this.logger.error(s);
                        break;
                    }
                }
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            switch (level) {
                case DEBUG: {
                    this.logger.debug(format, param);
                    break;
                }
                case INFO: {
                    this.logger.info(format, param);
                    break;
                }
                case WARN: {
                    this.logger.warn(format, param);
                    break;
                }
                case ERROR: {
                    this.logger.error(format, param);
                    break;
                }
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            switch (level) {
                case DEBUG: {
                    this.logger.debug(format, param1, param2);
                    break;
                }
                case INFO: {
                    this.logger.info(format, param1, param2);
                    break;
                }
                case WARN: {
                    this.logger.warn(format, param1, param2);
                    break;
                }
                case ERROR: {
                    this.logger.error(format, param1, param2);
                    break;
                }
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            switch (level) {
                case DEBUG: {
                    this.logger.debug(format, params);
                    break;
                }
                case INFO: {
                    this.logger.info(format, params);
                    break;
                }
                case WARN: {
                    this.logger.warn(format, params);
                    break;
                }
                case ERROR: {
                    this.logger.error(format, params);
                    break;
                }
            }
        }
    }

    private static final class AdapterImpl
    implements LDLogAdapter,
    LDLogAdapter.IsConfiguredExternally {
        private static final AdapterImpl INSTANCE = new AdapterImpl();

        private AdapterImpl() {
        }

        @Override
        public LDLogAdapter.Channel newChannel(String name) {
            return new ChannelImpl(LoggerFactory.getLogger((String)name));
        }
    }
}

