/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.BigSegmentStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagTrackerImpl;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.shaded.org.apache.commons.codec.binary.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class LDClient
implements LDClientInterface {
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private final String sdkKey;
    private final boolean offline;
    private final Evaluator evaluator;
    final EventProcessor eventProcessor;
    final DataSource dataSource;
    final DataStore dataStore;
    private final BigSegmentStoreStatusProvider bigSegmentStoreStatusProvider;
    private final BigSegmentStoreWrapper bigSegmentStoreWrapper;
    private final DataSourceUpdateSink dataSourceUpdates;
    private final DataStoreStatusProviderImpl dataStoreStatusProvider;
    private final DataSourceStatusProviderImpl dataSourceStatusProvider;
    private final FlagTrackerImpl flagTracker;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster;
    private final ScheduledExecutorService sharedExecutor;
    private final LDLogger baseLogger;
    private final LDLogger evaluationLogger;
    private final Evaluator.PrerequisiteEvaluationSink prereqEvalsDefault;
    private final Evaluator.PrerequisiteEvaluationSink prereqEvalsWithReasons;

    public LDClient(String sdkKey) {
        this(sdkKey, LDConfig.DEFAULT);
    }

    private static final DataModel.FeatureFlag getFlag(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.FEATURES, key);
        return item == null ? null : (DataModel.FeatureFlag)item.getItem();
    }

    private static final DataModel.Segment getSegment(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.SEGMENTS, key);
        return item == null ? null : (DataModel.Segment)item.getItem();
    }

    public LDClient(String sdkKey, LDConfig config) {
        Preconditions.checkNotNull(config, "config must not be null");
        this.sdkKey = Preconditions.checkNotNull(sdkKey, "sdkKey must not be null");
        if (!HttpHelpers.isAsciiHeaderValue(sdkKey)) {
            throw new IllegalArgumentException("SDK key contained an invalid character");
        }
        this.offline = config.offline;
        this.sharedExecutor = this.createSharedExecutor(config);
        ClientContextImpl context = ClientContextImpl.fromConfig(sdkKey, config, this.sharedExecutor);
        this.baseLogger = context.getBaseLogger();
        this.evaluationLogger = this.baseLogger.subLogger("Evaluation");
        this.eventProcessor = config.events.build(context);
        EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> bigSegmentStoreStatusNotifier = EventBroadcasterImpl.forBigSegmentStoreStatus(this.sharedExecutor, this.baseLogger);
        BigSegmentsConfiguration bigSegmentsConfig = config.bigSegments.build(context);
        this.bigSegmentStoreWrapper = bigSegmentsConfig.getStore() != null ? new BigSegmentStoreWrapper(bigSegmentsConfig, bigSegmentStoreStatusNotifier, this.sharedExecutor, this.baseLogger.subLogger("BigSegments")) : null;
        this.bigSegmentStoreStatusProvider = new BigSegmentStoreStatusProviderImpl(bigSegmentStoreStatusNotifier, this.bigSegmentStoreWrapper);
        EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> dataStoreStatusNotifier = EventBroadcasterImpl.forDataStoreStatus(this.sharedExecutor, this.baseLogger);
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(dataStoreStatusNotifier);
        this.dataStore = config.dataStore.build(context.withDataStoreUpdateSink(dataStoreUpdates));
        this.evaluator = new Evaluator(new Evaluator.Getters(){

            @Override
            public DataModel.FeatureFlag getFlag(String key) {
                return LDClient.getFlag(LDClient.this.dataStore, key);
            }

            @Override
            public DataModel.Segment getSegment(String key) {
                return LDClient.getSegment(LDClient.this.dataStore, key);
            }

            @Override
            public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String key) {
                BigSegmentStoreWrapper wrapper = LDClient.this.bigSegmentStoreWrapper;
                return wrapper == null ? null : wrapper.getUserMembership(key);
            }
        }, this.evaluationLogger);
        this.flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents(this.sharedExecutor, this.baseLogger);
        this.flagTracker = new FlagTrackerImpl(this.flagChangeBroadcaster, (key, ctx) -> this.jsonValueVariation((String)key, (LDContext)ctx, LDValue.ofNull()));
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl(this.dataStore, dataStoreUpdates);
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier = EventBroadcasterImpl.forDataSourceStatus(this.sharedExecutor, this.baseLogger);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(this.dataStore, this.dataStoreStatusProvider, this.flagChangeBroadcaster, dataSourceStatusNotifier, this.sharedExecutor, context.getLogging().getLogDataSourceOutageAsErrorAfter(), this.baseLogger);
        this.dataSourceUpdates = dataSourceUpdates;
        this.dataSource = config.dataSource.build(context.withDataSourceUpdateSink(dataSourceUpdates));
        this.dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusNotifier, dataSourceUpdates);
        this.prereqEvalsDefault = this.makePrerequisiteEventSender(false);
        this.prereqEvalsWithReasons = this.makePrerequisiteEventSender(true);
        Future<Void> startFuture = this.dataSource.start();
        if (!config.startWait.isZero() && !config.startWait.isNegative()) {
            if (!(this.dataSource instanceof ComponentsImpl.NullDataSource)) {
                this.baseLogger.info("Waiting up to {} milliseconds for LaunchDarkly client to start...", (Object)config.startWait.toMillis());
            }
            try {
                startFuture.get(config.startWait.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.baseLogger.error("Timeout encountered waiting for LaunchDarkly client initialization");
            }
            catch (Exception e) {
                this.baseLogger.error("Exception encountered waiting for LaunchDarkly client initialization: {}", LogValues.exceptionSummary(e));
                this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
            }
            if (!this.dataSource.isInitialized()) {
                this.baseLogger.warn("LaunchDarkly client was not successfully initialized");
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public void track(String eventName, LDContext context) {
        this.trackData(eventName, context, LDValue.ofNull());
    }

    @Override
    public void trackData(String eventName, LDContext context, LDValue data) {
        if (context == null) {
            this.baseLogger.warn("Track called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Track called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordCustomEvent(context, eventName, data, null);
        }
    }

    @Override
    public void trackMetric(String eventName, LDContext context, LDValue data, double metricValue) {
        if (context == null) {
            this.baseLogger.warn("Track called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Track called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordCustomEvent(context, eventName, data, metricValue);
        }
    }

    @Override
    public void identify(LDContext context) {
        if (context == null) {
            this.baseLogger.warn("Identify called with null context!");
        } else if (!context.isValid()) {
            this.baseLogger.warn("Identify called with invalid context: " + context.getError());
        } else {
            this.eventProcessor.recordIdentifyEvent(context);
        }
    }

    @Override
    public FeatureFlagsState allFlagsState(LDContext context, FlagsStateOption ... options) {
        DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> flags;
        FeatureFlagsState.Builder builder = FeatureFlagsState.builder(options);
        if (this.isOffline()) {
            this.evaluationLogger.debug("allFlagsState() was called when client is in offline mode.");
        }
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                this.evaluationLogger.warn("allFlagsState() was called before client initialized; using last known values from data store");
            } else {
                this.evaluationLogger.warn("allFlagsState() was called before client initialized; data store unavailable, returning no data");
                return builder.valid(false).build();
            }
        }
        if (context == null) {
            this.evaluationLogger.warn("allFlagsState() was called with null context! returning no data");
            return builder.valid(false).build();
        }
        if (!context.isValid()) {
            this.evaluationLogger.warn("allFlagsState() was called with invalid context: " + context.getError());
            return builder.valid(false).build();
        }
        boolean clientSideOnly = FlagsStateOption.hasOption(options, FlagsStateOption.CLIENT_SIDE_ONLY);
        try {
            flags = this.dataStore.getAll(DataModel.FEATURES);
        }
        catch (Exception e) {
            this.evaluationLogger.error("Exception from data store when evaluating all flags: {}", LogValues.exceptionSummary(e));
            this.evaluationLogger.debug(e.toString(), LogValues.exceptionTrace(e));
            return builder.valid(false).build();
        }
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> entry : flags.getItems()) {
            if (entry.getValue().getItem() == null) continue;
            DataModel.FeatureFlag flag = (DataModel.FeatureFlag)entry.getValue().getItem();
            if (clientSideOnly && !flag.isClientSide()) continue;
            try {
                EvalResult result = this.evaluator.evaluate(flag, context, null);
                builder.addFlag(flag, result);
            }
            catch (Exception e) {
                this.evaluationLogger.error("Exception caught for feature flag \"{}\" when evaluating all flags: {}", (Object)entry.getKey(), LogValues.exceptionSummary(e));
                this.evaluationLogger.debug(e.toString(), LogValues.exceptionTrace(e));
                builder.addFlag(flag, EvalResult.of(LDValue.ofNull(), -1, EvaluationReason.exception(e)));
            }
        }
        return builder.build();
    }

    @Override
    public boolean boolVariation(String featureKey, LDContext context, boolean defaultValue) {
        return this.evaluate(featureKey, context, LDValue.of(defaultValue), LDValueType.BOOLEAN).booleanValue();
    }

    @Override
    public int intVariation(String featureKey, LDContext context, int defaultValue) {
        return this.evaluate(featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER).intValue();
    }

    @Override
    public double doubleVariation(String featureKey, LDContext context, double defaultValue) {
        return this.evaluate(featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER).doubleValue();
    }

    @Override
    public String stringVariation(String featureKey, LDContext context, String defaultValue) {
        return this.evaluate(featureKey, context, LDValue.of(defaultValue), LDValueType.STRING).stringValue();
    }

    @Override
    public LDValue jsonValueVariation(String featureKey, LDContext context, LDValue defaultValue) {
        return this.evaluate(featureKey, context, LDValue.normalize(defaultValue), null);
    }

    @Override
    public EvaluationDetail<Boolean> boolVariationDetail(String featureKey, LDContext context, boolean defaultValue) {
        EvalResult result = this.evaluateInternal(featureKey, context, LDValue.of(defaultValue), LDValueType.BOOLEAN, true);
        return result.getAsBoolean();
    }

    @Override
    public EvaluationDetail<Integer> intVariationDetail(String featureKey, LDContext context, int defaultValue) {
        EvalResult result = this.evaluateInternal(featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, true);
        return result.getAsInteger();
    }

    @Override
    public EvaluationDetail<Double> doubleVariationDetail(String featureKey, LDContext context, double defaultValue) {
        EvalResult result = this.evaluateInternal(featureKey, context, LDValue.of(defaultValue), LDValueType.NUMBER, true);
        return result.getAsDouble();
    }

    @Override
    public EvaluationDetail<String> stringVariationDetail(String featureKey, LDContext context, String defaultValue) {
        EvalResult result = this.evaluateInternal(featureKey, context, LDValue.of(defaultValue), LDValueType.STRING, true);
        return result.getAsString();
    }

    @Override
    public EvaluationDetail<LDValue> jsonValueVariationDetail(String featureKey, LDContext context, LDValue defaultValue) {
        EvalResult result = this.evaluateInternal(featureKey, context, LDValue.normalize(defaultValue), null, true);
        return result.getAnyType();
    }

    @Override
    public boolean isFlagKnown(String featureKey) {
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                this.baseLogger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                this.baseLogger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; data store unavailable, returning false", (Object)featureKey);
                return false;
            }
        }
        try {
            if (LDClient.getFlag(this.dataStore, featureKey) != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.baseLogger.error("Encountered exception while calling isFlagKnown for feature flag \"{}\": {}", (Object)featureKey, LogValues.exceptionSummary(e));
            this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
        }
        return false;
    }

    private LDValue evaluate(String featureKey, LDContext context, LDValue defaultValue, LDValueType requireType) {
        return this.evaluateInternal(featureKey, context, defaultValue, requireType, false).getValue();
    }

    private EvalResult errorResult(EvaluationReason.ErrorKind errorKind, LDValue defaultValue) {
        return EvalResult.of(defaultValue, -1, EvaluationReason.error(errorKind));
    }

    private EvalResult evaluateInternal(String featureKey, LDContext context, LDValue defaultValue, LDValueType requireType, boolean withDetail) {
        if (!this.isInitialized()) {
            if (this.dataStore.isInitialized()) {
                this.evaluationLogger.warn("Evaluation called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                this.evaluationLogger.warn("Evaluation called before client initialized for feature flag \"{}\"; data store unavailable, returning default value", (Object)featureKey);
                this.recordEvaluationUnknownFlagErrorEvent(featureKey, context, defaultValue, EvaluationReason.ErrorKind.CLIENT_NOT_READY, withDetail);
                return this.errorResult(EvaluationReason.ErrorKind.CLIENT_NOT_READY, defaultValue);
            }
        }
        if (context == null) {
            this.evaluationLogger.warn("Null context when evaluating flag \"{}\"; returning default value", (Object)featureKey);
            return this.errorResult(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue);
        }
        if (!context.isValid()) {
            this.evaluationLogger.warn("Invalid context when evaluating flag \"{}\"; returning default value: " + context.getError(), (Object)featureKey);
            return this.errorResult(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue);
        }
        DataModel.FeatureFlag featureFlag = null;
        try {
            featureFlag = LDClient.getFlag(this.dataStore, featureKey);
            if (featureFlag == null) {
                this.evaluationLogger.info("Unknown feature flag \"{}\"; returning default value", (Object)featureKey);
                this.recordEvaluationUnknownFlagErrorEvent(featureKey, context, defaultValue, EvaluationReason.ErrorKind.FLAG_NOT_FOUND, withDetail);
                return this.errorResult(EvaluationReason.ErrorKind.FLAG_NOT_FOUND, defaultValue);
            }
            EvalResult evalResult = this.evaluator.evaluate(featureFlag, context, withDetail ? this.prereqEvalsWithReasons : this.prereqEvalsDefault);
            if (evalResult.isNoVariation()) {
                evalResult = EvalResult.of(defaultValue, evalResult.getVariationIndex(), evalResult.getReason());
            } else {
                LDValue value = evalResult.getValue();
                if (requireType != null && !value.isNull() && value.getType() != requireType) {
                    this.evaluationLogger.error("Feature flag evaluation expected result as {}, but got {}", (Object)defaultValue.getType(), (Object)value.getType());
                    this.recordEvaluationErrorEvent(featureFlag, context, defaultValue, EvaluationReason.ErrorKind.WRONG_TYPE, withDetail);
                    return this.errorResult(EvaluationReason.ErrorKind.WRONG_TYPE, defaultValue);
                }
            }
            this.recordEvaluationEvent(featureFlag, context, evalResult, defaultValue, withDetail, null);
            return evalResult;
        }
        catch (Exception e) {
            this.evaluationLogger.error("Encountered exception while evaluating feature flag \"{}\": {}", (Object)featureKey, LogValues.exceptionSummary(e));
            this.evaluationLogger.debug("{}", LogValues.exceptionTrace(e));
            if (featureFlag == null) {
                this.recordEvaluationUnknownFlagErrorEvent(featureKey, context, defaultValue, EvaluationReason.ErrorKind.EXCEPTION, withDetail);
            } else {
                this.recordEvaluationErrorEvent(featureFlag, context, defaultValue, EvaluationReason.ErrorKind.EXCEPTION, withDetail);
            }
            return EvalResult.of(defaultValue, -1, EvaluationReason.exception(e));
        }
    }

    @Override
    public FlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public BigSegmentStoreStatusProvider getBigSegmentStoreStatusProvider() {
        return this.bigSegmentStoreStatusProvider;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public void close() throws IOException {
        this.baseLogger.info("Closing LaunchDarkly Client");
        this.dataStore.close();
        this.eventProcessor.close();
        this.dataSource.close();
        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, null);
        if (this.bigSegmentStoreWrapper != null) {
            this.bigSegmentStoreWrapper.close();
        }
        this.sharedExecutor.shutdownNow();
    }

    @Override
    public void flush() {
        this.eventProcessor.flush();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public String secureModeHash(LDContext context) {
        if (context == null || !context.isValid()) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(this.sdkKey.getBytes(), HMAC_ALGORITHM));
            return Hex.encodeHexString(mac.doFinal(context.getFullyQualifiedKey().getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.baseLogger.error("Could not generate secure mode hash: {}", LogValues.exceptionSummary(e));
            this.baseLogger.debug("{}", LogValues.exceptionTrace(e));
            return null;
        }
    }

    @Override
    public String version() {
        return "6.3.0";
    }

    private void recordEvaluationUnknownFlagErrorEvent(String flagKey, LDContext context, LDValue defaultValue, EvaluationReason.ErrorKind errorKind, boolean withReasons) {
        this.eventProcessor.recordEvaluationEvent(context, flagKey, -1, -1, defaultValue, withReasons ? EvaluationReason.error(errorKind) : null, defaultValue, null, false, null);
    }

    private void recordEvaluationErrorEvent(DataModel.FeatureFlag flag, LDContext context, LDValue defaultValue, EvaluationReason.ErrorKind errorKind, boolean withReasons) {
        this.eventProcessor.recordEvaluationEvent(context, flag.getKey(), flag.getVersion(), -1, defaultValue, withReasons ? EvaluationReason.error(errorKind) : null, defaultValue, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate());
    }

    private void recordEvaluationEvent(DataModel.FeatureFlag flag, LDContext context, EvalResult result, LDValue defaultValue, boolean withReasons, String prereqOf) {
        this.eventProcessor.recordEvaluationEvent(context, flag.getKey(), flag.getVersion(), result.getVariationIndex(), result.getValue(), withReasons || result.isForceReasonTracking() ? result.getReason() : null, defaultValue, prereqOf, flag.isTrackEvents() || result.isForceReasonTracking(), flag.getDebugEventsUntilDate());
    }

    private Evaluator.PrerequisiteEvaluationSink makePrerequisiteEventSender(final boolean withReasons) {
        return new Evaluator.PrerequisiteEvaluationSink(){

            @Override
            public void recordPrerequisiteEvaluation(DataModel.FeatureFlag flag, DataModel.FeatureFlag prereqOfFlag, LDContext context, EvalResult result) {
                LDClient.this.recordEvaluationEvent(flag, context, result, LDValue.ofNull(), withReasons, prereqOfFlag.getKey());
            }
        };
    }

    private ScheduledExecutorService createSharedExecutor(LDConfig config) {
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-tasks-%d").setPriority(config.threadPriority).build();
        return Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }
}

