/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource.background;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.CommentEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.FaultEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StartedEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamClosedByCallerException;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.background.BackgroundEventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.background.ConnectionErrorHandler;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BackgroundEventSource
implements Closeable {
    public static final String DEFAULT_THREAD_BASE_NAME = "EventSource";
    private final EventSource eventSource;
    private final BackgroundEventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    private final Executor streamExecutor;
    private final Executor eventsExecutor;
    private final boolean shouldCloseStreamExecutor;
    private final boolean shouldCloseEventsExecutor;
    private final Semaphore eventThreadSemaphore;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final LDLogger logger;

    BackgroundEventSource(Builder builder) {
        this.eventSource = builder.eventSourceBuilder.build();
        this.handler = builder.handler;
        this.connectionErrorHandler = builder.connectionErrorHandler;
        if (builder.eventsExecutor == null) {
            this.eventsExecutor = Executors.newSingleThreadExecutor(this.makeSimpleDaemonThreadFactory("okhttp-eventsource-events", builder.threadBaseName, builder.threadPriority));
            this.shouldCloseEventsExecutor = true;
        } else {
            this.eventsExecutor = builder.eventsExecutor;
            this.shouldCloseEventsExecutor = false;
        }
        if (builder.streamExecutor == null) {
            this.streamExecutor = Executors.newSingleThreadExecutor(this.makeSimpleDaemonThreadFactory("okhttp-eventsource-stream", builder.threadBaseName, builder.threadPriority));
            this.shouldCloseStreamExecutor = true;
        } else {
            this.streamExecutor = builder.streamExecutor;
            this.shouldCloseStreamExecutor = false;
        }
        this.eventThreadSemaphore = builder.maxEventTasksInFlight > 0 ? new Semaphore(builder.maxEventTasksInFlight) : null;
        this.logger = this.eventSource.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        BackgroundEventSource backgroundEventSource = this;
        synchronized (backgroundEventSource) {
            if (this.closed.get() || this.started.get()) {
                return;
            }
            this.started.set(true);
            this.streamExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    BackgroundEventSource.this.logger.debug("BackgroundEventSource started");
                    while (BackgroundEventSource.this.pollAndDispatchEvent()) {
                    }
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BackgroundEventSource.this.close();
                        }
                    }).start();
                }
            });
        }
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BackgroundEventSource backgroundEventSource = this;
        synchronized (backgroundEventSource) {
            if (this.closed.getAndSet(true)) {
                return;
            }
        }
        this.logger.debug("BackgroundEventSource stopping");
        this.eventSource.close();
        if (this.shouldCloseStreamExecutor && this.streamExecutor instanceof ExecutorService) {
            ((ExecutorService)this.streamExecutor).shutdown();
            try {
                ((ExecutorService)this.streamExecutor).awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.shouldCloseEventsExecutor && this.eventsExecutor instanceof ExecutorService) {
            ((ExecutorService)this.eventsExecutor).shutdown();
            try {
                ((ExecutorService)this.eventsExecutor).awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean pollAndDispatchEvent() {
        StreamEvent event;
        try {
            event = this.eventSource.readAnyEvent();
        }
        catch (StreamException e) {
            event = new FaultEvent(e);
        }
        if (event instanceof FaultEvent) {
            e = ((FaultEvent)event).getCause();
            if (e instanceof StreamClosedByCallerException) {
                return false;
            }
            this.dispatchEvent(event);
            if (this.connectionErrorHandler != null && this.connectionErrorHandler.onConnectionError(e) == ConnectionErrorHandler.Action.SHUTDOWN) {
                return false;
            }
        } else {
            this.dispatchEvent(event);
        }
        return true;
    }

    private void dispatchEvent(final StreamEvent event) {
        if (this.closed.get()) {
            return;
        }
        if (this.eventThreadSemaphore != null) {
            try {
                this.eventThreadSemaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Thread interrupted while waiting for event thread semaphore", e);
            }
        }
        this.eventsExecutor.execute(new Runnable(){

            @Override
            public void run() {
                block18: {
                    try {
                        if (event instanceof MessageEvent) {
                            try (MessageEvent me = (MessageEvent)event;){
                                BackgroundEventSource.this.handler.onMessage(me.getEventName(), me);
                                break block18;
                            }
                        }
                        if (event instanceof CommentEvent) {
                            CommentEvent ce = (CommentEvent)event;
                            BackgroundEventSource.this.handler.onComment(ce.getText());
                        } else if (event instanceof StartedEvent) {
                            BackgroundEventSource.this.handler.onOpen();
                        } else if (event instanceof FaultEvent) {
                            FaultEvent se = (FaultEvent)event;
                            if (!(se.getCause() instanceof StreamClosedByCallerException)) {
                                BackgroundEventSource.this.handler.onError(se.getCause());
                            }
                            BackgroundEventSource.this.handler.onClosed();
                        }
                    }
                    catch (Exception e) {
                        BackgroundEventSource.this.logger.warn("Caught unexpected error from EventHandler: {}", LogValues.exceptionSummary(e));
                        BackgroundEventSource.this.logger.debug(LogValues.exceptionTrace(e));
                        try {
                            BackgroundEventSource.this.handler.onError(e);
                        }
                        catch (Exception ee) {
                            BackgroundEventSource.this.logger.warn("Caught unexpected error from EventHandler.onError(): {}", LogValues.exceptionSummary(ee));
                            BackgroundEventSource.this.logger.debug(LogValues.exceptionTrace(ee));
                        }
                    }
                    finally {
                        if (BackgroundEventSource.this.eventThreadSemaphore != null) {
                            BackgroundEventSource.this.eventThreadSemaphore.release();
                        }
                    }
                }
            }
        });
    }

    private ThreadFactory makeSimpleDaemonThreadFactory(String categoryName, String threadBaseName, final int threadPriority) {
        final String baseName = categoryName + "[" + threadBaseName + "]";
        final ThreadGroup threadGroup = new ThreadGroup(baseName);
        final AtomicInteger counter = new AtomicInteger(0);
        threadGroup.setDaemon(true);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(threadGroup, r, baseName + "-" + counter.incrementAndGet());
                t.setDaemon(true);
                if (threadPriority > 0) {
                    t.setPriority(threadPriority);
                }
                return t;
            }
        };
    }

    public static class Builder {
        private final EventSource.Builder eventSourceBuilder;
        private final BackgroundEventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler;
        private Executor eventsExecutor;
        private int maxEventTasksInFlight;
        private Executor streamExecutor;
        private String threadBaseName;
        private int threadPriority;

        public Builder(BackgroundEventHandler handler, EventSource.Builder eventSourceBuilder) {
            if (handler == null) {
                throw new IllegalArgumentException("handler cannot be null");
            }
            if (eventSourceBuilder == null) {
                throw new IllegalArgumentException("eventSourceBuilder cannot be null");
            }
            this.eventSourceBuilder = eventSourceBuilder;
            this.handler = handler;
        }

        public BackgroundEventSource build() {
            return new BackgroundEventSource(this);
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            this.connectionErrorHandler = handler;
            return this;
        }

        public Builder eventsExecutor(Executor eventsExecutor) {
            this.eventsExecutor = eventsExecutor;
            return this;
        }

        public Builder maxEventTasksInFlight(int maxEventTasksInFlight) {
            this.maxEventTasksInFlight = maxEventTasksInFlight;
            return this;
        }

        public Builder streamExecutor(Executor streamExecutor) {
            this.streamExecutor = streamExecutor;
            return this;
        }

        public Builder threadBaseName(String threadBaseName) {
            this.threadBaseName = threadBaseName == null ? BackgroundEventSource.DEFAULT_THREAD_BASE_NAME : threadBaseName;
            return this;
        }

        public Builder threadPriority(Integer threadPriority) {
            this.threadPriority = threadPriority == null ? 0 : threadPriority;
            return this;
        }
    }
}

