/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import java.io.Closeable;
import java.io.IOException;

public interface LDClientInterface
extends Closeable {
    public boolean isInitialized();

    public void track(String var1, LDContext var2);

    default public void track(String eventName, LDUser user) {
        this.track(eventName, LDContext.fromUser(user));
    }

    public void trackData(String var1, LDContext var2, LDValue var3);

    default public void trackData(String eventName, LDUser user, LDValue data) {
        this.trackData(eventName, LDContext.fromUser(user), data);
    }

    public void trackMetric(String var1, LDContext var2, LDValue var3, double var4);

    default public void trackMetric(String eventName, LDUser user, LDValue data, double metricValue) {
        this.trackMetric(eventName, LDContext.fromUser(user), data, metricValue);
    }

    public void identify(LDContext var1);

    default public void identify(LDUser user) {
        this.identify(LDContext.fromUser(user));
    }

    public FeatureFlagsState allFlagsState(LDContext var1, FlagsStateOption ... var2);

    default public FeatureFlagsState allFlagsState(LDUser user, FlagsStateOption ... options) {
        return this.allFlagsState(LDContext.fromUser(user), options);
    }

    public boolean boolVariation(String var1, LDContext var2, boolean var3);

    default public boolean boolVariation(String key, LDUser user, boolean defaultValue) {
        return this.boolVariation(key, LDContext.fromUser(user), defaultValue);
    }

    public int intVariation(String var1, LDContext var2, int var3);

    default public int intVariation(String key, LDUser user, int defaultValue) {
        return this.intVariation(key, LDContext.fromUser(user), defaultValue);
    }

    public double doubleVariation(String var1, LDContext var2, double var3);

    default public double doubleVariation(String key, LDUser user, double defaultValue) {
        return this.doubleVariation(key, LDContext.fromUser(user), defaultValue);
    }

    public String stringVariation(String var1, LDContext var2, String var3);

    default public String stringVariation(String key, LDUser user, String defaultValue) {
        return this.stringVariation(key, LDContext.fromUser(user), defaultValue);
    }

    public LDValue jsonValueVariation(String var1, LDContext var2, LDValue var3);

    default public LDValue jsonValueVariation(String key, LDUser user, LDValue defaultValue) {
        return this.jsonValueVariation(key, LDContext.fromUser(user), defaultValue);
    }

    public EvaluationDetail<Boolean> boolVariationDetail(String var1, LDContext var2, boolean var3);

    default public EvaluationDetail<Boolean> boolVariationDetail(String key, LDUser user, boolean defaultValue) {
        return this.boolVariationDetail(key, LDContext.fromUser(user), defaultValue);
    }

    public EvaluationDetail<Integer> intVariationDetail(String var1, LDContext var2, int var3);

    default public EvaluationDetail<Integer> intVariationDetail(String key, LDUser user, int defaultValue) {
        return this.intVariationDetail(key, LDContext.fromUser(user), defaultValue);
    }

    public EvaluationDetail<Double> doubleVariationDetail(String var1, LDContext var2, double var3);

    default public EvaluationDetail<Double> doubleVariationDetail(String key, LDUser user, double defaultValue) {
        return this.doubleVariationDetail(key, LDContext.fromUser(user), defaultValue);
    }

    public EvaluationDetail<String> stringVariationDetail(String var1, LDContext var2, String var3);

    default public EvaluationDetail<String> stringVariationDetail(String key, LDUser user, String defaultValue) {
        return this.stringVariationDetail(key, LDContext.fromUser(user), defaultValue);
    }

    public EvaluationDetail<LDValue> jsonValueVariationDetail(String var1, LDContext var2, LDValue var3);

    default public EvaluationDetail<LDValue> jsonValueVariationDetail(String key, LDUser user, LDValue defaultValue) {
        return this.jsonValueVariationDetail(key, LDContext.fromUser(user), defaultValue);
    }

    public boolean isFlagKnown(String var1);

    @Override
    public void close() throws IOException;

    public void flush();

    public boolean isOffline();

    public FlagTracker getFlagTracker();

    public BigSegmentStoreStatusProvider getBigSegmentStoreStatusProvider();

    public DataSourceStatusProvider getDataSourceStatusProvider();

    public DataStoreStatusProvider getDataStoreStatusProvider();

    public String secureModeHash(LDContext var1);

    default public String secureModeHash(LDUser user) {
        return this.secureModeHash(LDContext.fromUser(user));
    }

    public String version();
}

