/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

abstract class Util {
    private Util() {
    }

    static Headers.Builder getHeadersBuilderFor(HttpConfiguration config) {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, String> kv : config.getDefaultHeaders()) {
            builder.add(kv.getKey(), kv.getValue());
        }
        return builder;
    }

    static boolean isAsciiHeaderValue(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch >= ' ' && ch <= '~' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    static void configureHttpClientBuilder(HttpConfiguration config, OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(config.getConnectTimeout()).readTimeout(config.getSocketTimeout()).writeTimeout(config.getSocketTimeout()).retryOnConnectionFailure(false);
        if (config.getSocketFactory() != null) {
            builder.socketFactory(config.getSocketFactory());
        }
        if (config.getSslSocketFactory() != null) {
            builder.sslSocketFactory(config.getSslSocketFactory(), config.getTrustManager());
        }
        if (config.getProxy() != null) {
            builder.proxy(config.getProxy());
            if (config.getProxyAuthentication() != null) {
                builder.proxyAuthenticator(Util.okhttpAuthenticatorFromHttpAuthStrategy(config.getProxyAuthentication(), "Proxy-Authentication", "Proxy-Authorization"));
            }
        }
    }

    static final Authenticator okhttpAuthenticatorFromHttpAuthStrategy(final HttpAuthentication strategy, String challengeHeaderName, final String responseHeaderName) {
        return new Authenticator(){

            @Override
            public Request authenticate(Route route, Response response) throws IOException {
                if (response.request().header(responseHeaderName) != null) {
                    return null;
                }
                Iterable<HttpAuthentication.Challenge> challenges = Iterables.transform(response.challenges(), c -> new HttpAuthentication.Challenge(c.scheme(), c.realm()));
                String credential = strategy.provideAuthorization(challenges);
                return response.request().newBuilder().header(responseHeaderName, credential).build();
            }
        };
    }

    static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static boolean checkIfErrorIsRecoverableAndLog(Logger logger, String errorDesc, String errorContext, int statusCode, String recoverableMessage) {
        if (statusCode > 0 && !Util.isHttpErrorRecoverable(statusCode)) {
            logger.error("Error {} (giving up permanently): {}", (Object)errorContext, (Object)errorDesc);
            return false;
        }
        logger.warn("Error {} ({}): {}", new Object[]{errorContext, recoverableMessage, errorDesc});
        return true;
    }

    static String httpErrorDescription(int statusCode) {
        return "HTTP error " + statusCode + (statusCode == 401 || statusCode == 403 ? " (invalid SDK key)" : "");
    }

    static String describeDuration(Duration d) {
        if (d.toMillis() % 1000L == 0L) {
            if (d.toMillis() % 60000L == 0L) {
                return d.toMinutes() + (d.toMinutes() == 1L ? " minute" : " minutes");
            }
            long sec = d.toMillis() / 1000L;
            return sec + (sec == 1L ? " second" : " seconds");
        }
        return d.toMillis() + " milliseconds";
    }

    static void deleteDirectory(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static URI concatenateUriPath(URI baseUri, String path) {
        String uriStr = baseUri.toString();
        String addPath = path.startsWith("/") ? path.substring(1) : path;
        return URI.create(uriStr + (uriStr.endsWith("/") ? "" : "/") + addPath);
    }
}

