/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.android.ContextIndex;
import com.launchdarkly.sdk.android.EnvironmentData;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.subsystems.PersistentDataStore;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.json.SerializationException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

final class PersistentDataStoreWrapper {
    private static final String GLOBAL_NAMESPACE = "LaunchDarkly";
    private static final String NAMESPACE_PREFIX = "LaunchDarkly_";
    private static final String ANON_CONTEXT_KEY_PREFIX = "anonKey_";
    private static final String ENVIRONMENT_METADATA_KEY = "index";
    private static final String ENVIRONMENT_CONTEXT_DATA_KEY_PREFIX = "flags_";
    private static final String ENVIRONMENT_LAST_SUCCESS_TIME_KEY = "lastSuccessfulConnection";
    private static final String ENVIRONMENT_LAST_FAILURE_TIME_KEY = "lastFailedConnection";
    private static final String ENVIRONMENT_LAST_FAILURE_KEY = "lastFailure";
    private final PersistentDataStore persistentStore;
    private final LDLogger logger;
    private final Object storeLock = new Object();
    private Map<ContextKind, String> generatedKeysCache = new HashMap<ContextKind, String>();
    private final AtomicBoolean loggedStorageError = new AtomicBoolean(false);

    public PersistentDataStoreWrapper(PersistentDataStore persistentStore, LDLogger logger) {
        this.persistentStore = persistentStore;
        this.logger = logger;
    }

    public PerEnvironmentData perEnvironmentData(String mobileKey) {
        return new PerEnvironmentData(mobileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrGenerateContextKey(ContextKind contextKind) {
        Map<ContextKind, String> map = this.generatedKeysCache;
        synchronized (map) {
            String cachedKey = this.generatedKeysCache.get(contextKind);
            if (cachedKey != null) {
                return cachedKey;
            }
            String persistedKey = this.tryGetValue(GLOBAL_NAMESPACE, ANON_CONTEXT_KEY_PREFIX + contextKind.toString());
            if (persistedKey != null) {
                this.generatedKeysCache.put(contextKind, persistedKey);
                return persistedKey;
            }
            String generatedKey = UUID.randomUUID().toString();
            this.generatedKeysCache.put(contextKind, generatedKey);
            this.logger.info("Did not find a generated key for context kind \"{}\". Generating a new one: {}", (Object)contextKind, (Object)generatedKey);
            new Thread(() -> this.trySetValue(GLOBAL_NAMESPACE, ANON_CONTEXT_KEY_PREFIX + contextKind.toString(), generatedKey)).run();
            return generatedKey;
        }
    }

    public void setGeneratedContextKey(ContextKind contextKind, String key) {
        this.trySetValue(GLOBAL_NAMESPACE, ANON_CONTEXT_KEY_PREFIX + contextKind.toString(), key);
    }

    private String keyForContextId(String hashedContextId) {
        return ENVIRONMENT_CONTEXT_DATA_KEY_PREFIX + hashedContextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryGetValue(String namespace, String key) {
        try {
            Object object = this.storeLock;
            synchronized (object) {
                return this.persistentStore.getValue(namespace, key);
            }
        }
        catch (Exception e) {
            this.maybeLogStoreError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetValue(String namespace, String key, String value) {
        try {
            Object object = this.storeLock;
            synchronized (object) {
                this.persistentStore.setValue(namespace, key, value);
            }
        }
        catch (Exception e) {
            this.maybeLogStoreError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetValues(String namespace, Map<String, String> keysAndValues) {
        try {
            Object object = this.storeLock;
            synchronized (object) {
                this.persistentStore.setValues(namespace, keysAndValues);
            }
        }
        catch (Exception e) {
            this.maybeLogStoreError(e);
        }
    }

    private void maybeLogStoreError(Exception e) {
        if (this.loggedStorageError.getAndSet(true)) {
            return;
        }
        LDUtil.logExceptionAtErrorLevel(this.logger, e, "Failure in persistent data store", new Object[0]);
    }

    private Long tryGetValueAsLong(String namespace, String key) {
        String value = this.tryGetValue(namespace, key);
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    final class PerEnvironmentData {
        private final String environmentNamespace;

        PerEnvironmentData(String mobileKey) {
            this.environmentNamespace = PersistentDataStoreWrapper.NAMESPACE_PREFIX + LDUtil.urlSafeBase64Hash(mobileKey);
        }

        public EnvironmentData getContextData(String hashedContextId) {
            String serializedData = PersistentDataStoreWrapper.this.tryGetValue(this.environmentNamespace, PersistentDataStoreWrapper.this.keyForContextId(hashedContextId));
            try {
                return serializedData == null ? null : EnvironmentData.fromJson(serializedData);
            }
            catch (SerializationException e) {
                return null;
            }
        }

        public void setContextData(String hashedContextId, EnvironmentData allData) {
            PersistentDataStoreWrapper.this.trySetValue(this.environmentNamespace, PersistentDataStoreWrapper.this.keyForContextId(hashedContextId), allData.toJson());
        }

        public void removeContextData(String hashedContextId) {
            PersistentDataStoreWrapper.this.trySetValue(this.environmentNamespace, PersistentDataStoreWrapper.this.keyForContextId(hashedContextId), null);
        }

        @NonNull
        public ContextIndex getIndex() {
            String serializedData = PersistentDataStoreWrapper.this.tryGetValue(this.environmentNamespace, PersistentDataStoreWrapper.ENVIRONMENT_METADATA_KEY);
            try {
                return serializedData == null ? new ContextIndex() : ContextIndex.fromJson(serializedData);
            }
            catch (SerializationException e) {
                return null;
            }
        }

        public void setIndex(@NonNull ContextIndex contextIndex) {
            PersistentDataStoreWrapper.this.trySetValue(this.environmentNamespace, PersistentDataStoreWrapper.ENVIRONMENT_METADATA_KEY, contextIndex.toJson());
        }

        @NonNull
        public SavedConnectionInfo getConnectionInfo() {
            Long lastSuccessTime = PersistentDataStoreWrapper.this.tryGetValueAsLong(this.environmentNamespace, PersistentDataStoreWrapper.ENVIRONMENT_LAST_SUCCESS_TIME_KEY);
            Long lastFailureTime = PersistentDataStoreWrapper.this.tryGetValueAsLong(this.environmentNamespace, PersistentDataStoreWrapper.ENVIRONMENT_LAST_FAILURE_TIME_KEY);
            String lastFailureJson = PersistentDataStoreWrapper.this.tryGetValue(this.environmentNamespace, PersistentDataStoreWrapper.ENVIRONMENT_LAST_FAILURE_KEY);
            LDFailure lastFailure = null;
            if (lastFailureJson != null) {
                try {
                    lastFailure = (LDFailure)GsonHelpers.gsonInstance().fromJson(lastFailureJson, LDFailure.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new SavedConnectionInfo(lastSuccessTime, lastFailureTime, lastFailure);
        }

        public void setConnectionInfo(@NonNull SavedConnectionInfo connectionInfo) {
            HashMap<String, String> updates = new HashMap<String, String>();
            updates.put(PersistentDataStoreWrapper.ENVIRONMENT_LAST_SUCCESS_TIME_KEY, connectionInfo.lastSuccessTime == null ? null : String.valueOf(connectionInfo.lastSuccessTime));
            updates.put(PersistentDataStoreWrapper.ENVIRONMENT_LAST_FAILURE_TIME_KEY, connectionInfo.lastFailureTime == null ? null : String.valueOf(connectionInfo.lastFailureTime));
            updates.put(PersistentDataStoreWrapper.ENVIRONMENT_LAST_FAILURE_KEY, connectionInfo.lastFailure == null ? null : GsonHelpers.gsonInstance().toJson((Object)connectionInfo.lastFailure));
            PersistentDataStoreWrapper.this.trySetValues(this.environmentNamespace, updates);
        }
    }

    static class SavedConnectionInfo {
        final Long lastSuccessTime;
        final Long lastFailureTime;
        final LDFailure lastFailure;

        SavedConnectionInfo(Long lastSuccessTime, Long lastFailureTime, LDFailure lastFailure) {
            this.lastSuccessTime = lastSuccessTime;
            this.lastFailureTime = lastFailureTime;
            this.lastFailure = lastFailure;
        }
    }
}

