/*
 * Decompiled with CFR 0.152.
 */
package com.lalongooo;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.lalongooo.Utils;
import com.lalongooo.rings.R;

public class Rings
extends View {
    private static final String TAG = Rings.class.getSimpleName();
    private float defaultTextSize;
    private float defaultTextMarginLeft;
    private float defaultInnerStrokeWidth;
    private float defaultInnerStrokeUnfinishedWidth;
    private float defaultOuterStrokeWidth;
    private float defaultOuterStrokeUnfinishedWidth;
    private int defaultRingUnfinishedColor = -7829368;
    private int defaultRingFilledColor;
    private float defaultRingOverallProgress = 0.0f;
    private float defaultRingInnerThirdProgress = 0.0f;
    private float defaultRingInnerSecondProgress = 0.0f;
    private float defaultRingInnerFirstProgress = 0.0f;
    private String overAllText = "Ring Overall";
    private String innerFirstText = "Ring One";
    private String innerSecondText = "Ring Second";
    private String innerThirdText = "Ring Third";
    private float textSize;
    private float textMarginLeft;
    private float innerStrokeWidth;
    private float innerStrokeWidthUnfinished;
    private float outerStrokeWidth;
    private float outerStrokeWidthUnfinished;
    private int ringOverallColor;
    private int ringInnerThirdColor;
    private int ringInnerSecondColor;
    private int ringInnerFirstColor;
    private int ringUnfinishedColor;
    private float ringOverallProgress;
    private float ringInnerThirdProgress;
    private float ringInnerSecondProgress;
    private float ringInnerFirstProgress;
    private boolean highlighted = false;
    private short highlightedRing = (short)-1;
    private float startAngle = 90.0f;
    private float emptyArcAngle = 270.0f;
    private Paint textPaint;
    private Paint ringPaint;
    private RectF ringOverall;
    private RectF ringInnerThird;
    private RectF ringInnerSecond;
    private RectF ringInnerFirst;
    private Rect rectOverallText;
    private Rect rectInnerThirdText;
    private Rect rectInnerSecondText;
    private Rect rectInnerFirstText;
    private Rect auxRect;
    public static final short RING_OVERALL = 1;
    public static final short THIRD_INNER_RING = 2;
    public static final short SECOND_INNER_RING = 3;
    public static final short FIRST_INNER_RING = 4;
    private boolean areRingsClickable = true;

    public Rings(Context context) {
        this(context, null);
    }

    public Rings(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Rings(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.defaultTextSize = Utils.sp2px(this.getResources(), 18.0f);
        this.defaultTextMarginLeft = Utils.sp2px(this.getResources(), 10.0f);
        this.defaultInnerStrokeWidth = Utils.sp2px(this.getResources(), 8.0f);
        this.defaultInnerStrokeUnfinishedWidth = Utils.sp2px(this.getResources(), 10.0f);
        this.defaultOuterStrokeWidth = Utils.sp2px(this.getResources(), 12.0f);
        this.defaultOuterStrokeUnfinishedWidth = Utils.sp2px(this.getResources(), 12.0f);
        this.defaultRingFilledColor = Color.parseColor((String)"#E6E6E6");
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Rings, defStyle, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        this.ringOverall.set(this.outerStrokeWidth / 2.0f, this.outerStrokeWidth / 2.0f, (float)View.MeasureSpec.getSize((int)widthMeasureSpec) - this.outerStrokeWidth / 2.0f, (float)View.MeasureSpec.getSize((int)heightMeasureSpec) - this.outerStrokeWidth / 2.0f);
        this.ringInnerThird.set(this.ringOverall.left + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringOverall.top + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringOverall.right - (this.outerStrokeWidth + this.innerStrokeWidth), this.ringOverall.bottom - (this.outerStrokeWidth + this.innerStrokeWidth));
        this.ringInnerSecond.set(this.ringInnerThird.left + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerThird.top + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerThird.right - (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerThird.bottom - (this.outerStrokeWidth + this.innerStrokeWidth));
        this.ringInnerFirst.set(this.ringInnerSecond.left + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerSecond.top + (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerSecond.right - (this.outerStrokeWidth + this.innerStrokeWidth), this.ringInnerSecond.bottom - (this.outerStrokeWidth + this.innerStrokeWidth));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.ringPaint.setColor(this.ringUnfinishedColor);
        this.ringPaint.setStrokeWidth(this.outerStrokeWidthUnfinished);
        canvas.drawArc(this.ringOverall, this.startAngle, this.emptyArcAngle, false, this.ringPaint);
        this.ringPaint.setStrokeWidth(this.innerStrokeWidthUnfinished);
        canvas.drawArc(this.ringInnerThird, this.startAngle, this.emptyArcAngle, false, this.ringPaint);
        canvas.drawArc(this.ringInnerSecond, this.startAngle, this.emptyArcAngle, false, this.ringPaint);
        canvas.drawArc(this.ringInnerFirst, this.startAngle, this.emptyArcAngle, false, this.ringPaint);
        this.textPaint.getTextBounds(this.overAllText, 0, this.overAllText.length(), this.auxRect);
        this.rectOverallText.set(this.getWidth() / 2 + (int)this.textMarginLeft, this.getHeight() - (int)this.outerStrokeWidth, this.getWidth() / 2 + this.auxRect.width() + (int)this.textMarginLeft, this.getHeight());
        this.textPaint.getTextBounds(this.innerThirdText, 0, this.innerThirdText.length(), this.auxRect);
        this.rectInnerThirdText.set(this.getWidth() / 2 + (int)this.textMarginLeft, (int)(this.ringInnerThird.bottom - (float)((int)this.textSize)), this.getWidth() / 2 + this.auxRect.width() + (int)this.textMarginLeft, (int)(this.ringInnerThird.bottom + this.innerStrokeWidth));
        this.textPaint.getTextBounds(this.innerSecondText, 0, this.innerSecondText.length(), this.auxRect);
        this.rectInnerSecondText.set(this.getWidth() / 2 + (int)this.textMarginLeft, (int)(this.ringInnerSecond.bottom - (float)((int)this.textSize)), this.getWidth() / 2 + this.auxRect.width() + (int)this.textMarginLeft, (int)(this.ringInnerSecond.bottom + this.innerStrokeWidth));
        this.textPaint.getTextBounds(this.innerFirstText, 0, this.innerFirstText.length(), this.auxRect);
        this.rectInnerFirstText.set(this.getWidth() / 2 + (int)this.textMarginLeft, (int)(this.ringInnerFirst.bottom - (float)((int)this.textSize)), this.getWidth() / 2 + this.auxRect.width() + (int)this.textMarginLeft, (int)(this.ringInnerFirst.bottom + this.innerStrokeWidth));
        if (!this.highlighted) {
            this.textPaint.setColor(this.ringOverallColor);
            canvas.drawText(this.overAllText, (float)this.getWidth() / 2.0f + this.textMarginLeft, (float)this.getHeight(), this.textPaint);
            this.textPaint.setColor(this.ringInnerThirdColor);
            canvas.drawText(this.innerThirdText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerThird.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
            this.textPaint.setColor(this.ringInnerSecondColor);
            canvas.drawText(this.innerSecondText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerSecond.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
            this.textPaint.setColor(this.ringInnerFirstColor);
            canvas.drawText(this.innerFirstText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerFirst.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
            this.ringPaint.setStrokeWidth(this.outerStrokeWidth);
            this.ringPaint.setColor(this.ringOverallColor);
            canvas.drawArc(this.ringOverall, this.startAngle, this.getChartRingOverallProgress(), false, this.ringPaint);
            this.ringPaint.setStrokeWidth(this.innerStrokeWidth);
            this.ringPaint.setColor(this.ringInnerThirdColor);
            canvas.drawArc(this.ringInnerThird, this.startAngle, this.getChartRingSpeedProgress(), false, this.ringPaint);
            this.ringPaint.setColor(this.ringInnerSecondColor);
            canvas.drawArc(this.ringInnerSecond, this.startAngle, this.getChartRingBrakingProgress(), false, this.ringPaint);
            this.ringPaint.setColor(this.ringInnerFirstColor);
            canvas.drawArc(this.ringInnerFirst, this.startAngle, this.getChartRingAccelerationProgress(), false, this.ringPaint);
        } else {
            switch (this.highlightedRing) {
                case 1: {
                    this.textPaint.setColor(this.ringOverallColor);
                    canvas.drawText(this.overAllText, (float)this.getWidth() / 2.0f + this.textMarginLeft, (float)this.getHeight(), this.textPaint);
                    this.textPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawText(this.innerThirdText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerThird.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    canvas.drawText(this.innerSecondText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerSecond.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    canvas.drawText(this.innerFirstText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerFirst.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.ringPaint.setStrokeWidth(this.outerStrokeWidth);
                    this.ringPaint.setColor(this.ringOverallColor);
                    canvas.drawArc(this.ringOverall, this.startAngle, this.getChartRingOverallProgress(), false, this.ringPaint);
                    this.ringPaint.setStrokeWidth(this.innerStrokeWidth);
                    this.ringPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawArc(this.ringInnerThird, this.startAngle, this.getChartRingSpeedProgress(), false, this.ringPaint);
                    canvas.drawArc(this.ringInnerSecond, this.startAngle, this.getChartRingBrakingProgress(), false, this.ringPaint);
                    canvas.drawArc(this.ringInnerFirst, this.startAngle, this.getChartRingAccelerationProgress(), false, this.ringPaint);
                    break;
                }
                case 2: {
                    this.textPaint.setColor(this.ringInnerThirdColor);
                    canvas.drawText(this.innerThirdText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerThird.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.textPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawText(this.overAllText, (float)this.getWidth() / 2.0f + this.textMarginLeft, (float)this.getHeight(), this.textPaint);
                    canvas.drawText(this.innerSecondText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerSecond.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    canvas.drawText(this.innerFirstText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerFirst.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.ringPaint.setStrokeWidth(this.innerStrokeWidth);
                    this.ringPaint.setColor(this.ringInnerThirdColor);
                    canvas.drawArc(this.ringInnerThird, this.startAngle, this.getChartRingSpeedProgress(), false, this.ringPaint);
                    this.ringPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawArc(this.ringInnerSecond, this.startAngle, this.getChartRingBrakingProgress(), false, this.ringPaint);
                    canvas.drawArc(this.ringInnerFirst, this.startAngle, this.getChartRingAccelerationProgress(), false, this.ringPaint);
                    this.ringPaint.setStrokeWidth(this.outerStrokeWidth);
                    canvas.drawArc(this.ringOverall, this.startAngle, this.getChartRingOverallProgress(), false, this.ringPaint);
                    break;
                }
                case 3: {
                    this.textPaint.setColor(this.ringInnerSecondColor);
                    canvas.drawText(this.innerSecondText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerSecond.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.textPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawText(this.overAllText, (float)this.getWidth() / 2.0f + this.textMarginLeft, (float)this.getHeight(), this.textPaint);
                    canvas.drawText(this.innerThirdText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerThird.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    canvas.drawText(this.innerFirstText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerFirst.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.ringPaint.setStrokeWidth(this.innerStrokeWidth);
                    this.ringPaint.setColor(this.ringInnerSecondColor);
                    canvas.drawArc(this.ringInnerSecond, this.startAngle, this.getChartRingBrakingProgress(), false, this.ringPaint);
                    this.ringPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawArc(this.ringInnerThird, this.startAngle, this.getChartRingSpeedProgress(), false, this.ringPaint);
                    canvas.drawArc(this.ringInnerFirst, this.startAngle, this.getChartRingAccelerationProgress(), false, this.ringPaint);
                    this.ringPaint.setStrokeWidth(this.outerStrokeWidth);
                    canvas.drawArc(this.ringOverall, this.startAngle, this.getChartRingOverallProgress(), false, this.ringPaint);
                    break;
                }
                case 4: {
                    this.textPaint.setColor(this.ringInnerFirstColor);
                    canvas.drawText(this.innerFirstText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerFirst.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.textPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawText(this.overAllText, (float)this.getWidth() / 2.0f + this.textMarginLeft, (float)this.getHeight(), this.textPaint);
                    canvas.drawText(this.innerThirdText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerThird.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    canvas.drawText(this.innerSecondText, (float)this.getWidth() / 2.0f + this.textMarginLeft, this.ringInnerSecond.bottom + this.innerStrokeWidth / 2.0f, this.textPaint);
                    this.ringPaint.setStrokeWidth(this.innerStrokeWidth);
                    this.ringPaint.setColor(this.ringInnerFirstColor);
                    canvas.drawArc(this.ringInnerFirst, this.startAngle, this.getChartRingAccelerationProgress(), false, this.ringPaint);
                    this.ringPaint.setColor(this.defaultRingFilledColor);
                    canvas.drawArc(this.ringInnerThird, this.startAngle, this.getChartRingSpeedProgress(), false, this.ringPaint);
                    canvas.drawArc(this.ringInnerSecond, this.startAngle, this.getChartRingBrakingProgress(), false, this.ringPaint);
                    this.ringPaint.setStrokeWidth(this.outerStrokeWidth);
                    canvas.drawArc(this.ringOverall, this.startAngle, this.getChartRingOverallProgress(), false, this.ringPaint);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Use one of the constants provided to highlight a ring: FIRST_INNER_RING, SECOND_INNER_RING, THIRD_INNER_RING or RING_OVERALL");
                }
            }
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getRingsClickable()) {
            switch (event.getAction()) {
                case 1: {
                    if (Rings.isOnRing(event, this.ringOverall, this.outerStrokeWidth) && Rings.isInSweep(event, this.ringOverall, this.startAngle, this.emptyArcAngle) || this.rectOverallText.contains((int)event.getX(), (int)event.getY())) {
                        this.highlight((short)1);
                    }
                    if (Rings.isOnRing(event, this.ringInnerThird, this.outerStrokeWidth) && Rings.isInSweep(event, this.ringInnerThird, this.startAngle, this.emptyArcAngle) || this.rectInnerThirdText.contains((int)event.getX(), (int)event.getY())) {
                        this.highlight((short)2);
                    }
                    if (Rings.isOnRing(event, this.ringInnerSecond, this.outerStrokeWidth) && Rings.isInSweep(event, this.ringInnerSecond, this.startAngle, this.emptyArcAngle) || this.rectInnerSecondText.contains((int)event.getX(), (int)event.getY())) {
                        this.highlight((short)3);
                    }
                    if ((!Rings.isOnRing(event, this.ringInnerFirst, this.outerStrokeWidth) || !Rings.isInSweep(event, this.ringInnerFirst, this.startAngle, this.emptyArcAngle)) && !this.rectInnerFirstText.contains((int)event.getX(), (int)event.getY())) break;
                    this.highlight((short)4);
                }
            }
            return true;
        }
        return false;
    }

    private void initByAttributes(TypedArray attributes) {
        this.textSize = attributes.getDimension(R.styleable.Rings_rings_text_size, this.defaultTextSize);
        this.textMarginLeft = attributes.getDimension(R.styleable.Rings_rings_text_margin_left, this.defaultTextMarginLeft);
        this.innerStrokeWidth = attributes.getDimension(R.styleable.Rings_rings_inner_stroke_width, this.defaultInnerStrokeWidth);
        this.innerStrokeWidthUnfinished = attributes.getDimension(R.styleable.Rings_rings_inner_stroke_width_unfinished, this.defaultInnerStrokeUnfinishedWidth);
        this.outerStrokeWidth = attributes.getDimension(R.styleable.Rings_rings_outer_stroke_width, this.defaultOuterStrokeWidth);
        this.outerStrokeWidthUnfinished = attributes.getDimension(R.styleable.Rings_rings_outer_stroke_width_unfinished, this.defaultOuterStrokeUnfinishedWidth);
        this.ringUnfinishedColor = attributes.getColor(R.styleable.Rings_rings_unfinished_color, this.defaultRingUnfinishedColor);
        this.defaultRingFilledColor = attributes.getColor(R.styleable.Rings_rings_default_filled_color, this.defaultRingFilledColor);
        this.ringOverallColor = attributes.getColor(R.styleable.Rings_rings_overall_color, this.defaultRingFilledColor);
        this.ringInnerThirdColor = attributes.getColor(R.styleable.Rings_rings_inner_third_color, this.defaultRingFilledColor);
        this.ringInnerSecondColor = attributes.getColor(R.styleable.Rings_rings_inner_second_color, this.defaultRingFilledColor);
        this.ringInnerFirstColor = attributes.getColor(R.styleable.Rings_rings_inner_first_color, this.defaultRingFilledColor);
        this.overAllText = attributes.getString(R.styleable.Rings_rings_overall_text);
        this.innerFirstText = attributes.getString(R.styleable.Rings_rings_inner_first_text);
        this.innerSecondText = attributes.getString(R.styleable.Rings_rings_inner_second_text);
        this.innerThirdText = attributes.getString(R.styleable.Rings_rings_inner_third_text);
        this.setRingOverallProgress(attributes.getFloat(R.styleable.Rings_rings_overall_progress, this.defaultRingOverallProgress));
        this.setRingInnerThirdProgress(attributes.getFloat(R.styleable.Rings_rings_inner_third_progress, this.defaultRingInnerThirdProgress));
        this.setRingInnerSecondProgress(attributes.getFloat(R.styleable.Rings_rings_inner_second_progress, this.defaultRingInnerSecondProgress));
        this.setRingInnerFirstProgress(attributes.getFloat(R.styleable.Rings_rings_inner_first_progress, this.defaultRingInnerFirstProgress));
    }

    private void initPainters() {
        this.ringOverall = new RectF();
        this.ringInnerThird = new RectF();
        this.ringInnerSecond = new RectF();
        this.ringInnerFirst = new RectF();
        this.rectOverallText = new Rect();
        this.rectInnerThirdText = new Rect();
        this.rectInnerSecondText = new Rect();
        this.rectInnerFirstText = new Rect();
        this.auxRect = new Rect();
        this.ringPaint = new Paint();
        this.ringPaint.setAntiAlias(true);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.ringPaint.setStrokeCap(Paint.Cap.ROUND);
        this.textPaint = new TextPaint();
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
    }

    private static boolean isOnRing(MotionEvent event, RectF bounds, float strokeWidth) {
        float distance = Rings.distance(event.getX(), event.getY(), bounds.centerX(), bounds.centerY());
        float radius = bounds.width() / 2.0f;
        float halfStrokeWidth = strokeWidth / 2.0f;
        return Math.abs(distance - radius) <= halfStrokeWidth;
    }

    private static float distance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    private static boolean isInSweep(MotionEvent event, RectF bounds, float startAngle, float sweepAngle) {
        float at = (float)Math.toDegrees(Math.atan2(event.getY() - bounds.centerY(), event.getX() - bounds.centerX()));
        float angle = (at + 360.0f) % 360.0f;
        return angle >= startAngle && angle <= startAngle + sweepAngle;
    }

    public void highlight(short ring) {
        this.highlighted = true;
        this.highlightedRing = ring;
        this.invalidate();
    }

    public void unhighlight() {
        this.highlighted = false;
        this.highlightedRing = (short)-1;
        this.invalidate();
    }

    public short getHighlightedRing() {
        return this.highlightedRing;
    }

    public float getChartRingOverallProgress() {
        return this.ringOverallProgress;
    }

    public void setRingOverallProgress(float overAllProgress) {
        this.ringOverallProgress = this.emptyArcAngle / 100.0f * overAllProgress;
        this.invalidate();
    }

    public float getChartRingSpeedProgress() {
        return this.ringInnerThirdProgress;
    }

    public void setRingInnerThirdProgress(float innerThirdProgress) {
        this.ringInnerThirdProgress = this.emptyArcAngle / 100.0f * innerThirdProgress;
        this.invalidate();
    }

    public float getChartRingBrakingProgress() {
        return this.ringInnerSecondProgress;
    }

    public void setRingInnerSecondProgress(float innerSecondProgress) {
        this.ringInnerSecondProgress = this.emptyArcAngle / 100.0f * innerSecondProgress;
        this.invalidate();
    }

    public float getChartRingAccelerationProgress() {
        return this.ringInnerFirstProgress;
    }

    public void setRingInnerFirstProgress(float innerFirstProgress) {
        this.ringInnerFirstProgress = this.emptyArcAngle / 100.0f * innerFirstProgress;
        this.invalidate();
    }

    public void setRingsClickable(boolean areRingsClickable) {
        this.areRingsClickable = areRingsClickable;
    }

    public boolean getRingsClickable() {
        return this.areRingsClickable;
    }
}

