/*
 * Copyright (c) 2018-present, Wiltgen Philippe
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.kyoapps.zkotlinextensions.extensions

import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.os.Build
import android.os.VibrationEffect
import android.os.Vibrator

fun String.copyToClipboard(context: Context?, label: String = "") {
    (context?.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager?)?.also {
        it.setPrimaryClip(ClipData.newPlainText(label, this))
    }
}

fun Context?.vibrate(durationMs: Long = 80, amplitude: Int = 80) {
    (this?.getSystemService(Context.VIBRATOR_SERVICE) as Vibrator?)?.apply {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            vibrate(VibrationEffect.createOneShot(durationMs, amplitude))
        } else vibrate(80)
    }
}
