/*
 * Decompiled with CFR 0.152.
 */
package com.kymjs.okhttp;

import com.kymjs.rxvolley.http.Request;
import com.kymjs.rxvolley.http.URLHttpResponse;
import com.kymjs.rxvolley.interf.IHttpStack;
import com.kymjs.rxvolley.toolbox.HttpParamsEntry;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class OkHttpStack
implements IHttpStack {
    private final OkHttpClient mClient;

    public OkHttpStack(OkHttpClient client) {
        this.mClient = client;
    }

    public URLHttpResponse performRequest(Request<?> request, ArrayList<HttpParamsEntry> additionalHeaders) throws IOException {
        OkHttpClient client = this.mClient.clone();
        int timeoutMs = request.getTimeoutMs();
        client.setConnectTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        client.setReadTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        client.setWriteTimeout((long)timeoutMs, TimeUnit.MILLISECONDS);
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        okHttpRequestBuilder.url(request.getUrl());
        for (HttpParamsEntry entry : request.getHeaders()) {
            okHttpRequestBuilder.addHeader(entry.k, entry.v);
        }
        for (HttpParamsEntry entry : additionalHeaders) {
            okHttpRequestBuilder.addHeader(entry.k, entry.v);
        }
        OkHttpStack.setConnectionParametersForRequest(okHttpRequestBuilder, request);
        com.squareup.okhttp.Request okHttpRequest = okHttpRequestBuilder.build();
        Call okHttpCall = client.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        return this.responseFromConnection(okHttpResponse);
    }

    private URLHttpResponse responseFromConnection(Response okHttpResponse) throws IOException {
        URLHttpResponse response = new URLHttpResponse();
        int responseCode = okHttpResponse.code();
        if (responseCode == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        response.setResponseCode(responseCode);
        response.setResponseMessage(okHttpResponse.message());
        response.setContentStream(okHttpResponse.body().byteStream());
        response.setContentLength(okHttpResponse.body().contentLength());
        response.setContentEncoding(okHttpResponse.header("Content-Encoding"));
        if (okHttpResponse.body().contentType() != null) {
            response.setContentType(okHttpResponse.body().contentType().type());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Headers responseHeaders = okHttpResponse.headers();
        int len = responseHeaders.size();
        for (int i = 0; i < len; ++i) {
            String name = responseHeaders.name(i);
            String value = responseHeaders.value(i);
            if (name == null) continue;
            headerMap.put(name, value);
        }
        response.setHeaders(headerMap);
        return response;
    }

    private static void setConnectionParametersForRequest(Request.Builder builder, Request<?> request) throws IOException {
        switch (request.getMethod()) {
            case 0: {
                builder.get();
                break;
            }
            case 3: {
                builder.delete();
                break;
            }
            case 1: {
                builder.post(OkHttpStack.createRequestBody(request));
                break;
            }
            case 2: {
                builder.put(OkHttpStack.createRequestBody(request));
                break;
            }
            case 4: {
                builder.head();
                break;
            }
            case 5: {
                builder.method("OPTIONS", null);
                break;
            }
            case 6: {
                builder.method("TRACE", null);
                break;
            }
            case 7: {
                builder.patch(OkHttpStack.createRequestBody(request));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static RequestBody createRequestBody(Request r) {
        byte[] body = r.getBody();
        if (body == null) {
            return null;
        }
        return RequestBody.create((MediaType)MediaType.parse((String)r.getBodyContentType()), (byte[])body);
    }
}

