/*
 * Decompiled with CFR 0.152.
 */
package com.kyleduo.switchbutton;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.CompoundButton;
import com.kyleduo.switchbutton.ColorUtils;
import com.kyleduo.switchbutton.R;

public class SwitchButton
extends CompoundButton {
    public static final float DEFAULT_BACK_MEASURE_RATIO = 1.8f;
    public static final int DEFAULT_THUMB_SIZE_DP = 20;
    public static final int DEFAULT_THUMB_MARGIN_DP = 2;
    public static final int DEFAULT_TEXT_MARGIN_DP = 2;
    public static final int DEFAULT_ANIMATION_DURATION = 250;
    public static final int DEFAULT_TINT_COLOR = 3309506;
    private static int[] CHECKED_PRESSED_STATE = new int[]{0x10100A0, 16842910, 16842919};
    private static int[] UNCHECKED_PRESSED_STATE = new int[]{-16842912, 16842910, 16842919};
    private Drawable mThumbDrawable;
    private Drawable mBackDrawable;
    private ColorStateList mBackColor;
    private ColorStateList mThumbColor;
    private float mThumbRadius;
    private float mBackRadius;
    private RectF mThumbMargin;
    private float mBackMeasureRatio;
    private long mAnimationDuration;
    private boolean mFadeBack;
    private int mTintColor;
    private PointF mThumbSizeF;
    private int mCurrThumbColor;
    private int mCurrBackColor;
    private int mNextBackColor;
    private int mOnTextColor;
    private int mOffTextColor;
    private Drawable mCurrentBackDrawable;
    private Drawable mNextBackDrawable;
    private RectF mThumbRectF;
    private RectF mBackRectF;
    private RectF mSafeRectF;
    private RectF mTextOnRectF;
    private RectF mTextOffRectF;
    private Paint mPaint;
    private boolean mIsThumbUseDrawable;
    private boolean mIsBackUseDrawable;
    private boolean mDrawDebugRect = false;
    private ObjectAnimator mProcessAnimator;
    private float mProcess;
    private RectF mPresentThumbRectF;
    private float mStartX;
    private float mStartY;
    private float mLastX;
    private int mTouchSlop;
    private int mClickTimeout;
    private Paint mRectPaint;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private TextPaint mTextPaint;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private float mTextWidth;
    private float mTextHeight;
    private float mTextMarginH;

    public SwitchButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public SwitchButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public SwitchButton(Context context) {
        super(context);
        this.init(null);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta;
        float thumbRadius;
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mClickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
        this.mPaint = new Paint(1);
        this.mRectPaint = new Paint(1);
        this.mRectPaint.setStyle(Paint.Style.STROKE);
        this.mRectPaint.setStrokeWidth(this.getResources().getDisplayMetrics().density);
        this.mTextPaint = this.getPaint();
        this.mThumbRectF = new RectF();
        this.mBackRectF = new RectF();
        this.mSafeRectF = new RectF();
        this.mThumbSizeF = new PointF();
        this.mThumbMargin = new RectF();
        this.mTextOnRectF = new RectF();
        this.mTextOffRectF = new RectF();
        this.mProcessAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"process", (float[])new float[]{0.0f, 0.0f}).setDuration(250L);
        this.mProcessAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mPresentThumbRectF = new RectF();
        Resources res = this.getResources();
        float density = res.getDisplayMetrics().density;
        Drawable thumbDrawable = null;
        ColorStateList thumbColor = null;
        float margin = density * 2.0f;
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float marginTop = 0.0f;
        float marginBottom = 0.0f;
        float thumbWidth = density * 20.0f;
        float thumbHeight = density * 20.0f;
        float backRadius = thumbRadius = density * 20.0f / 2.0f;
        Drawable backDrawable = null;
        ColorStateList backColor = null;
        float backMeasureRatio = 1.8f;
        int animationDuration = 250;
        boolean fadeBack = true;
        int tintColor = Integer.MIN_VALUE;
        String textOn = null;
        String textOff = null;
        float textMarginH = density * 2.0f;
        TypedArray typedArray = ta = attrs == null ? null : this.getContext().obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        if (ta != null) {
            thumbDrawable = ta.getDrawable(R.styleable.SwitchButton_kswThumbDrawable);
            thumbColor = ta.getColorStateList(R.styleable.SwitchButton_kswThumbColor);
            margin = ta.getDimension(R.styleable.SwitchButton_kswThumbMargin, margin);
            marginLeft = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginLeft, margin);
            marginRight = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginRight, margin);
            marginTop = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginTop, margin);
            marginBottom = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginBottom, margin);
            thumbWidth = ta.getDimension(R.styleable.SwitchButton_kswThumbWidth, thumbWidth);
            thumbHeight = ta.getDimension(R.styleable.SwitchButton_kswThumbHeight, thumbHeight);
            thumbRadius = ta.getDimension(R.styleable.SwitchButton_kswThumbRadius, Math.min(thumbWidth, thumbHeight) / 2.0f);
            backRadius = ta.getDimension(R.styleable.SwitchButton_kswBackRadius, thumbRadius + density * 2.0f);
            backDrawable = ta.getDrawable(R.styleable.SwitchButton_kswBackDrawable);
            backColor = ta.getColorStateList(R.styleable.SwitchButton_kswBackColor);
            backMeasureRatio = ta.getFloat(R.styleable.SwitchButton_kswBackMeasureRatio, backMeasureRatio);
            animationDuration = ta.getInteger(R.styleable.SwitchButton_kswAnimationDuration, animationDuration);
            fadeBack = ta.getBoolean(R.styleable.SwitchButton_kswFadeBack, true);
            tintColor = ta.getColor(R.styleable.SwitchButton_kswTintColor, tintColor);
            textOn = ta.getString(R.styleable.SwitchButton_kswTextOn);
            textOff = ta.getString(R.styleable.SwitchButton_kswTextOff);
            textMarginH = ta.getDimension(R.styleable.SwitchButton_kswTextMarginH, textMarginH);
            ta.recycle();
        }
        this.mTextOn = textOn;
        this.mTextOff = textOff;
        this.mTextMarginH = textMarginH;
        this.mThumbDrawable = thumbDrawable;
        this.mThumbColor = thumbColor;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.mTintColor = tintColor;
        if (this.mTintColor == Integer.MIN_VALUE) {
            this.mTintColor = 3309506;
        }
        if (!this.mIsThumbUseDrawable && this.mThumbColor == null) {
            this.mThumbColor = ColorUtils.generateThumbColorWithTintColor(this.mTintColor);
            this.mCurrThumbColor = this.mThumbColor.getDefaultColor();
        }
        if (this.mIsThumbUseDrawable) {
            thumbWidth = Math.max(thumbWidth, (float)this.mThumbDrawable.getMinimumWidth());
            thumbHeight = Math.max(thumbHeight, (float)this.mThumbDrawable.getMinimumHeight());
        }
        this.mThumbSizeF.set(thumbWidth, thumbHeight);
        this.mBackDrawable = backDrawable;
        this.mBackColor = backColor;
        boolean bl = this.mIsBackUseDrawable = this.mBackDrawable != null;
        if (!this.mIsBackUseDrawable && this.mBackColor == null) {
            this.mBackColor = ColorUtils.generateBackColorWithTintColor(this.mTintColor);
            this.mCurrBackColor = this.mBackColor.getDefaultColor();
            this.mNextBackColor = this.mBackColor.getColorForState(CHECKED_PRESSED_STATE, this.mCurrBackColor);
        }
        this.mThumbMargin.set(marginLeft, marginTop, marginRight, marginBottom);
        this.mBackMeasureRatio = this.mThumbMargin.width() >= 0.0f ? Math.max(backMeasureRatio, 1.0f) : backMeasureRatio;
        this.mThumbRadius = thumbRadius;
        this.mBackRadius = backRadius;
        this.mAnimationDuration = animationDuration;
        this.mFadeBack = fadeBack;
        this.mProcessAnimator.setDuration(this.mAnimationDuration);
        this.setFocusable(true);
        this.setClickable(true);
        if (this.isChecked()) {
            this.setProcess(1.0f);
        }
    }

    private Layout makeLayout(CharSequence text) {
        return new StaticLayout(text, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)text, (TextPaint)this.mTextPaint)), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOnLayout == null && this.mTextOn != null) {
            this.mOnLayout = this.makeLayout(this.mTextOn);
        }
        if (this.mOffLayout == null && this.mTextOff != null) {
            this.mOffLayout = this.makeLayout(this.mTextOff);
        }
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int measuredWidth;
        float offWidth;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int minWidth = (int)(this.mThumbSizeF.x * this.mBackMeasureRatio);
        if (this.mIsBackUseDrawable) {
            minWidth = Math.max(minWidth, this.mBackDrawable.getMinimumWidth());
        }
        float onWidth = this.mOnLayout != null ? (float)this.mOnLayout.getWidth() : 0.0f;
        float f = offWidth = this.mOffLayout != null ? (float)this.mOffLayout.getWidth() : 0.0f;
        if (onWidth != 0.0f || offWidth != 0.0f) {
            this.mTextWidth = Math.max(onWidth, offWidth) + this.mTextMarginH * 2.0f;
            float left = (float)minWidth - this.mThumbSizeF.x;
            if (left < this.mTextWidth) {
                minWidth = (int)((float)minWidth + (this.mTextWidth - left));
            }
        }
        minWidth = Math.max(minWidth, (int)((float)minWidth + this.mThumbMargin.left + this.mThumbMargin.right));
        minWidth = Math.max(minWidth, minWidth + this.getPaddingLeft() + this.getPaddingRight());
        minWidth = Math.max(minWidth, this.getSuggestedMinimumWidth());
        if (widthMode == 0x40000000) {
            measuredWidth = Math.max(minWidth, widthSize);
        } else {
            measuredWidth = minWidth;
            if (widthMode == Integer.MIN_VALUE) {
                measuredWidth = Math.min(measuredWidth, widthSize);
            }
        }
        return measuredWidth;
    }

    private int measureHeight(int heightMeasureSpec) {
        int measuredHeight;
        float offHeight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int minHeight = (int)Math.max(this.mThumbSizeF.y, this.mThumbSizeF.y + this.mThumbMargin.top + this.mThumbMargin.right);
        float onHeight = this.mOnLayout != null ? (float)this.mOnLayout.getHeight() : 0.0f;
        float f = offHeight = this.mOffLayout != null ? (float)this.mOffLayout.getHeight() : 0.0f;
        if (onHeight != 0.0f || offHeight != 0.0f) {
            this.mTextHeight = Math.max(onHeight, offHeight);
            minHeight = (int)Math.max((float)minHeight, this.mTextHeight);
        }
        minHeight = Math.max(minHeight, this.getSuggestedMinimumHeight());
        minHeight = Math.max(minHeight, minHeight + this.getPaddingTop() + this.getPaddingBottom());
        if (heightMode == 0x40000000) {
            measuredHeight = Math.max(minHeight, heightSize);
        } else {
            measuredHeight = minHeight;
            if (heightMode == Integer.MIN_VALUE) {
                measuredHeight = Math.min(measuredHeight, heightSize);
            }
        }
        return measuredHeight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.setup();
        }
    }

    private void setup() {
        float thumbTop = (float)this.getPaddingTop() + Math.max(0.0f, this.mThumbMargin.top);
        float thumbLeft = (float)this.getPaddingLeft() + Math.max(0.0f, this.mThumbMargin.left);
        if (this.mOnLayout != null && this.mOffLayout != null && this.mThumbMargin.top + this.mThumbMargin.bottom > 0.0f) {
            float addition = ((float)(this.getMeasuredHeight() - this.getPaddingBottom() - this.getPaddingTop()) - this.mThumbSizeF.y - this.mThumbMargin.top - this.mThumbMargin.bottom) / 2.0f;
            thumbTop += addition;
        }
        if (this.mIsThumbUseDrawable) {
            this.mThumbSizeF.x = Math.max(this.mThumbSizeF.x, (float)this.mThumbDrawable.getMinimumWidth());
            this.mThumbSizeF.y = Math.max(this.mThumbSizeF.y, (float)this.mThumbDrawable.getMinimumHeight());
        }
        this.mThumbRectF.set(thumbLeft, thumbTop, thumbLeft + this.mThumbSizeF.x, thumbTop + this.mThumbSizeF.y);
        float backLeft = this.mThumbRectF.left - this.mThumbMargin.left;
        float textDiffWidth = Math.min(0.0f, (Math.max(this.mThumbSizeF.x * this.mBackMeasureRatio, this.mThumbSizeF.x + this.mTextWidth) - this.mThumbRectF.width() - this.mTextWidth) / 2.0f);
        float textDiffHeight = Math.min(0.0f, (this.mThumbRectF.height() + this.mThumbMargin.top + this.mThumbMargin.bottom - this.mTextHeight) / 2.0f);
        this.mBackRectF.set(backLeft + textDiffWidth, this.mThumbRectF.top - this.mThumbMargin.top + textDiffHeight, backLeft + this.mThumbMargin.left + Math.max(this.mThumbSizeF.x * this.mBackMeasureRatio, this.mThumbSizeF.x + this.mTextWidth) + this.mThumbMargin.right - textDiffWidth, this.mThumbRectF.bottom + this.mThumbMargin.bottom - textDiffHeight);
        this.mSafeRectF.set(this.mThumbRectF.left, 0.0f, this.mBackRectF.right - this.mThumbMargin.right - this.mThumbRectF.width(), 0.0f);
        float minBackRadius = Math.min(this.mBackRectF.width(), this.mBackRectF.height()) / 2.0f;
        this.mBackRadius = Math.min(minBackRadius, this.mBackRadius);
        if (this.mBackDrawable != null) {
            this.mBackDrawable.setBounds((int)this.mBackRectF.left, (int)this.mBackRectF.top, (int)this.mBackRectF.right, (int)this.mBackRectF.bottom);
        }
        if (this.mOnLayout != null) {
            float marginOnX = this.mBackRectF.left + (this.mBackRectF.width() - this.mThumbRectF.width() - (float)this.mOnLayout.getWidth()) / 2.0f - this.mThumbMargin.left + this.mTextMarginH * (float)(this.mThumbMargin.left > 0.0f ? 1 : -1);
            float marginOnY = this.mBackRectF.top + (this.mBackRectF.height() - (float)this.mOnLayout.getHeight()) / 2.0f;
            this.mTextOnRectF.set(marginOnX, marginOnY, marginOnX + (float)this.mOnLayout.getWidth(), marginOnY + (float)this.mOnLayout.getHeight());
        }
        if (this.mOffLayout != null) {
            float marginOffX = this.mBackRectF.right - (this.mBackRectF.width() - this.mThumbRectF.width() - (float)this.mOffLayout.getWidth()) / 2.0f + this.mThumbMargin.right - (float)this.mOffLayout.getWidth() - this.mTextMarginH * (float)(this.mThumbMargin.right > 0.0f ? 1 : -1);
            float marginOffY = this.mBackRectF.top + (this.mBackRectF.height() - (float)this.mOffLayout.getHeight()) / 2.0f;
            this.mTextOffRectF.set(marginOffX, marginOffY, marginOffX + (float)this.mOffLayout.getWidth(), marginOffY + (float)this.mOffLayout.getHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        RectF textRectF;
        int alpha;
        super.onDraw(canvas);
        if (this.mIsBackUseDrawable) {
            if (this.mFadeBack && this.mCurrentBackDrawable != null && this.mNextBackDrawable != null) {
                alpha = (int)(255.0f * (this.isChecked() ? this.getProcess() : 1.0f - this.getProcess()));
                this.mCurrentBackDrawable.setAlpha(alpha);
                this.mCurrentBackDrawable.draw(canvas);
                alpha = 255 - alpha;
                this.mNextBackDrawable.setAlpha(alpha);
                this.mNextBackDrawable.draw(canvas);
            } else {
                this.mBackDrawable.setAlpha(255);
                this.mBackDrawable.draw(canvas);
            }
        } else if (this.mFadeBack) {
            alpha = (int)(255.0f * (this.isChecked() ? this.getProcess() : 1.0f - this.getProcess()));
            int colorAlpha = Color.alpha((int)this.mCurrBackColor);
            colorAlpha = colorAlpha * alpha / 255;
            this.mPaint.setARGB(colorAlpha, Color.red((int)this.mCurrBackColor), Color.green((int)this.mCurrBackColor), Color.blue((int)this.mCurrBackColor));
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
            alpha = 255 - alpha;
            colorAlpha = Color.alpha((int)this.mNextBackColor);
            colorAlpha = colorAlpha * alpha / 255;
            this.mPaint.setARGB(colorAlpha, Color.red((int)this.mNextBackColor), Color.green((int)this.mNextBackColor), Color.blue((int)this.mNextBackColor));
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
            this.mPaint.setAlpha(255);
        } else {
            this.mPaint.setColor(this.mCurrBackColor);
            canvas.drawRoundRect(this.mBackRectF, this.mBackRadius, this.mBackRadius, this.mPaint);
        }
        Layout switchText = (double)this.getProcess() > 0.5 ? this.mOnLayout : this.mOffLayout;
        RectF rectF = textRectF = (double)this.getProcess() > 0.5 ? this.mTextOnRectF : this.mTextOffRectF;
        if (switchText != null && textRectF != null) {
            int alpha2 = (int)(255.0f * ((double)this.getProcess() >= 0.75 ? this.getProcess() * 4.0f - 3.0f : ((double)this.getProcess() < 0.25 ? 1.0f - this.getProcess() * 4.0f : 0.0f)));
            int textColor = (double)this.getProcess() > 0.5 ? this.mOnTextColor : this.mOffTextColor;
            int colorAlpha = Color.alpha((int)textColor);
            colorAlpha = colorAlpha * alpha2 / 255;
            switchText.getPaint().setARGB(colorAlpha, Color.red((int)textColor), Color.green((int)textColor), Color.blue((int)textColor));
            canvas.save();
            canvas.translate(textRectF.left, textRectF.top);
            switchText.draw(canvas);
            canvas.restore();
        }
        this.mPresentThumbRectF.set(this.mThumbRectF);
        this.mPresentThumbRectF.offset(this.mProcess * this.mSafeRectF.width(), 0.0f);
        if (this.mIsThumbUseDrawable) {
            this.mThumbDrawable.setBounds((int)this.mPresentThumbRectF.left, (int)this.mPresentThumbRectF.top, (int)this.mPresentThumbRectF.right, (int)this.mPresentThumbRectF.bottom);
            this.mThumbDrawable.draw(canvas);
        } else {
            this.mPaint.setColor(this.mCurrThumbColor);
            canvas.drawRoundRect(this.mPresentThumbRectF, this.mThumbRadius, this.mThumbRadius, this.mPaint);
        }
        if (this.mDrawDebugRect) {
            this.mRectPaint.setColor(Color.parseColor((String)"#AA0000"));
            canvas.drawRect(this.mBackRectF, this.mRectPaint);
            this.mRectPaint.setColor(Color.parseColor((String)"#0000FF"));
            canvas.drawRect(this.mPresentThumbRectF, this.mRectPaint);
            this.mRectPaint.setColor(Color.parseColor((String)"#00CC00"));
            canvas.drawRect((double)this.getProcess() > 0.5 ? this.mTextOnRectF : this.mTextOffRectF, this.mRectPaint);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (!this.mIsThumbUseDrawable && this.mThumbColor != null) {
            this.mCurrThumbColor = this.mThumbColor.getColorForState(this.getDrawableState(), this.mCurrThumbColor);
        } else {
            this.setDrawableState(this.mThumbDrawable);
        }
        int[] nextState = this.isChecked() ? UNCHECKED_PRESSED_STATE : CHECKED_PRESSED_STATE;
        ColorStateList textColors = this.getTextColors();
        if (textColors != null) {
            int defaultTextColor = textColors.getDefaultColor();
            this.mOnTextColor = textColors.getColorForState(CHECKED_PRESSED_STATE, defaultTextColor);
            this.mOffTextColor = textColors.getColorForState(UNCHECKED_PRESSED_STATE, defaultTextColor);
        }
        if (!this.mIsBackUseDrawable && this.mBackColor != null) {
            this.mCurrBackColor = this.mBackColor.getColorForState(this.getDrawableState(), this.mCurrBackColor);
            this.mNextBackColor = this.mBackColor.getColorForState(nextState, this.mCurrBackColor);
        } else {
            if (this.mBackDrawable instanceof StateListDrawable && this.mFadeBack) {
                this.mBackDrawable.setState(nextState);
                this.mNextBackDrawable = this.mBackDrawable.getCurrent().mutate();
            } else {
                this.mNextBackDrawable = null;
            }
            this.setDrawableState(this.mBackDrawable);
            if (this.mBackDrawable != null) {
                this.mCurrentBackDrawable = this.mBackDrawable.getCurrent().mutate();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        int action = event.getAction();
        float deltaX = event.getX() - this.mStartX;
        float deltaY = event.getY() - this.mStartY;
        switch (action) {
            case 0: {
                this.catchView();
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mLastX = this.mStartX;
                this.setPressed(true);
                break;
            }
            case 2: {
                float x = event.getX();
                this.setProcess(this.getProcess() + (x - this.mLastX) / this.mSafeRectF.width());
                this.mLastX = x;
                break;
            }
            case 1: 
            case 3: {
                this.setPressed(false);
                boolean nextStatus = this.getStatusBasedOnPos();
                float time = event.getEventTime() - event.getDownTime();
                if (deltaX < (float)this.mTouchSlop && deltaY < (float)this.mTouchSlop && time < (float)this.mClickTimeout) {
                    this.performClick();
                    break;
                }
                if (nextStatus != this.isChecked()) {
                    this.playSoundEffect(0);
                    this.setChecked(nextStatus);
                    break;
                }
                this.animateToState(nextStatus);
                break;
            }
        }
        return true;
    }

    private boolean getStatusBasedOnPos() {
        return this.getProcess() > 0.5f;
    }

    public final float getProcess() {
        return this.mProcess;
    }

    public final void setProcess(float process) {
        float tp = process;
        if (tp > 1.0f) {
            tp = 1.0f;
        } else if (tp < 0.0f) {
            tp = 0.0f;
        }
        this.mProcess = tp;
        this.invalidate();
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected void animateToState(boolean checked) {
        if (this.mProcessAnimator == null) {
            return;
        }
        if (this.mProcessAnimator.isRunning()) {
            this.mProcessAnimator.cancel();
        }
        this.mProcessAnimator.setDuration(this.mAnimationDuration);
        if (checked) {
            this.mProcessAnimator.setFloatValues(new float[]{this.mProcess, 1.0f});
        } else {
            this.mProcessAnimator.setFloatValues(new float[]{this.mProcess, 0.0f});
        }
        this.mProcessAnimator.start();
    }

    private void catchView() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void setChecked(boolean checked) {
        if (this.isChecked() != checked) {
            this.animateToState(checked);
        }
        super.setChecked(checked);
    }

    public void setCheckedImmediately(boolean checked) {
        super.setChecked(checked);
        if (this.mProcessAnimator != null && this.mProcessAnimator.isRunning()) {
            this.mProcessAnimator.cancel();
        }
        this.setProcess(checked ? 1.0f : 0.0f);
        this.invalidate();
    }

    public void toggleImmediately() {
        this.setCheckedImmediately(!this.isChecked());
    }

    private void setDrawableState(Drawable drawable) {
        if (drawable != null) {
            int[] myDrawableState = this.getDrawableState();
            drawable.setState(myDrawableState);
            this.invalidate();
        }
    }

    public boolean isDrawDebugRect() {
        return this.mDrawDebugRect;
    }

    public void setDrawDebugRect(boolean drawDebugRect) {
        this.mDrawDebugRect = drawDebugRect;
        this.invalidate();
    }

    public long getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(long animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public void setThumbDrawable(Drawable thumbDrawable) {
        this.mThumbDrawable = thumbDrawable;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.setup();
        this.refreshDrawableState();
        this.requestLayout();
        this.invalidate();
    }

    public void setThumbDrawableRes(int thumbDrawableRes) {
        this.setThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)thumbDrawableRes));
    }

    public Drawable getBackDrawable() {
        return this.mBackDrawable;
    }

    public void setBackDrawable(Drawable backDrawable) {
        this.mBackDrawable = backDrawable;
        this.mIsBackUseDrawable = this.mBackDrawable != null;
        this.setup();
        this.refreshDrawableState();
        this.requestLayout();
        this.invalidate();
    }

    public void setBackDrawableRes(int backDrawableRes) {
        this.setBackDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)backDrawableRes));
    }

    public ColorStateList getBackColor() {
        return this.mBackColor;
    }

    public void setBackColor(ColorStateList backColor) {
        this.mBackColor = backColor;
        if (this.mBackColor != null) {
            this.setBackDrawable(null);
        }
        this.invalidate();
    }

    public void setBackColorRes(int backColorRes) {
        this.setBackColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)backColorRes));
    }

    public ColorStateList getThumbColor() {
        return this.mThumbColor;
    }

    public void setThumbColor(ColorStateList thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.mThumbColor != null) {
            this.setThumbDrawable(null);
        }
    }

    public void setThumbColorRes(int thumbColorRes) {
        this.setThumbColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)thumbColorRes));
    }

    public float getBackMeasureRatio() {
        return this.mBackMeasureRatio;
    }

    public void setBackMeasureRatio(float backMeasureRatio) {
        this.mBackMeasureRatio = backMeasureRatio;
        this.requestLayout();
    }

    public RectF getThumbMargin() {
        return this.mThumbMargin;
    }

    public void setThumbMargin(RectF thumbMargin) {
        if (thumbMargin == null) {
            this.setThumbMargin(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.setThumbMargin(thumbMargin.left, thumbMargin.top, thumbMargin.right, thumbMargin.bottom);
        }
    }

    public void setThumbMargin(float left, float top, float right, float bottom) {
        this.mThumbMargin.set(left, top, right, bottom);
        this.requestLayout();
    }

    public void setThumbSize(float width, float height) {
        this.mThumbSizeF.set(width, height);
        this.setup();
        this.requestLayout();
    }

    public float getThumbWidth() {
        return this.mThumbSizeF.x;
    }

    public float getThumbHeight() {
        return this.mThumbSizeF.y;
    }

    public void setThumbSize(PointF size) {
        if (size == null) {
            float defaultSize = this.getResources().getDisplayMetrics().density * 20.0f;
            this.setThumbSize(defaultSize, defaultSize);
        } else {
            this.setThumbSize(size.x, size.y);
        }
    }

    public PointF getThumbSizeF() {
        return this.mThumbSizeF;
    }

    public float getThumbRadius() {
        return this.mThumbRadius;
    }

    public void setThumbRadius(float thumbRadius) {
        this.mThumbRadius = thumbRadius;
        if (!this.mIsThumbUseDrawable) {
            this.invalidate();
        }
    }

    public PointF getBackSizeF() {
        return new PointF(this.mBackRectF.width(), this.mBackRectF.height());
    }

    public float getBackRadius() {
        return this.mBackRadius;
    }

    public void setBackRadius(float backRadius) {
        this.mBackRadius = backRadius;
        if (!this.mIsBackUseDrawable) {
            this.invalidate();
        }
    }

    public boolean isFadeBack() {
        return this.mFadeBack;
    }

    public void setFadeBack(boolean fadeBack) {
        this.mFadeBack = fadeBack;
    }

    public int getTintColor() {
        return this.mTintColor;
    }

    public void setTintColor(int tintColor) {
        this.mTintColor = tintColor;
        this.mThumbColor = ColorUtils.generateThumbColorWithTintColor(this.mTintColor);
        this.mBackColor = ColorUtils.generateBackColorWithTintColor(this.mTintColor);
        this.mIsBackUseDrawable = false;
        this.mIsThumbUseDrawable = false;
        this.refreshDrawableState();
        this.invalidate();
    }

    public void setText(CharSequence onText, CharSequence offText) {
        this.mTextOn = onText;
        this.mTextOff = offText;
        this.mOnLayout = null;
        this.mOffLayout = null;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.onText = this.mTextOn;
        ss.offText = this.mTextOff;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setText(ss.onText, ss.offText);
        super.onRestoreInstanceState(ss.getSuperState());
    }

    static class SavedState
    extends View.BaseSavedState {
        CharSequence onText;
        CharSequence offText;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.onText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.offText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            TextUtils.writeToParcel((CharSequence)this.onText, (Parcel)out, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.offText, (Parcel)out, (int)flags);
        }
    }
}

