/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.architecture.ui.page;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.kunminx.architecture.BaseApplication;
import com.kunminx.architecture.ui.page.DataBindingConfig;
import com.kunminx.strictdatabinding.R;

public abstract class DataBindingFragment
extends Fragment {
    private static final Handler HANDLER = new Handler();
    protected AppCompatActivity mActivity;
    protected boolean mAnimationLoaded;
    private ViewModelProvider mFragmentProvider;
    private ViewModelProvider mActivityProvider;
    private ViewModelProvider mApplicationProvider;
    private ViewDataBinding mBinding;
    private TextView mTvStrictModeTip;

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.mActivity = (AppCompatActivity)context;
    }

    protected abstract void initViewModel();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initViewModel();
    }

    protected abstract DataBindingConfig getDataBindingConfig();

    protected ViewDataBinding getBinding() {
        if (this.isDebug() && this.mBinding != null && this.mTvStrictModeTip == null) {
            this.mTvStrictModeTip = new TextView(this.getContext());
            this.mTvStrictModeTip.setAlpha(0.5f);
            this.mTvStrictModeTip.setTextSize(16.0f);
            this.mTvStrictModeTip.setBackgroundColor(-1);
            this.mTvStrictModeTip.setText(R.string.debug_fragment_databinding_warning);
            ((ViewGroup)this.mBinding.getRoot()).addView((View)this.mTvStrictModeTip);
        }
        return this.mBinding;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        DataBindingConfig dataBindingConfig = this.getDataBindingConfig();
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)dataBindingConfig.getLayout(), (ViewGroup)container, (boolean)false);
        binding.setLifecycleOwner((LifecycleOwner)this);
        binding.setVariable(dataBindingConfig.getVmVariableId(), (Object)dataBindingConfig.getStateViewModel());
        SparseArray bindingParams = dataBindingConfig.getBindingParams();
        int length = bindingParams.size();
        for (int i = 0; i < length; ++i) {
            binding.setVariable(bindingParams.keyAt(i), bindingParams.valueAt(i));
        }
        this.mBinding = binding;
        return binding.getRoot();
    }

    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        HANDLER.postDelayed(() -> {
            if (!this.mAnimationLoaded) {
                this.mAnimationLoaded = true;
                this.loadInitData();
            }
        }, 280L);
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    protected void loadInitData() {
    }

    public boolean isDebug() {
        return this.mActivity.getApplicationContext().getApplicationInfo() != null && (this.mActivity.getApplicationContext().getApplicationInfo().flags & 2) != 0;
    }

    protected void showLongToast(String text) {
        Toast.makeText((Context)this.mActivity.getApplicationContext(), (CharSequence)text, (int)1).show();
    }

    protected void showShortToast(String text) {
        Toast.makeText((Context)this.mActivity.getApplicationContext(), (CharSequence)text, (int)0).show();
    }

    protected void showLongToast(int stringRes) {
        this.showLongToast(this.mActivity.getApplicationContext().getString(stringRes));
    }

    protected void showShortToast(int stringRes) {
        this.showShortToast(this.mActivity.getApplicationContext().getString(stringRes));
    }

    protected <T extends ViewModel> T getFragmentScopeViewModel(@NonNull Class<T> modelClass) {
        if (this.mFragmentProvider == null) {
            this.mFragmentProvider = new ViewModelProvider((ViewModelStoreOwner)this);
        }
        return (T)this.mFragmentProvider.get(modelClass);
    }

    protected <T extends ViewModel> T getActivityScopeViewModel(@NonNull Class<T> modelClass) {
        if (this.mActivityProvider == null) {
            this.mActivityProvider = new ViewModelProvider((ViewModelStoreOwner)this.mActivity);
        }
        return (T)this.mActivityProvider.get(modelClass);
    }

    protected <T extends ViewModel> T getApplicationScopeViewModel(@NonNull Class<T> modelClass) {
        if (this.mApplicationProvider == null) {
            this.mApplicationProvider = new ViewModelProvider((ViewModelStoreOwner)((BaseApplication)this.mActivity.getApplicationContext()), this.getApplicationFactory((Activity)this.mActivity));
        }
        return (T)this.mApplicationProvider.get(modelClass);
    }

    private ViewModelProvider.Factory getApplicationFactory(Activity activity) {
        this.checkActivity(this);
        Application application = this.checkApplication(activity);
        return ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application);
    }

    private Application checkApplication(Activity activity) {
        Application application = activity.getApplication();
        if (application == null) {
            throw new IllegalStateException("Your activity/fragment is not yet attached to Application. You can't request ViewModel before onCreate call.");
        }
        return application;
    }

    private void checkActivity(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Can't create ViewModelProvider for detached fragment");
        }
    }
}

