/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.binding_recyclerview.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDataBindingAdapter<M, B extends ViewDataBinding>
extends ListAdapter<M, RecyclerView.ViewHolder> {
    protected Context mContext;
    protected OnItemClickListener<M> mOnItemClickListener;
    protected OnItemLongClickListener<M> mOnItemLongClickListener;

    public void setOnItemClickListener(OnItemClickListener<M> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener<M> onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public BaseDataBindingAdapter(Context context, @NonNull DiffUtil.ItemCallback<M> diffCallback) {
        super(diffCallback);
        this.mContext = context;
    }

    public void submitList(@Nullable List<M> list) {
        super.submitList(list, () -> super.submitList(list == null ? new ArrayList() : new ArrayList(list)));
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.mContext), (int)this.getLayoutResId(viewType), (ViewGroup)parent, (boolean)false);
        BaseBindingViewHolder holder = new BaseBindingViewHolder(binding.getRoot());
        holder.itemView.setOnClickListener(v -> {
            if (this.mOnItemClickListener != null) {
                int position = holder.getBindingAdapterPosition();
                this.mOnItemClickListener.onItemClick(holder.itemView.getId(), this.getItem(position), position);
            }
        });
        holder.itemView.setOnLongClickListener(v -> {
            if (this.mOnItemLongClickListener != null) {
                int position = holder.getBindingAdapterPosition();
                this.mOnItemLongClickListener.onItemLongClick(holder.itemView.getId(), this.getItem(position), position);
                return true;
            }
            return false;
        });
        return holder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ViewDataBinding binding = DataBindingUtil.getBinding((View)holder.itemView);
        this.onBindItem(binding, this.getItem(position), holder);
        if (binding != null) {
            binding.executePendingBindings();
        }
    }

    @LayoutRes
    protected abstract int getLayoutResId(int var1);

    protected abstract void onBindItem(B var1, M var2, RecyclerView.ViewHolder var3);

    public static interface OnItemLongClickListener<M> {
        public void onItemLongClick(int var1, M var2, int var3);
    }

    public static interface OnItemClickListener<M> {
        public void onItemClick(int var1, M var2, int var3);
    }

    public static class BaseBindingViewHolder
    extends RecyclerView.ViewHolder {
        BaseBindingViewHolder(View itemView) {
            super(itemView);
        }
    }
}

