(ns com.kubelt.ddt.cmds.sdk.workspace.available
  "Invoke the 'sdk workspace available' method."
  {:copyright "©2022 Proof Zero Inc." :license "Apache 2.0"}
  (:require
   [com.kubelt.lib.error :as lib.error]
   [com.kubelt.sdk.v1 :as sdk]))

(defonce command
  {:command "available"
   :desc "List available workspaces"
   :requiresArg false

   :builder (fn [^Yargs yargs]
              yargs)

   :handler (fn [args]
              (let [kbt (sdk/init)]
                (if (lib.error/error? kbt)
                  (prn (:error kbt))
                  (println "available: not yet implemented"))
                (sdk/halt! kbt)))})
