package com.ksc.mission.base.s3;

import java.util.Properties;

import com.ksc.mission.base.interfaces.PropertiesReader;

public class S3Properties {
	final public String type;
	final public String url;
	final public String region;
	final public String user;
	final public String secret;
	final public String bucketName;

	public S3Properties(String type, String url, String region, String user, String secret, String bucketName) {
		this.type = type;
		this.url = url;
		this.region = region;
		this.user = user;
		this.secret = secret;
		this.bucketName = bucketName;
	}
	
	public static S3Properties defaults() {
		return new  S3Properties(
				"AmazonS3",
				"http://172.17.0.1:48894",
				"us-west-2",
				"accessKey1",
				"verySecretKey1",
				"mybucket"
		);	
	}

	public static S3Properties from(String environmentName) {
		return from(environmentName, "s3", null);
	}
	
	public static S3Properties from(String environmentName, String propertyFile, String tag) {
		Properties appProps = PropertiesReader.from(environmentName, propertyFile);
		String prefix = "s3.";
		if(tag != null && !tag.isEmpty())
			prefix += tag + ".";
		return new S3Properties(
				appProps.getProperty(prefix + "type"),
				appProps.getProperty(prefix + "url"),
				appProps.getProperty(prefix + "region"),
				appProps.getProperty(prefix + "user"),
				appProps.getProperty(prefix + "secret"),
				appProps.getProperty(prefix + "bucketName"));
	}
}
