/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.ksc.mission.base.interfaces.IFile;
import com.ksc.mission.base.s3.S3ClientConnector;
import java.util.Date;

public class S3File
implements IFile {
    protected final S3ClientConnector clientConnector;
    protected final String key;
    protected final ObjectMetadata metadata;

    public S3File(S3ClientConnector clientConnector, String key, ObjectMetadata metadata) {
        this.clientConnector = clientConnector;
        this.key = key;
        this.metadata = metadata;
    }

    public String getFullName() {
        String[] strs = this.getFullPath().split("/");
        return strs[strs.length - 1];
    }

    public String getName() {
        return this.getFullName().split(".")[0];
    }

    public String getExtension() {
        String[] strs = this.getFullPath().split(".");
        if (strs.length > 1) {
            return strs[strs.length - 1];
        }
        return "";
    }

    public Date getDate() {
        return this.metadata.getLastModified();
    }

    public long getTimestampMillis() {
        return this.metadata.getLastModified().getTime();
    }

    public String getFullPath() {
        return this.key;
    }

    public long getContentLength() {
        return this.metadata.getContentLength();
    }

    public int read(byte[] buffer, long filePosition, long length) {
        return this.clientConnector.getBuffer(this.key, this.metadata.getVersionId(), filePosition, buffer);
    }

    public String getPath() {
        String[] strs = this.getFullPath().split("/");
        String path = "";
        boolean first = true;
        for (int i = 0; i < strs.length - 1; ++i) {
            if (first) {
                path = path + strs[i];
                first = false;
                continue;
            }
            path = path + "/" + strs[i];
        }
        return path;
    }

    public String getVersionId() {
        return this.metadata.getVersionId();
    }
}

