/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ksc.mission.base.interfaces.IFile;
import com.ksc.mission.base.interfaces.IS3InputStream;
import com.ksc.mission.base.relatedobjects.OwnedService;
import com.ksc.mission.base.s3.CredentialsProvider;
import com.ksc.mission.base.s3.S3File;
import com.ksc.mission.base.s3.S3Properties;
import com.ksc.mission.base.util.PositionableReadStream;
import com.ksc.mission.base.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class S3ClientConnector
extends OwnedService {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 0x800000;
    protected final transient AmazonS3 s3Client;
    protected final String s3Type;
    protected final String bucketName;
    protected final boolean versioning;
    protected TransferManager transferManager;

    public static AmazonS3 defaultS3Client(S3Properties properties) {
        if (properties.type.equalsIgnoreCase("DELL")) {
            return S3ClientConnector.dellS3Client(properties);
        }
        return S3ClientConnector.amazonS3Client(properties);
    }

    public static AmazonS3 amazonS3Client(S3Properties properties) {
        return S3ClientConnector.amazonS3ClientFor(properties.url, properties.region, new CredentialsProvider(properties));
    }

    public static AmazonS3 dellS3Client(S3Properties properties) {
        return S3ClientConnector.dellS3ClientFor(properties.url, new CredentialsProvider(properties));
    }

    public static AmazonS3 amazonS3ClientFor(String endpoint, String region, AWSCredentials credentialsProvider) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentialsProvider))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withRegion(region)).build();
    }

    public static AmazonS3 dellS3ClientFor(String endpoint, AWSCredentials credentialsProvider) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentialsProvider))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, ""))).build();
    }

    public S3ClientConnector(S3Properties properties) {
        this(S3ClientConnector.defaultS3Client(properties), properties.type, properties.bucketName, properties.versioning);
    }

    public static S3ClientConnector from(String environment) {
        return new S3ClientConnector(S3Properties.from(environment));
    }

    public static S3ClientConnector forBucket(String environment, String bucketName, boolean versioning) {
        return S3ClientConnector.forBucket(S3Properties.from(environment), bucketName, versioning);
    }

    public static S3ClientConnector forBucket(S3Properties properties, String bucketName, boolean versioning) {
        return new S3ClientConnector(S3ClientConnector.defaultS3Client(properties), properties.type, bucketName, versioning);
    }

    public S3ClientConnector(AmazonS3 s3Client, String s3Type, String bucketName, boolean versioning) {
        this.s3Client = s3Client;
        this.versioning = versioning;
        this.s3Type = s3Type;
        this.bucketName = bucketName;
        if (!this.doesBucketExist()) {
            this.createBucket();
            this.setBucketVersioning(versioning);
        }
    }

    public void start() {
        this.subscribe("#CREATED", msg -> {
            try {
                this.createOrReplaceObject("" + msg.getPayload(), new ObjectMapper().writer().writeValueAsString((Object)msg.getPayload()));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            this.logDebug("createOrReplaceObject - " + msg);
        });
        this.subscribe("S3_LIST", msg -> {
            String prefix = (String)((Object)msg.getPayload());
            Stream<S3ObjectSummary> stream = null;
            stream = prefix == null || prefix.isEmpty() ? this.stream() : this.streamWithPrefix(prefix);
            this.logInfo("File List for Bucket: " + this.bucketName);
            stream.forEach(eaSummary -> this.logInfo("    " + eaSummary.getKey() + " " + eaSummary.getSize() + " " + eaSummary.getLastModified()));
        });
        this.subscribe("S3_LIST_VERSIONS", msg -> {
            String prefix = (String)((Object)msg.getPayload());
            if (prefix == null) {
                prefix = "";
            }
            this.streamVersionsWithPattern(prefix).forEach(eaSummary -> this.logDebug(eaSummary.getKey() + " " + eaSummary.getLastModified()));
        });
        this.subscribe("S3_DELETE_ALL", msg -> {
            String bName = (String)((Object)msg.getPayload());
            if (this.bucketName.equals(bName)) {
                this.deleteAllObjects();
            }
        });
        this.subscribe("S3_DELETE", msg -> {
            String[] args = (String[])msg.getPayload();
            if (this.getId().equals(args[0])) {
                this.deleteAllWithPattern(args[1], args[2]);
            }
        });
    }

    public void setBucketVersioning(boolean versioning) {
        if (versioning) {
            BucketVersioningConfiguration configuration = new BucketVersioningConfiguration().withStatus(versioning ? "Enabled" : "Disabled");
            SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest = new SetBucketVersioningConfigurationRequest(this.bucketName, configuration);
            this.s3Client.setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
        }
    }

    public Date getUtcTime() {
        String timeNowFile = "TIME_NOW-" + UUID.randomUUID();
        this.createOrReplaceObject(timeNowFile, "");
        S3Object file = this.getObject(timeNowFile);
        Date lastMod = file.getObjectMetadata().getLastModified();
        this.deleteObject(timeNowFile);
        return lastMod;
    }

    public void deleteAllObjects() {
        this.deleteAllObjects(() -> this.stream());
    }

    public void deleteAllWithPrefix(String prefix, String excludePattern) {
        this.deleteAllObjects(() -> {
            Stream<S3ObjectSummary> stream = this.streamWithPrefix(prefix);
            if (excludePattern != null && !excludePattern.trim().isEmpty()) {
                stream = stream.filter(ea -> !StringUtil.matches((String)ea.getKey(), (String)excludePattern));
            }
            return stream;
        });
    }

    public void deleteAllWithPattern(String includePattern, String excludePattern) {
        this.deleteAllObjects(() -> {
            Stream<S3ObjectSummary> stream = this.streamWithPattern(includePattern);
            if (excludePattern != null && !excludePattern.trim().isEmpty()) {
                stream = stream.filter(ea -> !StringUtil.matches((String)ea.getKey(), (String)excludePattern));
            }
            return stream;
        });
    }

    public void deleteAllObjects(Supplier<Stream<S3ObjectSummary>> streamSupplier) {
        int batchSize = 1000;
        Date now = this.getUtcTime();
        while (true) {
            long startTime = System.currentTimeMillis();
            List<String> keys = streamSupplier.get().filter(ea -> ea.getLastModified().before(now)).map(ea -> ea.getKey()).limit(batchSize).collect(Collectors.toList());
            if (keys.isEmpty()) {
                return;
            }
            this.deleteAllObjects(keys);
            long endTime = System.currentTimeMillis();
            this.logInfo("Deleted - " + keys.size() + " Time - " + (endTime - startTime));
        }
    }

    protected Stream<String> urlEncoded(Stream<String> stream) {
        return stream.map(key -> {
            String encodedKey;
            try {
                encodedKey = URLEncoder.encode(key, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return key;
            }
            return encodedKey;
        });
    }

    public void deleteAllObjects(List<String> keys) {
        try {
            List keyVersions = keys.stream().map(ea -> new DeleteObjectsRequest.KeyVersion(ea)).collect(Collectors.toList());
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucketName).withKeys(keyVersions);
            this.s3Client.deleteObjects(deleteRequest);
        }
        catch (Exception ex) {
            keys.forEach(key -> this.deleteObject((String)key));
        }
    }

    public void deleteObject(String key) {
        DeleteObjectRequest deleteRequest = new DeleteObjectRequest(this.bucketName, key);
        this.s3Client.deleteObject(deleteRequest);
    }

    public void deleteObjectVersion(String key, String version) {
        DeleteVersionRequest deleteVersionRequest = new DeleteVersionRequest(this.bucketName, key, version);
        this.s3Client.deleteVersion(deleteVersionRequest);
    }

    public TransferManager getTransferManager() {
        if (this.transferManager == null) {
            this.transferManager = TransferManagerBuilder.standard().withS3Client(this.s3Client).build();
        }
        return this.transferManager;
    }

    public void putObject(String key, byte[] contentBytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("application/octet-stream");
        metadata.setContentLength((long)contentBytes.length);
        this.s3Client.putObject(new PutObjectRequest(this.bucketName, key, (InputStream)is, metadata));
    }

    public void createOrReplaceObject(String key, String contents) {
        this.s3Client.putObject(this.bucketName, key, contents);
    }

    public void createOrReplaceObjectAsync(String key, String contents) {
        try {
            this.createOrReplaceObjectAsync(key, contents.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void createOrReplaceObject(String key, byte[] bytes) {
        this.createOrReplaceObject(key, new ByteArrayInputStream(bytes), bytes.length, true);
        if (!this.exists(key)) {
            this.putObject(key, bytes);
        }
    }

    public void createOrReplaceObjectAsync(String key, byte[] bytes) {
        this.createOrReplaceObject(key, new ByteArrayInputStream(bytes), bytes.length, false);
    }

    public void createOrReplaceObject(String key, IS3InputStream s3InputStream) {
        this.createOrReplaceObject(key, (InputStream)s3InputStream, s3InputStream.getContentLength(), true);
    }

    public void createOrReplaceObject(String key, IS3InputStream s3InputStream, boolean wait) {
        this.createOrReplaceObject(key, (InputStream)s3InputStream, s3InputStream.getContentLength(), wait);
    }

    public void createOrReplaceObject(String key, InputStream inputStream, long size, boolean wait) {
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(size);
            Upload upload = this.getTransferManager().upload(this.bucketName, key, inputStream, metadata);
            if (wait) {
                upload.waitForCompletion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createOrReplaceObjectAsync(String key, Supplier<IS3InputStream> s3InputStreamSupplier, Consumer<String> onCompletion, Consumer<Exception> onError) {
        this.createOrReplaceObjectAsync(key, s3InputStreamSupplier, s3InputStreamSupplier.get().getContentLength(), onCompletion, onError);
    }

    public void createOrReplaceObjectAsync(final String key, final Supplier<? extends InputStream> inputStreamSupplier, long size, final Consumer<String> onCompletion, final Consumer<Exception> onError) {
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(size);
            Upload upload = this.getTransferManager().upload(this.bucketName, key, inputStreamSupplier.get(), metadata);
            upload.addProgressListener(new ProgressListener(){

                public void progressChanged(ProgressEvent progressEvent) {
                    if (progressEvent.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                        if (!S3ClientConnector.this.exists(key)) {
                            try {
                                S3ClientConnector.this.createOrReplaceObject(key, ((InputStream)inputStreamSupplier.get()).readAllBytes());
                            }
                            catch (IOException e) {
                                onError.accept(new Exception("S3 file failed to write - " + key, e));
                                return;
                            }
                        }
                        if (!S3ClientConnector.this.exists(key)) {
                            onError.accept(new Exception("S3 file failed to write - " + key));
                            return;
                        }
                        onCompletion.accept(key);
                    } else if (progressEvent.getEventType() == ProgressEventType.TRANSFER_FAILED_EVENT) {
                        onError.accept(new Exception("Transfer failed - " + key));
                    }
                }
            });
        }
        catch (Exception e) {
            onError.accept(new Exception("Transfer failed - " + key));
        }
    }

    public S3Object getObject(String key) {
        return this.s3Client.getObject(new GetObjectRequest(this.bucketName, key));
    }

    public S3Object getObject(String key, String versionId) {
        return this.s3Client.getObject(new GetObjectRequest(this.bucketName, key, versionId));
    }

    public void createBucket() {
        if (!this.doesBucketExist()) {
            this.s3Client.createBucket(this.bucketName);
        }
    }

    public void deleteBucket() {
        this.s3Client.deleteBucket(this.bucketName);
    }

    public void createOrReplaceObject(String key, File file) {
        this.s3Client.putObject(this.bucketName, key, file);
    }

    public boolean doesBucketExist() {
        return this.s3Client.doesBucketExistV2(this.bucketName);
    }

    public boolean exists(String key) {
        return this.s3Client.doesObjectExist(this.bucketName, key);
    }

    public Stream<S3ObjectSummary> streamWithPrefix(String prefix) {
        S3Objects s3Objects = S3Objects.withPrefix((AmazonS3)this.s3Client, (String)this.bucketName, (String)prefix);
        return StreamSupport.stream(s3Objects.spliterator(), false);
    }

    public Stream<S3ObjectSummary> streamWithPattern(String pattern) {
        Stream<S3ObjectSummary> stream = null;
        if (pattern.startsWith("*")) {
            stream = this.stream();
        } else {
            String prefix = pattern.split("\\*")[0];
            stream = this.streamWithPrefix(prefix);
        }
        return stream.filter(ea -> StringUtil.matches((String)ea.getKey(), (String)pattern));
    }

    public Stream<S3ObjectSummary> stream() {
        return StreamSupport.stream(S3Objects.inBucket((AmazonS3)this.s3Client, (String)this.bucketName).spliterator(), false);
    }

    public List<S3VersionSummary> listVersions(String prefix) {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(this.bucketName).withPrefix(prefix).withMaxResults(Integer.valueOf(100));
        VersionListing result = this.s3Client.listVersions(request);
        return result.getVersionSummaries();
    }

    public Stream<S3VersionSummary> streamVersionsWithPattern(String pattern) {
        return this.streamWithPattern(pattern).map(ea -> ea.getKey()).flatMap(ea -> this.listVersions((String)ea).stream());
    }

    public InputStreamReader openInputStreamReader(String key) {
        return new InputStreamReader((InputStream)this.openPositionableReadStream(key));
    }

    public InputStreamReader openInputStreamReader(String key, String versionId) {
        return new InputStreamReader((InputStream)this.openPositionableReadStream(key, versionId));
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key) {
        return this.openPositionableReadStream(key, (String)null, 0L);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, String versionId) {
        return this.openPositionableReadStream(key, versionId, 0L);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, long position) {
        return this.openPositionableReadStream(key, (String)null, position);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, String versionId, long startPosition) {
        return this.openPositionableReadStream(key, this.getObjectMetadata(key, versionId), startPosition);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, String versionId, long startPosition, long endPosition) {
        return this.openPositionableReadStream(key, this.getObjectMetadata(key, versionId), startPosition, endPosition);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, ObjectMetadata metadata, long startPosition) {
        return new PositionableReadStream((IFile)new S3File(this, key, metadata), startPosition);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, long startPosition, long endPosition) {
        return new PositionableReadStream((IFile)new S3File(this, key, this.getObjectMetadata(key, null)), startPosition, endPosition);
    }

    public PositionableReadStream<S3File> openPositionableReadStream(String key, ObjectMetadata metadata, long startPosition, long endPosition) {
        return new PositionableReadStream((IFile)new S3File(this, key, metadata), startPosition, endPosition);
    }

    public ObjectMetadata getObjectMetadata(String key, String versionId) {
        return this.s3Client.getObjectMetadata(new GetObjectMetadataRequest(this.bucketName, key, versionId));
    }

    public boolean getRange(GetObjectRequest request, byte[] buffer) {
        return -1 != this.getBuffer(request, buffer);
    }

    public boolean getRange(String file, long position, byte[] buffer) {
        return -1 != this.getBuffer(file, position, buffer);
    }

    public boolean getRange(String file, String versionId, long position, byte[] buffer) {
        return -1 != this.getBuffer(file, versionId, position, buffer);
    }

    public int getBuffer(String file, long position, byte[] buffer) {
        GetObjectRequest request = new GetObjectRequest(this.bucketName, file).withRange(position, position + (long)buffer.length - 1L);
        return this.getBuffer(request, buffer);
    }

    public int getBuffer(String file, String versionId, long position, byte[] buffer) {
        GetObjectRequest request = new GetObjectRequest(this.bucketName, file, versionId).withRange(position, position + (long)buffer.length - 1L);
        return this.getBuffer(request, buffer);
    }

    public int getBuffer(GetObjectRequest request, byte[] buffer) {
        int n;
        block9: {
            S3Object s3Object = this.s3Client.getObject(request);
            try {
                int next;
                int index = 0;
                S3ObjectInputStream stream = s3Object.getObjectContent();
                int count = 0;
                while ((next = stream.read()) != -1) {
                    buffer[index++] = (byte)next;
                    ++count;
                }
                n = count;
                if (s3Object == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s3Object != null) {
                        try {
                            s3Object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            s3Object.close();
        }
        return n;
    }
}

