/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.ksc.mission.base.s3.S3ClientConnector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;

public class PositionableReadStream
extends InputStream {
    protected int maxBufferSize;
    protected final S3ClientConnector clientConnector;
    protected Scanner scanner;
    protected int[] buffer;
    protected long bufferStartPosition;
    protected long bufferEndPosition;
    protected final String key;
    protected final ObjectMetadata metadata;
    protected long position = 0L;
    protected long objectLength;

    public PositionableReadStream(S3ClientConnector clientConnector, String key, ObjectMetadata metadata, long position, int maxBufferSize) {
        this.clientConnector = clientConnector;
        this.key = key;
        this.metadata = metadata;
        this.objectLength = this.getLength();
        this.position = position;
        this.maxBufferSize = maxBufferSize;
        this.buffer = new int[maxBufferSize];
        this.getNextPage(position);
    }

    public PositionableReadStream(S3ClientConnector clientConnector, String key, ObjectMetadata metadata, long position, int maxBufferSize, long readLimit) {
        this.clientConnector = clientConnector;
        this.key = key;
        this.metadata = metadata;
        this.objectLength = Math.min(this.getLength(), readLimit);
        this.position = position;
        long dataSize = this.objectLength - position;
        this.maxBufferSize = (int)Math.min(dataSize, (long)maxBufferSize);
        this.buffer = new int[maxBufferSize];
        this.getNextPage(position);
    }

    public ZipInputStream asZipInputStream() {
        return new ZipInputStream(this);
    }

    @Override
    public int read() {
        if (this.position >= this.objectLength) {
            return -1;
        }
        if (!(this.position <= this.bufferEndPosition && this.position >= this.bufferStartPosition || this.getNextPage(this.position))) {
            return -1;
        }
        int b = this.buffer[(int)(this.position - this.bufferStartPosition)];
        ++this.position;
        return b;
    }

    public boolean getNextPage(long position) {
        this.bufferStartPosition = position;
        this.bufferEndPosition = this.bufferStartPosition + (long)this.buffer.length - 1L;
        return this.clientConnector.getRange(this.key, this.metadata.getVersionId(), position, this.buffer);
    }

    public byte[] toByteArray() {
        byte next;
        long currentPosition = this.position;
        this.position = 0L;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        while ((next = (byte)this.read()) != -1) {
            byteStream.write(next);
        }
        this.position = currentPosition;
        return byteStream.toByteArray();
    }

    public PositionableReadStream clone() {
        return this.clientConnector.openPositionableReadStream(this.key, this.metadata, this.position);
    }

    public long indexOf(String string) {
        return this.indexOf(string.getBytes());
    }

    public long indexOf(byte[] bytes) {
        long currentPosition = this.position;
        while (!this.nextMatches(bytes)) {
            if (this.read() != -1) continue;
            this.position = currentPosition;
            return -1L;
        }
        long ans = this.position;
        this.position = currentPosition;
        return ans;
    }

    public boolean nextMatches(String string) {
        return this.nextMatches(string.getBytes());
    }

    public boolean nextMatches(byte[] bytes) {
        int bytesLastIndex = bytes.length - 1;
        long endReadPosition = this.position + (long)bytesLastIndex;
        if (endReadPosition > this.bufferEndPosition && !this.getNextPage(this.position)) {
            return false;
        }
        long currentPosition = this.position;
        for (int i = 0; i <= bytesLastIndex; ++i) {
            if (bytes[i] == this.read()) continue;
            this.position = currentPosition;
            return false;
        }
        this.position = currentPosition;
        return true;
    }

    public byte[] peekFor(long length) {
        if (this.position + length > this.bufferEndPosition && !this.getNextPage(this.position)) {
            return null;
        }
        long currentPosition = this.position;
        byte[] ans = this.readTo(this.position + length);
        this.position = currentPosition;
        return ans;
    }

    public byte[] read(int length) {
        return this.readTo(this.position + (long)length);
    }

    public byte[] readTo(long endPosition) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        long end = Math.min(endPosition, this.objectLength - 1L);
        int length = (int)(end - this.position);
        if (length < 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            byteStream.write(this.read());
        }
        return byteStream.toByteArray();
    }

    public InputStreamReader asInputStreamReader() {
        return new InputStreamReader(this);
    }

    public InputStreamReader asInputStreamReader(String codepage) {
        try {
            return new InputStreamReader((InputStream)this, codepage);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IntStream intStream() {
        return IntStream.generate(() -> this.read()).limit(this.objectLength - this.position);
    }

    public Stream<Character> characterStream() {
        InputStreamReader reader = new InputStreamReader(this);
        return IntStream.generate(() -> {
            try {
                return reader.read();
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }).takeWhile(each -> each != -1).mapToObj(i -> Character.valueOf((char)i));
    }

    public Scanner scanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner(this);
        }
        return this.scanner;
    }

    public Stream<String> stringStream() {
        Scanner scanner = this.scanner();
        return Stream.generate(() -> scanner.next());
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int occurrences(String string) {
        boolean count = false;
        byte[] bytes = string.getBytes();
        return this.occurrences(bytes);
    }

    public int occurrences(byte[] bytes) {
        int count = 0;
        long currentPosition = this.position;
        if (this.nextMatches(bytes)) {
            ++count;
        }
        while (this.read() != -1) {
            if (!this.nextMatches(bytes)) continue;
            ++count;
        }
        this.position = currentPosition;
        return count;
    }

    public String getVersionId() {
        return this.metadata.getVersionId();
    }

    public long getLength() {
        return this.metadata.getContentLength();
    }
}

