package com.ksc.mission.base.s3;

import com.ksc.mission.base.interfaces.IMessage;
import com.ksc.mission.base.interfaces.Message;
import com.ksc.mission.base.microservice.MicroServiceBuilder;
import com.ksc.mission.base.relatedobjects.IOwnedService;

public interface Is3Support<TYPE extends MicroServiceBuilder<?>> {
	
	default public TYPE withS3ClientConnector(String environment, String bucketName, boolean versioning) {
		return withService(S3ClientConnector.forBucket(environment, bucketName, versioning));
	}

	default public TYPE withS3ClientConnector(S3Properties properties, String bucketName, boolean versioning) {
		return withService(S3ClientConnector.forBucket(properties, bucketName, versioning));
	}

	@SuppressWarnings({ "unchecked" })
	default public TYPE withS3Delete(S3ClientConnector connector, String includePattern, String excludePattern) {
		addStartupMessage(new Message("S3_DELETE", new String[] { connector.getId(),  includePattern, excludePattern }));
		return (TYPE)this;
	}

	public TYPE withService(IOwnedService service);
	public void addStartupMessage(IMessage message);

}
