/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.ksc.mission.base.s3.S3ClientConnector;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PositionableReadStream
extends InputStream {
    protected int maxBufferSize;
    protected final S3ClientConnector clientConnector;
    protected Scanner scanner;
    protected int[] buffer;
    protected long bufferStartPosition;
    protected long bufferEndPosition;
    protected final String key;
    protected final ObjectMetadata metadata;
    protected long position = 0L;
    protected long objectLength;

    public PositionableReadStream(S3ClientConnector clientConnector, String key, ObjectMetadata metadata, long position, int maxBufferSize) {
        this.clientConnector = clientConnector;
        this.key = key;
        this.metadata = metadata;
        this.objectLength = this.getLength();
        this.position = position;
        this.maxBufferSize = maxBufferSize;
        this.buffer = new int[maxBufferSize];
        this.getNextPage(position);
    }

    @Override
    public int read() {
        if (this.position >= this.objectLength || this.position > this.bufferEndPosition || this.position < this.bufferStartPosition && !this.getNextPage(this.position)) {
            return -1;
        }
        int b = this.buffer[(int)(this.position - this.bufferStartPosition)];
        ++this.position;
        return b;
    }

    public boolean getNextPage(long position) {
        this.bufferStartPosition = position;
        this.bufferEndPosition = this.bufferStartPosition + (long)this.buffer.length - 1L;
        return this.clientConnector.getRange(this.key, this.metadata.getVersionId(), position, this.buffer);
    }

    public String getContents() {
        int next;
        long currentPosition = this.position;
        this.position = 0L;
        StringWriter writer = new StringWriter();
        while ((next = this.read()) != -1) {
            writer.write(next);
        }
        this.position = currentPosition;
        return writer.toString();
    }

    public PositionableReadStream clone() {
        return this.clientConnector.openPositionableReadStream(this.key, this.metadata, this.position);
    }

    public long indexOf(String str) {
        long currentPosition = this.position;
        int[] chars = str.chars().toArray();
        while (!this.nextMatches(chars)) {
            if (this.read() != -1) continue;
            this.position = currentPosition;
            return -1L;
        }
        long ans = this.position;
        this.position = currentPosition;
        return ans;
    }

    public boolean nextMatches(int[] chars) {
        int charsLastIndex = chars.length - 1;
        long endReadPosition = this.position + (long)charsLastIndex;
        if (endReadPosition > this.bufferEndPosition && !this.getNextPage(this.position)) {
            return false;
        }
        long currentPosition = this.position;
        for (int i = 0; i <= charsLastIndex; ++i) {
            if (chars[i] == this.read()) continue;
            this.position = currentPosition;
            return false;
        }
        this.position = currentPosition;
        return true;
    }

    public String peekFor(long length) {
        if (this.position + length > this.bufferEndPosition && !this.getNextPage(this.position)) {
            return null;
        }
        long currentPosition = this.position;
        String ans = this.readTo(this.position + length);
        this.position = currentPosition;
        return ans;
    }

    public String read(int length) {
        return this.readTo(this.position + (long)length);
    }

    public String readTo(long endPosition) {
        StringWriter writer = new StringWriter();
        long end = Math.min(endPosition, this.objectLength - 1L);
        int length = (int)(end - this.position);
        if (length < 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            writer.write(this.read());
        }
        return writer.toString();
    }

    public IntStream intStream() {
        return IntStream.generate(() -> this.read()).limit(this.objectLength - this.position);
    }

    public Stream<Character> characterStream() {
        return IntStream.generate(() -> this.read()).limit(this.objectLength - this.position).mapToObj(i -> Character.valueOf((char)i));
    }

    public Scanner scanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner(this);
        }
        return this.scanner;
    }

    public Stream<String> stringStream() {
        Scanner scanner = this.scanner();
        return Stream.generate(() -> scanner.next());
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int occurrences(String string) {
        int count = 0;
        int[] chars = string.chars().toArray();
        if (this.nextMatches(chars)) {
            ++count;
        }
        while (this.read() != -1) {
            if (!this.nextMatches(chars)) continue;
            ++count;
        }
        return count;
    }

    public String getVersionId() {
        return this.metadata.getVersionId();
    }

    public long getLength() {
        return this.metadata.getContentLength();
    }
}

