/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.amazonaws.services.s3.model.S3VersionSummary;
import com.ksc.mission.base.logger.SimpleProfiler;
import com.ksc.mission.base.s3.PositionableReadStream;
import com.ksc.mission.base.s3.S3ClientConnector;
import java.io.File;

public class S3Launcher {
    public static void main(String[] args) {
        S3ClientConnector connector = new S3ClientConnector();
        connector.init();
        String filePath = "C:\\Users\\davia41\\Downloads\\98760dcd-7002-4572-8bb2-c33f9017f38f.csv";
        connector.createOrReplaceObject(filePath, new File(filePath));
        for (S3VersionSummary summary : connector.listVersions("C:\\Users")) {
            System.out.println("Key: " + summary.getKey() + " Version: " + summary.getVersionId() + " Timestamp: " + summary.getLastModified());
        }
        PositionableReadStream stream = connector.openPositionableReadStream(filePath, "39383435333131353239343734303939393939395247303031202033");
        System.out.println("VersionId: " + stream.getVersionId());
        SimpleProfiler.log(() -> {
            int i;
            stream.setPosition(stream.indexOf("REDMOND"));
            System.out.println("Peek for - 4 " + stream.peekFor(4L));
            System.out.println("Read to - 4 " + stream.read(4));
            System.out.println("Peek for - 4 " + stream.peekFor(4L));
            stream.setPosition(0L);
            for (i = 0; i < 100; ++i) {
                System.out.println(stream.scanner().nextLine());
            }
            stream.setPosition(1000000L);
            for (i = 0; i < 100; ++i) {
                System.out.println(stream.scanner().nextLine());
            }
            stream.setPosition(2000000L);
            for (i = 0; i < 100; ++i) {
                System.out.println(stream.scanner().nextLine());
            }
            stream.setPosition(1000L);
            for (i = 0; i < 100; ++i) {
                System.out.println(stream.scanner().nextLine());
            }
            System.out.println("Occurrences of RED - " + stream.occurrences("RED"));
        });
    }
}

