/*
 * Decompiled with CFR 0.152.
 */
package com.mission.base.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.VersionListing;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mission.base.relatedobjects.OwnedService;
import com.mission.base.s3.CredentialsProvider;
import com.mission.base.s3.PositionableReadStream;
import com.mission.base.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class S3ClientConnector
extends OwnedService {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    protected AmazonS3 s3Client = null;
    protected final String endpoint;
    protected final String region;
    protected final String bucketName;
    protected final boolean versioning;

    public S3ClientConnector() {
        this.endpoint = "http://192.168.99.100:32768/";
        this.region = "us-west-2";
        this.bucketName = "mybucket";
        this.versioning = true;
    }

    public S3ClientConnector(String endpoint, String region, String bucketName, boolean versioning) {
        this.endpoint = endpoint;
        this.region = region;
        this.bucketName = bucketName.toLowerCase();
        this.versioning = versioning;
    }

    public void init() {
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new CredentialsProvider()))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region))).build();
        if (!this.doesBucketExist(this.bucketName)) {
            this.getS3Client().createBucket(this.bucketName);
        }
        this.setBucketVersioning();
        this.subscribe("#CREATED", msg -> {
            try {
                this.createOrReplaceObject("" + msg.getPayload(), new ObjectMapper().writer().writeValueAsString((Object)msg.getPayload()));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            System.out.println("createOrReplaceObject - " + msg);
        });
        this.subscribe("S3_LIST", msg -> {
            String prefix = (String)((Object)msg.getPayload());
            List<S3ObjectSummary> list = null;
            list = prefix == null || prefix.isEmpty() ? this.listWithPrefix(prefix) : this.list();
            for (S3ObjectSummary eaSummary : list) {
                System.out.println("" + eaSummary);
            }
        });
        this.subscribe("S3_LIST_VERSIONS", msg -> {
            String prefix = (String)((Object)msg.getPayload());
            List<S3VersionSummary> list = null;
            if (prefix == null) {
                prefix = "";
            }
            list = this.listVersionsWithPattern(prefix);
            for (S3VersionSummary eaSummary : list) {
                System.out.println(eaSummary.getKey() + " " + eaSummary.getLastModified());
            }
        });
        this.subscribe("S3_DELETE_ALL", msg -> {
            String bName = (String)((Object)msg.getPayload());
            if (this.bucketName.equals(bName)) {
                this.deleteAllObjects();
            }
        });
    }

    public void setBucketVersioning() {
        BucketVersioningConfiguration configuration = new BucketVersioningConfiguration().withStatus(this.versioning ? "Enabled" : "Disabled");
        SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest = new SetBucketVersioningConfigurationRequest(this.bucketName, configuration);
        this.s3Client.setBucketVersioningConfiguration(setBucketVersioningConfigurationRequest);
        BucketVersioningConfiguration conf = this.s3Client.getBucketVersioningConfiguration(this.bucketName);
        System.out.println("bucket versioning configuration status:    " + conf.getStatus());
    }

    public AmazonS3 getS3Client() {
        return this.s3Client;
    }

    public void setS3Client(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    public void deleteAllObjects() {
        List<DeleteObjectsRequest.KeyVersion> keyVersions = this.list().stream().map(ea -> new DeleteObjectsRequest.KeyVersion(ea.getKey())).collect(Collectors.toList());
        this.deleteAllObjects(keyVersions);
    }

    public void deleteAllObjects(List<DeleteObjectsRequest.KeyVersion> keyVersions) {
        DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucketName).withKeys(keyVersions);
        this.s3Client.deleteObjects(deleteRequest);
    }

    public void deleteObject(String key) {
        DeleteObjectRequest deleteRequest = new DeleteObjectRequest(this.bucketName, key);
        this.s3Client.deleteObject(deleteRequest);
    }

    public void deleteObjectVersion(String key, String version) {
        DeleteVersionRequest deleteVersionRequest = new DeleteVersionRequest(this.bucketName, key, version);
        this.s3Client.deleteVersion(deleteVersionRequest);
    }

    public void createOrReplaceObject(String key, String contents) {
        this.getS3Client().putObject(this.bucketName, key, contents);
    }

    public void getObject(String key) {
        this.getS3Client().getObject(new GetObjectRequest(this.bucketName, key));
    }

    public void getObject(String key, String versionId) {
        this.getS3Client().getObject(new GetObjectRequest(this.bucketName, key, versionId));
    }

    public void createOrReplaceObject(String key, File file) {
        this.getS3Client().putObject(this.bucketName, key, file);
    }

    public boolean doesBucketExist(String bucketName) {
        return this.getS3Client().doesBucketExistV2(bucketName);
    }

    public boolean exists(String key) {
        return this.getS3Client().doesObjectExist(this.bucketName, key);
    }

    public List<S3ObjectSummary> listWithPrefix(String prefix) {
        ObjectListing result = this.getS3Client().listObjects(this.bucketName, prefix);
        return result.getObjectSummaries();
    }

    public List<S3ObjectSummary> listWithPattern(String pattern) {
        List<S3ObjectSummary> list = null;
        if (pattern.startsWith("*")) {
            list = this.list();
        } else {
            String prefix = pattern.split("\\*")[0];
            list = this.listWithPrefix(prefix);
        }
        return list.stream().filter(ea -> StringUtil.matches((String)ea.getKey(), (String)pattern)).collect(Collectors.toList());
    }

    public List<S3ObjectSummary> list() {
        ObjectListing result = this.getS3Client().listObjects(this.bucketName);
        return result.getObjectSummaries();
    }

    public List<S3VersionSummary> listVersions(String prefix) {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(this.bucketName).withPrefix(prefix).withMaxResults(Integer.valueOf(100));
        VersionListing result = this.s3Client.listVersions(request);
        return result.getVersionSummaries();
    }

    public List<S3VersionSummary> listVersionsWithPattern(String pattern) {
        List names = this.listWithPattern(pattern).stream().map(ea -> ea.getKey()).collect(Collectors.toList());
        return names.stream().flatMap(ea -> this.listVersions((String)ea).stream()).collect(Collectors.toList());
    }

    public PositionableReadStream openPositionableReadStream(String key) {
        return new PositionableReadStream(this, key, this.getObjectMetadata(key, null), 0L, 65536);
    }

    public PositionableReadStream openPositionableReadStream(String key, String versionId) {
        return new PositionableReadStream(this, key, this.getObjectMetadata(key, versionId), 0L, 65536);
    }

    public PositionableReadStream openPositionableReadStream(String key, long position) {
        return new PositionableReadStream(this, key, this.getObjectMetadata(key, null), 0L, 65536);
    }

    public PositionableReadStream openPositionableReadStream(String key, String versionId, long position) {
        return new PositionableReadStream(this, key, this.getObjectMetadata(key, versionId), 0L, 65536);
    }

    public PositionableReadStream openPositionableReadStream(String key, ObjectMetadata metadata, long position) {
        return new PositionableReadStream(this, key, metadata, position, 65536);
    }

    public ObjectMetadata getObjectMetadata(String key, String versionId) {
        return this.s3Client.getObjectMetadata(new GetObjectMetadataRequest(this.bucketName, key, versionId));
    }

    public boolean getRange(String file, long position, int[] buffer) {
        GetObjectRequest request = new GetObjectRequest(this.bucketName, file).withRange(position, position + (long)buffer.length - 1L);
        return this.getRange(request, buffer);
    }

    public boolean getRange(String file, String versionId, long position, int[] buffer) {
        GetObjectRequest request = new GetObjectRequest(this.bucketName, file, versionId).withRange(position, position + (long)buffer.length - 1L);
        return this.getRange(request, buffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getRange(GetObjectRequest request, int[] buffer) {
        try (S3Object s3Object = this.s3Client.getObject(request);){
            int next;
            int index = 0;
            S3ObjectInputStream stream = s3Object.getObjectContent();
            while ((next = stream.read()) != -1) {
                buffer[index++] = next;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getVersionId(String key) {
        return null;
    }
}

