/*
 * Decompiled with CFR 0.152.
 */
package com.kroegerama.kaiteki.bcode.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ColorInt;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.kroegerama.kaiteki.bcode.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0014J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001bJ&\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010&\u001a\u00020\u00172\b\b\u0001\u0010'\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/kroegerama/kaiteki/bcode/views/ResultPointView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "pPoints", "Landroid/graphics/Paint;", "rect", "Landroid/graphics/RectF;", "resultPoints", "", "value", "", "showResultPoints", "getShowResultPoints", "()Z", "setShowResultPoints", "(Z)V", "clear", "", "createMatrix", "Landroid/graphics/Matrix;", "imageWidth", "", "imageHeight", "imageRotation", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setPointSize", "size", "setResult", "result", "Lcom/google/zxing/Result;", "setResultPointColor", "color", "barcode.kaiteki"})
public final class ResultPointView
extends View {
    private final Paint pPoints;
    private float[] resultPoints;
    private RectF rect;
    private boolean showResultPoints;

    public final boolean getShowResultPoints() {
        return this.showResultPoints;
    }

    public final void setShowResultPoints(boolean value) {
        this.showResultPoints = value;
        this.invalidate();
    }

    public final void setResultPointColor(@ColorInt int color) {
        this.pPoints.setColor(color);
        this.invalidate();
    }

    public final void setPointSize(float size) {
        this.pPoints.setStrokeWidth(size);
    }

    public final void clear() {
        this.resultPoints = new float[0];
        this.postInvalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setResult(@NotNull Result result, int imageWidth, int imageHeight, int imageRotation) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.showResultPoints) {
            return;
        }
        Matrix localMatrix = this.createMatrix(imageWidth, imageHeight, imageRotation);
        ResultPoint[] resultPointArray = result.getResultPoints();
        Intrinsics.checkNotNullExpressionValue((Object)resultPointArray, (String)"result.resultPoints");
        ResultPoint[] resultPointArray2 = resultPointArray;
        ResultPointView resultPointView = this;
        boolean $i$f$flatMap = false;
        void var8_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var11_12 = $this$flatMapTo$iv$iv;
        int n = ((void)var11_12).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var11_12[i];
            boolean bl = false;
            Object[] objectArray = new Float[2];
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            objectArray[0] = Float.valueOf(v2.getX());
            objectArray[1] = Float.valueOf(it.getY());
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        resultPointView.resultPoints = CollectionsKt.toFloatArray((Collection)list);
        localMatrix.mapPoints(this.resultPoints);
        this.postInvalidate();
    }

    private final Matrix createMatrix(float imageWidth, float imageHeight, int imageRotation) {
        Matrix matrix = new Matrix();
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$apply = matrix;
        boolean bl3 = false;
        $this$apply.preTranslate(((float)this.getWidth() - imageWidth) / 2.0f, ((float)this.getHeight() - imageHeight) / 2.0f);
        $this$apply.preRotate((float)imageRotation, imageWidth / 2.0f, imageHeight / 2.0f);
        float wScale = 0.0f;
        float hScale = 0.0f;
        if (imageRotation % 180 == 0) {
            wScale = (float)this.getWidth() / imageWidth;
            hScale = (float)this.getHeight() / imageHeight;
        } else {
            wScale = (float)this.getHeight() / imageWidth;
            hScale = (float)this.getWidth() / imageHeight;
        }
        boolean bl4 = false;
        float scale = Math.max(wScale, hScale);
        $this$apply.preScale(scale, scale, imageWidth / 2.0f, imageHeight / 2.0f);
        return matrix;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.showResultPoints) {
            canvas.drawPoints(this.resultPoints, this.pPoints);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ResultPointView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$withStyledAttributes$iv;
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        ResultPointView resultPointView = this;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setColor(-16711936);
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        $this$apply.setStrokeWidth(TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        $this$apply.setStrokeCap(Paint.Cap.ROUND);
        Unit unit = Unit.INSTANCE;
        resultPointView.pPoints = paint;
        this.resultPoints = new float[0];
        this.rect = new RectF();
        this.showResultPoints = true;
        paint = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.ResultPointView, (String)"Style.ResultPointView");
        int[] attrs$iv = R.styleable.ResultPointView;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, attrs$iv, defStyleAttr, defStyleRes$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        TypedArray $this$withStyledAttributes = typedArray;
        boolean bl6 = false;
        this.setShowResultPoints($this$withStyledAttributes.getBoolean(R.styleable.ResultPointView_showResultPoints, this.showResultPoints));
        this.pPoints.setColor($this$withStyledAttributes.getColor(R.styleable.ResultPointView_resultPointColor, this.pPoints.getColor()));
        this.pPoints.setStrokeWidth($this$withStyledAttributes.getDimension(R.styleable.ResultPointView_resultPointSize, this.pPoints.getStrokeWidth()));
        typedArray.recycle();
    }

    public /* synthetic */ ResultPointView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ResultPointView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ResultPointView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

