/*
 * Decompiled with CFR 0.152.
 */
package com.kroegerama.kaiteki.bcode.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Size;
import android.util.SizeF;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.lifecycle.LifecycleOwner;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.kroegerama.kaiteki.bcode.BarcodeAnalyzer;
import com.kroegerama.kaiteki.bcode.BarcodeResultListener;
import com.kroegerama.kaiteki.bcode.Debouncer;
import com.kroegerama.kaiteki.bcode.R;
import com.kroegerama.kaiteki.bcode.ResultListener;
import com.kroegerama.kaiteki.bcode.databinding.BarcodeViewBinding;
import com.kroegerama.kaiteki.bcode.views.BarcodeView;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020&H\u0016J(\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0016J\u000e\u00100\u001a\u00020&2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020&2\u0006\u0010!\u001a\u00020\"J\u0014\u00104\u001a\u00020&2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706J\u0006\u00108\u001a\u00020&R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\n \u001b*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/kroegerama/kaiteki/bcode/views/BarcodeView;", "Landroid/widget/FrameLayout;", "Lcom/kroegerama/kaiteki/bcode/ResultListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "analyzer", "Lcom/kroegerama/kaiteki/bcode/BarcodeAnalyzer;", "getAnalyzer", "()Lcom/kroegerama/kaiteki/bcode/BarcodeAnalyzer;", "analyzer$delegate", "Lkotlin/Lazy;", "barcodeReader", "Lcom/google/zxing/MultiFormatReader;", "getBarcodeReader", "()Lcom/google/zxing/MultiFormatReader;", "barcodeReader$delegate", "binding", "Lcom/kroegerama/kaiteki/bcode/databinding/BarcodeViewBinding;", "bufferSize", "Landroid/util/SizeF;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "kotlin.jvm.PlatformType", "getCameraProvider", "()Landroidx/camera/lifecycle/ProcessCameraProvider;", "cameraProvider$delegate", "executor", "Ljava/util/concurrent/ExecutorService;", "listener", "Lcom/kroegerama/kaiteki/bcode/BarcodeResultListener;", "resultDebouncer", "Lcom/kroegerama/kaiteki/bcode/Debouncer;", "bindToLifecycle", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onNoResult", "onResult", "result", "Lcom/google/zxing/Result;", "imageWidth", "imageHeight", "imageRotation", "setBarcodeInverted", "inverted", "", "setBarcodeResultListener", "setFormats", "formats", "", "Lcom/google/zxing/BarcodeFormat;", "unbind", "barcode.kaiteki"})
public final class BarcodeView
extends FrameLayout
implements ResultListener {
    private final ExecutorService executor;
    private final BarcodeViewBinding binding;
    private final Lazy cameraProvider$delegate;
    private SizeF bufferSize;
    private BarcodeResultListener listener;
    private final Lazy barcodeReader$delegate;
    private final Lazy analyzer$delegate;
    private final Debouncer resultDebouncer;

    private final ProcessCameraProvider getCameraProvider() {
        Lazy lazy = this.cameraProvider$delegate;
        BarcodeView barcodeView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProcessCameraProvider)lazy.getValue();
    }

    private final MultiFormatReader getBarcodeReader() {
        Lazy lazy = this.barcodeReader$delegate;
        BarcodeView barcodeView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MultiFormatReader)lazy.getValue();
    }

    private final BarcodeAnalyzer getAnalyzer() {
        Lazy lazy = this.analyzer$delegate;
        BarcodeView barcodeView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BarcodeAnalyzer)lazy.getValue();
    }

    @Override
    public void onResult(@NotNull Result result, int imageWidth, int imageHeight, int imageRotation) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.binding.resultView.setResult(result, imageWidth, imageHeight, imageRotation);
        Boolean d2 = (Boolean)this.resultDebouncer.invoke((Function0)new Function0<Boolean>(this, result){
            final /* synthetic */ BarcodeView this$0;
            final /* synthetic */ Result $result;

            @Nullable
            public final Boolean invoke() {
                BarcodeResultListener barcodeResultListener = BarcodeView.access$getListener$p(this.this$0);
                return barcodeResultListener != null ? Boolean.valueOf(barcodeResultListener.onBarcodeResult(this.$result)) : null;
            }
            {
                this.this$0 = barcodeView;
                this.$result = result;
                super(0);
            }
        });
        if (Intrinsics.areEqual((Object)d2, (Object)true)) {
            this.listener = null;
        }
    }

    @Override
    public void onNoResult() {
        this.binding.resultView.clear();
    }

    public final void setBarcodeResultListener(@NotNull BarcodeResultListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public final void setBarcodeInverted(boolean inverted) {
        this.getAnalyzer().setInverted(inverted);
    }

    public final void bindToLifecycle(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Preview preview = new Preview.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"Preview.Builder()\n            .build()");
        Preview preview2 = preview;
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026ACK)\n            .build()");
        CameraSelector cameraSelector2 = cameraSelector;
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder();
        boolean bl = false;
        boolean bl2 = false;
        ImageAnalysis.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setTargetResolution(new Size(640, 480));
        $this$apply.setBackpressureStrategy(0);
        builder = builder.build();
        bl = false;
        bl2 = false;
        $this$apply = builder;
        boolean bl4 = false;
        $this$apply.setAnalyzer((Executor)this.executor, (ImageAnalysis.Analyzer)this.getAnalyzer());
        ImageAnalysis.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"ImageAnalysis.Builder().\u2026utor, analyzer)\n        }");
        ImageAnalysis.Builder analysis = builder2;
        this.getCameraProvider().unbindAll();
        PreviewView previewView = this.binding.previewView;
        Intrinsics.checkNotNullExpressionValue((Object)previewView, (String)"binding.previewView");
        preview2.setSurfaceProvider(previewView.getSurfaceProvider());
        this.getCameraProvider().bindToLifecycle(owner, cameraSelector2, new UseCase[]{(UseCase)preview2, (UseCase)analysis});
    }

    public final void unbind() {
        this.binding.resultView.clear();
        this.listener = null;
        this.getCameraProvider().unbindAll();
    }

    public final void setFormats(@NotNull List<? extends BarcodeFormat> formats2) {
        Intrinsics.checkNotNullParameter(formats2, (String)"formats");
        this.getBarcodeReader().setHints(MapsKt.mapOf((Pair)TuplesKt.to((Object)DecodeHintType.POSSIBLE_FORMATS, formats2)));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BarcodeView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$withStyledAttributes$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.executor = Executors.newFixedThreadPool(1);
        BarcodeViewBinding barcodeViewBinding = BarcodeViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeViewBinding, (String)"BarcodeViewBinding.infla\u2026ater.from(context), this)");
        this.binding = barcodeViewBinding;
        this.cameraProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProcessCameraProvider>(context){
            final /* synthetic */ Context $context;

            public final ProcessCameraProvider invoke() {
                return (ProcessCameraProvider)ProcessCameraProvider.getInstance((Context)this.$context).get();
            }
            {
                this.$context = context;
                super(0);
            }
        }));
        this.bufferSize = new SizeF(0.0f, 0.0f);
        this.barcodeReader$delegate = LazyKt.lazy((Function0)barcodeReader.2.INSTANCE);
        this.analyzer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BarcodeAnalyzer>(this){
            final /* synthetic */ BarcodeView this$0;

            @NotNull
            public final BarcodeAnalyzer invoke() {
                return new BarcodeAnalyzer(this.this$0, BarcodeView.access$getBarcodeReader$p(this.this$0));
            }
            {
                this.this$0 = barcodeView;
                super(0);
            }
        }));
        this.resultDebouncer = new Debouncer(500);
        this.setKeepScreenOn(true);
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.BarcodeView, (String)"Style.BarcodeView");
        int[] attrs$iv = R.styleable.BarcodeView;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, attrs$iv, defStyleAttr, defStyleRes$iv);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$withStyledAttributes = typedArray;
        boolean bl3 = false;
        this.binding.resultView.setShowResultPoints($this$withStyledAttributes.getBoolean(R.styleable.BarcodeView_showResultPoints, true));
        this.binding.resultView.setResultPointColor($this$withStyledAttributes.getColor(R.styleable.BarcodeView_resultPointColor, -16711936));
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        float defaultSize = TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.binding.resultView.setPointSize($this$withStyledAttributes.getDimension(R.styleable.BarcodeView_resultPointSize, defaultSize));
        this.getAnalyzer().setInverted($this$withStyledAttributes.getBoolean(R.styleable.BarcodeView_barcodeInverted, false));
        typedArray.recycle();
    }

    public /* synthetic */ BarcodeView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BarcodeView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BarcodeView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ BarcodeResultListener access$getListener$p(BarcodeView $this) {
        return $this.listener;
    }

    public static final /* synthetic */ void access$setListener$p(BarcodeView $this, BarcodeResultListener barcodeResultListener) {
        $this.listener = barcodeResultListener;
    }

    public static final /* synthetic */ MultiFormatReader access$getBarcodeReader$p(BarcodeView $this) {
        return $this.getBarcodeReader();
    }
}

