/*
 * Decompiled with CFR 0.152.
 */
package com.kroegerama.kaiteki.bcode.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.lifecycle.LifecycleOwner;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.kroegerama.kaiteki.bcode.BarcodeResultListener;
import com.kroegerama.kaiteki.bcode.R;
import com.kroegerama.kaiteki.bcode.UtilsKt;
import com.kroegerama.kaiteki.bcode.ui.BarcodeAlertDialogKt;
import com.kroegerama.kaiteki.bcode.views.BarcodeView;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"showBarcodeAlertDialog", "", "Landroid/content/Context;", "owner", "Landroidx/lifecycle/LifecycleOwner;", "listener", "Lcom/kroegerama/kaiteki/bcode/BarcodeResultListener;", "formats", "", "Lcom/google/zxing/BarcodeFormat;", "barcodeInverted", "", "barcode.kaiteki"})
public final class BarcodeAlertDialogKt {
    public static final void showBarcodeAlertDialog(@NotNull Context $this$showBarcodeAlertDialog, @NotNull LifecycleOwner owner, @NotNull BarcodeResultListener listener, @NotNull List<? extends BarcodeFormat> formats2, boolean barcodeInverted2) {
        Intrinsics.checkNotNullParameter((Object)$this$showBarcodeAlertDialog, (String)"$this$showBarcodeAlertDialog");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter(formats2, (String)"formats");
        if (!UtilsKt.getHasCameraPermission($this$showBarcodeAlertDialog)) {
            Log.w((String)"BarcodeAlertDialog", (String)"Camera permission required");
            Toast.makeText((Context)$this$showBarcodeAlertDialog, (CharSequence)"Camera permission required", (int)1).show();
            return;
        }
        View view = LayoutInflater.from((Context)$this$showBarcodeAlertDialog).inflate(R.layout.dlg_barcode, null, false);
        BarcodeView bcode = (BarcodeView)view.findViewById(R.id.bcode);
        Handler handler = new Handler(Looper.getMainLooper());
        AlertDialog dlg2 = new AlertDialog.Builder($this$showBarcodeAlertDialog).setOnDismissListener(new DialogInterface.OnDismissListener(bcode){
            final /* synthetic */ BarcodeView $bcode;

            public final void onDismiss(DialogInterface it) {
                this.$bcode.unbind();
            }
            {
                this.$bcode = barcodeView;
            }
        }).setView(view).setOnCancelListener(new DialogInterface.OnCancelListener(listener){
            final /* synthetic */ BarcodeResultListener $listener;

            public final void onCancel(DialogInterface it) {
                this.$listener.onBarcodeScanCancelled();
            }
            {
                this.$listener = barcodeResultListener;
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(listener){
            final /* synthetic */ BarcodeResultListener $listener;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                this.$listener.onBarcodeScanCancelled();
            }
            {
                this.$listener = barcodeResultListener;
            }
        }).show();
        bcode.setFormats(formats2);
        bcode.setBarcodeInverted(barcodeInverted2);
        bcode.setBarcodeResultListener(new BarcodeResultListener(listener, handler, dlg2){
            final /* synthetic */ BarcodeResultListener $listener;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ AlertDialog $dlg;

            /*
             * WARNING - void declaration
             */
            public boolean onBarcodeResult(@NotNull Result result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                boolean doDismiss = this.$listener.onBarcodeResult(result);
                if (doDismiss) {
                    void $this$postDelayed$iv;
                    Handler handler = this.$handler;
                    long delayInMillis$iv = 500L;
                    Object token$iv = null;
                    boolean $i$f$postDelayed = false;
                    Runnable runnable$iv = new Runnable(this){
                        final /* synthetic */ showBarcodeAlertDialog.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.$dlg.dismiss();
                        }
                    };
                    $this$postDelayed$iv.postDelayed(runnable$iv, delayInMillis$iv);
                }
                return doDismiss;
            }

            public void onBarcodeScanCancelled() {
            }
            {
                this.$listener = $captured_local_variable$0;
                this.$handler = $captured_local_variable$1;
                this.$dlg = $captured_local_variable$2;
            }
        });
        bcode.bindToLifecycle(owner);
    }

    public static /* synthetic */ void showBarcodeAlertDialog$default(Context context, LifecycleOwner lifecycleOwner, BarcodeResultListener barcodeResultListener, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)BarcodeFormat.QR_CODE);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        BarcodeAlertDialogKt.showBarcodeAlertDialog(context, lifecycleOwner, barcodeResultListener, list, bl);
    }
}

