/*
 * Decompiled with CFR 0.152.
 */
package com.kroegerama.kaiteki.bcode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import com.google.zxing.PlanarYUVLuminanceSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0000\u001a\n \u0003*\u0004\u0018\u00010\u00010\u0001*\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"toBitmap", "Landroid/graphics/Bitmap;", "Landroid/media/Image;", "kotlin.jvm.PlatformType", "Lcom/google/zxing/PlanarYUVLuminanceSource;", "barcode.kaiteki"})
public final class DebugUtilsKt {
    @NotNull
    public static final Bitmap toBitmap(@NotNull Image $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"$this$toBitmap");
        Image.Plane plane = $this$toBitmap.getPlanes()[0];
        Intrinsics.checkNotNullExpressionValue((Object)plane, (String)"planes[0]");
        ByteBuffer yBuffer = plane.getBuffer();
        Image.Plane plane2 = $this$toBitmap.getPlanes()[1];
        Intrinsics.checkNotNullExpressionValue((Object)plane2, (String)"planes[1]");
        ByteBuffer uBuffer = plane2.getBuffer();
        Image.Plane plane3 = $this$toBitmap.getPlanes()[2];
        Intrinsics.checkNotNullExpressionValue((Object)plane3, (String)"planes[2]");
        ByteBuffer vBuffer = plane3.getBuffer();
        int ySize = yBuffer.remaining();
        int uSize = uBuffer.remaining();
        int vSize = vBuffer.remaining();
        byte[] nv21 = new byte[ySize + uSize + vSize];
        yBuffer.get(nv21, 0, ySize);
        vBuffer.get(nv21, ySize, vSize);
        uBuffer.get(nv21, ySize + vSize, uSize);
        YuvImage yuvImage = new YuvImage(nv21, 17, $this$toBitmap.getWidth(), $this$toBitmap.getHeight(), null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 50, (OutputStream)out);
        byte[] imageBytes = out.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeByte\u2026ytes, 0, imageBytes.size)");
        return bitmap;
    }

    public static final Bitmap toBitmap(@NotNull PlanarYUVLuminanceSource $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"$this$toBitmap");
        return Bitmap.createBitmap((int[])$this$toBitmap.renderThumbnail(), (int)$this$toBitmap.getThumbnailWidth(), (int)$this$toBitmap.getThumbnailHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

