/*
 * Decompiled with CFR 0.152.
 */
package com.kroegerama.kaiteki.bcode;

import android.annotation.SuppressLint;
import android.media.Image;
import android.util.Log;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.kroegerama.kaiteki.bcode.ResultListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/kroegerama/kaiteki/bcode/BarcodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "listener", "Lcom/kroegerama/kaiteki/bcode/ResultListener;", "reader", "Lcom/google/zxing/MultiFormatReader;", "(Lcom/kroegerama/kaiteki/bcode/ResultListener;Lcom/google/zxing/MultiFormatReader;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "inverted", "getInverted", "setInverted", "analyze", "", "image", "Landroidx/camera/core/ImageProxy;", "Companion", "barcode.kaiteki"})
public final class BarcodeAnalyzer
implements ImageAnalysis.Analyzer {
    private boolean enabled;
    private boolean inverted;
    private final ResultListener listener;
    private final MultiFormatReader reader;
    private static final String TAG = "BarcodeAnalyzer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    public final void setInverted(boolean bl) {
        this.inverted = bl;
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    public void analyze(@NotNull ImageProxy image) {
        Buffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (!this.enabled) {
            return;
        }
        if (35 != image.getFormat() && 39 != image.getFormat() && 40 != image.getFormat()) {
            Log.e((String)TAG, (String)("Unexpected format: " + image.getFormat()));
            this.listener.onNoResult();
            return;
        }
        Image.Plane plane = image.getImage();
        Buffer buffer = plane != null && (plane = plane.getPlanes()) != null && (plane = (Image.Plane)ArraysKt.firstOrNull((Object[])plane)) != null ? plane.getBuffer() : (byteBuffer = null);
        if (byteBuffer == null) {
            this.listener.onNoResult();
            return;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        boolean bl = false;
        boolean bl2 = false;
        Object it = byArray;
        boolean bl3 = false;
        ((ByteBuffer)byteBuffer).get((byte[])it);
        byte[] data = byArray;
        int width = image.getWidth();
        int height = image.getHeight();
        it = new PlanarYUVLuminanceSource(data, width, height, 0, 0, width, height, false);
        bl3 = false;
        boolean bl4 = false;
        Object it2 = it;
        boolean bl5 = false;
        LuminanceSource source = this.inverted ? it2.invert() : (LuminanceSource)it2;
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source));
        try {
            Result result;
            Result result2 = result = this.reader.decodeWithState(bitmap);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
            ImageInfo imageInfo = image.getImageInfo();
            Intrinsics.checkNotNullExpressionValue((Object)imageInfo, (String)"image.imageInfo");
            this.listener.onResult(result2, width, height, imageInfo.getRotationDegrees());
        }
        catch (Exception e) {
            this.listener.onNoResult();
        }
        image.close();
    }

    public BarcodeAnalyzer(@NotNull ResultListener listener, @NotNull MultiFormatReader reader) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.listener = listener;
        this.reader = reader;
        this.enabled = true;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kroegerama/kaiteki/bcode/BarcodeAnalyzer$Companion;", "", "()V", "TAG", "", "barcode.kaiteki"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

