/*
 * Decompiled with CFR 0.152.
 */
package com.krinyny.reactive;

import com.krinyny.reactive.EventBus;
import io.reactivex.Flowable;
import io.reactivex.processors.BehaviorProcessor;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import io.reactivex.processors.ReplayProcessor;

public class EventProcessor<T> {
    EventBus.EventType type = EventBus.EventType.Publish;
    private FlowableProcessor<T> eventProcessor;

    public EventProcessor(EventBus.EventType type) {
        this.type = type;
        switch (type) {
            case Behavior: {
                this.eventProcessor = BehaviorProcessor.create().toSerialized();
                break;
            }
            case Replay: {
                this.eventProcessor = ReplayProcessor.create().toSerialized();
                break;
            }
            default: {
                this.eventProcessor = PublishProcessor.create().toSerialized();
            }
        }
    }

    public void process(T o) {
        this.eventProcessor.onNext(o);
    }

    public Flowable<T> toFlowable() {
        return this.eventProcessor;
    }
}

