/*
 * Decompiled with CFR 0.152.
 */
package com.krinyny.reactive;

import android.util.Log;
import com.krinyny.reactive.EventProcessor;
import io.reactivex.Flowable;
import java.util.HashMap;

public class EventBus {
    private static HashMap<Class, HashMap<EventType, EventProcessor>> processorTypeMap = new HashMap();

    public static <T> Flowable<T> getFlowable(Class<T> eventClass, EventType type) {
        return EventBus.getProcessorQueue(eventClass, type).toFlowable();
    }

    public static <T> Flowable<T> getFlowable(Class<T> eventClass) {
        return EventBus.getFlowable(eventClass, EventType.Publish);
    }

    public static <R> void publishEvent(R event, EventType type) {
        EventProcessor<?> queue = EventBus.getProcessorQueue(event.getClass(), type);
        try {
            queue.process(event);
        }
        catch (Exception ex) {
            Log.e((String)"EventBus", (String)ex.getMessage());
        }
    }

    public static <R> void publishEvent(R event) {
        EventBus.publishEvent(event, EventType.Publish);
    }

    private static synchronized <T> EventProcessor<T> getProcessorQueue(Class<T> event, EventType type) {
        EventProcessor<Object> eventProcessor;
        if (processorTypeMap.containsKey(event)) {
            HashMap<EventType, EventProcessor<Object>> eventProcessorMap = processorTypeMap.get(event);
            if (eventProcessorMap == null) {
                eventProcessorMap = new HashMap();
                processorTypeMap.put(event, eventProcessorMap);
            }
            if (eventProcessorMap.containsKey((Object)type)) {
                eventProcessor = eventProcessorMap.get((Object)type);
            } else {
                eventProcessor = new EventProcessor(type);
                eventProcessorMap.put(type, eventProcessor);
            }
        } else {
            HashMap eventProcessorMap = new HashMap();
            eventProcessor = new EventProcessor(type);
            eventProcessorMap.put(type, eventProcessor);
            processorTypeMap.put(event, eventProcessorMap);
        }
        return eventProcessor;
    }

    public static enum EventType {
        Behavior,
        Replay,
        Publish;

    }
}

