/*
 * Decompiled with CFR 0.152.
 */
package com.kraftics.krafticslib.packet;

import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflection {
    private final String version;

    public Reflection(String version) {
        this.version = version;
    }

    public Reflection() throws IllegalStateException {
        this(Reflection.detectVersion());
    }

    @NotNull
    public static String detectVersion() throws IllegalStateException {
        try {
            return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("Could not detect version using this server", e);
        }
    }

    @Nullable
    public Class<?> getNMSClass(@NotNull String path) {
        Validate.notNull((Object)path, (String)"Path cannot be null");
        try {
            return Class.forName("net.minecraft.server." + this.version + '.' + path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public Class<?> getCraftClass(@NotNull String path) {
        Validate.notNull((Object)path, (String)"Path cannot be null");
        try {
            return Class.forName("org.bukkit.craftbukkit." + this.version + '.' + path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

