/*
 * Decompiled with CFR 0.152.
 */
package com.kraftics.krafticslib.packet;

import com.kraftics.krafticslib.packet.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketProcessor {
    private final Reflection reflection;
    private final MethodHandle getHandle;
    private final MethodHandle playerConnection;
    private final MethodHandle sendPacket;
    private final MethodHandle ping;

    public PacketProcessor(@NotNull Reflection reflection) throws IllegalArgumentException {
        Validate.notNull((Object)reflection, (String)"Reflection cannot be null");
        this.reflection = reflection;
        try {
            Class<?> entityPlayerClass = reflection.getNMSClass("EntityPlayer");
            Class<?> craftPlayerClass = reflection.getCraftClass("entity.CraftPlayer");
            Class<?> playerConnectionClass = reflection.getNMSClass("PlayerConnection");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this.getHandle = lookup.findVirtual(craftPlayerClass, "getHandle", MethodType.methodType(entityPlayerClass));
            this.playerConnection = lookup.findGetter(entityPlayerClass, "playerConnection", playerConnectionClass);
            this.sendPacket = lookup.findVirtual(playerConnectionClass, "sendPacket", MethodType.methodType(Void.TYPE, reflection.getNMSClass("Packet")));
            this.ping = lookup.findGetter(entityPlayerClass, "ping", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid reflection", e);
        }
    }

    public boolean sendPacket(@NotNull Player player, @NotNull Object packet) {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        Validate.notNull((Object)packet, (String)"Packet cannot be null");
        try {
            Object connection = this.getPlayerConnection(player);
            if (connection == null) {
                return false;
            }
            this.sendPacket.invoke(connection, packet);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object getPlayerConnection(@NotNull Player player) throws IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        try {
            Object handle = this.getHandle.invoke(player);
            return this.playerConnection.invoke(handle);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public int getPing(@NotNull Player player) {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        try {
            Object handle = this.getHandle.invoke(player);
            return this.ping.invoke(handle);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public MethodHandle getGetHandleHandle() {
        return this.getHandle;
    }

    public MethodHandle getPlayerConnectionHandle() {
        return this.playerConnection;
    }

    public MethodHandle getSendPacketHandle() {
        return this.sendPacket;
    }

    public MethodHandle getPingHandle() {
        return this.ping;
    }

    public Reflection getReflection() {
        return this.reflection;
    }
}

