/*
 * Decompiled with CFR 0.152.
 */
package com.kozaris.android.k_mqtt;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import android.util.Log;
import com.kozaris.android.k_mqtt.Connection;
import com.kozaris.android.k_mqtt.PersistenceException;
import com.kozaris.android.k_mqtt.Subscription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class Persistence
extends SQLiteOpenHelper
implements BaseColumns {
    private static final String TAG = "Persistence";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = "mqttclient.db";
    private static final String TABLE_CONNECTIONS = "mqttclient";
    private static final String COLUMN_HOST = "host";
    private static final String COLUMN_client_ID = "clientID";
    private static final String COLUMN_port = "port";
    private static final String COLUMN_ssl = "ssl";
    private static final String COLUMN_TIME_OUT = "timeout";
    private static final String COLUMN_KEEP_ALIVE = "keepalive";
    private static final String COLUMN_USER_NAME = "username";
    private static final String COLUMN_PASSWORD = "password";
    private static final String COLUMN_CLEAN_SESSION = "cleanSession";
    private static final String COLUMN_TOPIC = "topic";
    private static final String COLUMN_MESSAGE = "message";
    private static final String COLUMN_QOS = "qos";
    private static final String COLUMN_RETAINED = "retained";
    private static final String TABLE_SUBSCRIPTIONS = "subscriptions";
    private static final String SUBSCRIPTIONS_COLUMN_TOPIC = "topic";
    private static final String SUBSCRIPTIONS_COLUMN_QOS = "qos";
    private static final String SUBSCRIPTIONS_COLUMN_NOTIFY = "notify";
    private static final String TEXT_TYPE = " TEXT";
    private static final String INT_TYPE = " INTEGER";
    private static final String COMMA_SEP = ",";
    private static final String SQL_CREATE_ENTRIES = "CREATE TABLE mqttclient (_id INTEGER PRIMARY KEY,host TEXT,clientID TEXT,port INTEGER,ssl INTEGER,timeout INTEGER,keepalive INTEGER,username TEXT,password TEXT,cleanSession INTEGER,topic TEXT,message TEXT,qos INTEGER,retained INTEGER);";
    private static final String SQL_CREATE_SUBSCRIPTION_ENTRIES = "CREATE TABLE subscriptions (_id INTEGER PRIMARY KEY,clientID TEXT,host TEXT,topic TEXT,notify INTEGER,qos INTEGER);";
    private static final String SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS mqttclient";
    private static final String SQL_DELETE_SUBSCRIPTION_ENTRIES = "DROP TABLE IF EXISTS subscriptions";

    public Persistence(Context context) {
        super(context, DATABASE_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_ENTRIES);
        db.execSQL(SQL_CREATE_SUBSCRIPTION_ENTRIES);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(SQL_DELETE_ENTRIES);
        db.execSQL(SQL_DELETE_SUBSCRIPTION_ENTRIES);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void persistConnection(Connection connection) throws PersistenceException {
        SQLiteDatabase db = this.getWritableDatabase();
        long newRowId = db.insert(TABLE_CONNECTIONS, null, this.getValues(connection));
        db.close();
        if (newRowId == -1L) {
            throw new PersistenceException("Failed to persist connection: " + connection.getId());
        }
        connection.assignPersistenceId(newRowId);
    }

    public void updateConnection(Connection connection) {
        SQLiteDatabase db = this.getWritableDatabase();
        String whereClause = "_id=?";
        String[] whereArgs = new String[]{String.valueOf(connection.persistenceId())};
        db.update(TABLE_CONNECTIONS, this.getValues(connection), whereClause, whereArgs);
    }

    private ContentValues getValues(Connection connection) {
        MqttConnectOptions conOpts = connection.getConnectionOptions();
        MqttMessage lastWill = conOpts.getWillMessage();
        ContentValues values = new ContentValues();
        values.put(COLUMN_HOST, connection.getHostName());
        values.put(COLUMN_port, Integer.valueOf(connection.getPort()));
        values.put(COLUMN_client_ID, connection.getId());
        values.put(COLUMN_ssl, Integer.valueOf(connection.isSSL()));
        values.put(COLUMN_KEEP_ALIVE, Integer.valueOf(conOpts.getKeepAliveInterval()));
        values.put(COLUMN_TIME_OUT, Integer.valueOf(conOpts.getConnectionTimeout()));
        values.put(COLUMN_USER_NAME, conOpts.getUserName());
        values.put("topic", conOpts.getWillDestination());
        char[] password = conOpts.getPassword();
        values.put(COLUMN_CLEAN_SESSION, Integer.valueOf(conOpts.isCleanSession() ? 1 : 0));
        values.put(COLUMN_PASSWORD, password != null ? String.valueOf(password) : null);
        values.put(COLUMN_MESSAGE, lastWill != null ? new String(lastWill.getPayload()) : null);
        values.put("qos", Integer.valueOf(lastWill != null ? lastWill.getQos() : 0));
        if (lastWill == null) {
            values.put(COLUMN_RETAINED, Integer.valueOf(0));
        } else {
            values.put(COLUMN_RETAINED, Integer.valueOf(lastWill.isRetained() ? 1 : 0));
        }
        return values;
    }

    public long persistSubscription(Subscription subscription) throws PersistenceException {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(COLUMN_client_ID, subscription.getclientId());
        values.put("topic", subscription.getTopic());
        values.put(SUBSCRIPTIONS_COLUMN_NOTIFY, Integer.valueOf(subscription.isEnableNotifications() ? 1 : 0));
        values.put("qos", Integer.valueOf(subscription.getQos()));
        long newRowId = db.insert(TABLE_SUBSCRIPTIONS, null, values);
        db.close();
        if (newRowId == -1L) {
            throw new PersistenceException("Failed to persist subscription: " + subscription.toString());
        }
        subscription.setPersistenceId(newRowId);
        return newRowId;
    }

    public void deleteSubscription(Subscription subscription) {
        Log.d((String)TAG, (String)("Deleting Subscription: " + subscription.toString()));
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete(TABLE_SUBSCRIPTIONS, "_id=?", new String[]{String.valueOf(subscription.getPersistenceId())});
        db.close();
    }

    public List<Connection> restoreConnections(Context context) throws PersistenceException {
        String[] connectionColumns = new String[]{COLUMN_HOST, COLUMN_port, COLUMN_client_ID, COLUMN_ssl, COLUMN_KEEP_ALIVE, COLUMN_CLEAN_SESSION, COLUMN_TIME_OUT, COLUMN_USER_NAME, COLUMN_PASSWORD, "topic", COLUMN_MESSAGE, COLUMN_RETAINED, "qos", "_id"};
        String[] subscriptionColumns = new String[]{COLUMN_client_ID, "topic", SUBSCRIPTIONS_COLUMN_NOTIFY, "qos", "_id"};
        String subscriptionWhereQuery = "clientID=?";
        String sort = COLUMN_HOST;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor c = db.query(TABLE_CONNECTIONS, connectionColumns, null, null, null, null, sort);
        ArrayList<Connection> list = new ArrayList<Connection>(c.getCount());
        for (int i = 0; i < c.getCount(); ++i) {
            if (!c.moveToNext()) {
                throw new PersistenceException("Failed restoring connection - count: " + c.getCount() + "loop iteration: " + i);
            }
            Long id = c.getLong(c.getColumnIndexOrThrow("_id"));
            String host = c.getString(c.getColumnIndexOrThrow(COLUMN_HOST));
            String clientID = c.getString(c.getColumnIndexOrThrow(COLUMN_client_ID));
            int port = c.getInt(c.getColumnIndexOrThrow(COLUMN_port));
            String username = c.getString(c.getColumnIndexOrThrow(COLUMN_USER_NAME));
            String password = c.getString(c.getColumnIndexOrThrow(COLUMN_PASSWORD));
            String topic = c.getString(c.getColumnIndexOrThrow("topic"));
            String message = c.getString(c.getColumnIndexOrThrow(COLUMN_MESSAGE));
            int qos = c.getInt(c.getColumnIndexOrThrow("qos"));
            int keepAlive = c.getInt(c.getColumnIndexOrThrow(COLUMN_KEEP_ALIVE));
            int timeout = c.getInt(c.getColumnIndexOrThrow(COLUMN_TIME_OUT));
            boolean cleanSession = c.getInt(c.getColumnIndexOrThrow(COLUMN_CLEAN_SESSION)) == 1;
            boolean retained = c.getInt(c.getColumnIndexOrThrow(COLUMN_RETAINED)) == 1;
            boolean ssl = c.getInt(c.getColumnIndexOrThrow(COLUMN_ssl)) == 1;
            MqttConnectOptions opts = new MqttConnectOptions();
            opts.setCleanSession(cleanSession);
            opts.setKeepAliveInterval(keepAlive);
            opts.setConnectionTimeout(timeout);
            opts.setPassword(password != null ? password.toCharArray() : null);
            opts.setUserName(username);
            if (topic != null) {
                opts.setWill(topic, message.getBytes(), qos, retained);
            }
            Connection connection = Connection.createConnection(clientID, host, port, context, ssl);
            connection.addConnectionOptions(opts);
            connection.assignPersistenceId(id);
            String[] args = new String[]{clientID};
            System.out.println("SUB: " + connection.toString());
            Cursor sub_c = db.query(TABLE_SUBSCRIPTIONS, subscriptionColumns, subscriptionWhereQuery, args, null, null, sort);
            ArrayList<Subscription> subscriptions = new ArrayList<Subscription>(sub_c.getCount());
            for (int x = 0; x < sub_c.getCount(); ++x) {
                if (!sub_c.moveToNext()) {
                    throw new PersistenceException("Failed restoring subscription - count: " + sub_c.getCount() + "loop iteration: " + x);
                }
                Long sub_id = sub_c.getLong(sub_c.getColumnIndexOrThrow("_id"));
                String sub_clientId = sub_c.getString(sub_c.getColumnIndexOrThrow(COLUMN_client_ID));
                String sub_topic = sub_c.getString(sub_c.getColumnIndexOrThrow("topic"));
                boolean sub_notify = sub_c.getInt(sub_c.getColumnIndexOrThrow(SUBSCRIPTIONS_COLUMN_NOTIFY)) == 1;
                int sub_qos = sub_c.getInt(sub_c.getColumnIndexOrThrow("qos"));
                Subscription sub = new Subscription(sub_topic, sub_qos, sub_clientId, sub_notify);
                sub.setPersistenceId(sub_id);
                Log.d((String)TAG, (String)("Restoring Subscription: " + sub.toString()));
                subscriptions.add(sub);
            }
            sub_c.close();
            connection.setSubscriptions(subscriptions);
            list.add(connection);
        }
        c.close();
        db.close();
        return list;
    }

    public void deleteConnection(Connection connection) {
        SQLiteDatabase db = this.getWritableDatabase();
        db.delete(TABLE_CONNECTIONS, "_id=?", new String[]{String.valueOf(connection.persistenceId())});
        db.close();
    }
}

