/*
 * Decompiled with CFR 0.152.
 */
package com.kozaris.android.k_mqtt;

import android.content.Context;
import com.kozaris.android.k_mqtt.Connection;
import com.kozaris.android.k_mqtt.Persistence;
import com.kozaris.android.k_mqtt.PersistenceException;
import java.util.List;

public class MqttClient {
    private static MqttClient instance = null;
    private Connection activeConnection = null;
    private Persistence persistence = null;

    private MqttClient(Context context) {
        this.persistence = new Persistence(context);
        try {
            List<Connection> connectionList = this.persistence.restoreConnections(context);
            if (connectionList.size() == 0) {
                return;
            }
            this.activeConnection = connectionList.get(connectionList.size() - 1);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public static synchronized MqttClient getInstance(Context context) {
        if (instance == null) {
            instance = new MqttClient(context);
        }
        return instance;
    }

    public Connection findConnectionByHost(Context context, String hostname) {
        try {
            List<Connection> connectionList = this.persistence.restoreConnections(context);
            for (Connection connection : connectionList) {
                if (!connection.getHostName().equalsIgnoreCase(hostname)) continue;
                return connection;
            }
            return null;
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setConnection(Context context, Connection connection) {
        Connection dbConnection = this.findConnectionByHost(context, connection.getHostName());
        if (dbConnection != null) {
            connection.assignPersistenceId(dbConnection.persistenceId());
            this.updateConnection(connection);
        } else {
            this.addConnectionToDB(connection);
        }
        this.activeConnection = connection;
    }

    private void addConnectionToDB(Connection connection) {
        try {
            this.persistence.persistConnection(connection);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.activeConnection;
    }

    public List<Connection> getConnectionList(Context context) {
        try {
            return this.persistence.restoreConnections(context);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeConnection() {
        this.persistence.deleteConnection(this.activeConnection);
        this.activeConnection = null;
    }

    private void updateConnection(Connection connection) {
        this.activeConnection = connection;
        this.persistence.updateConnection(connection);
    }
}

